/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.ui.runnable.OpenRepresentationsRunnable;

public class OpenRepresentationsAction
extends BaseSelectionListenerAction {
    private static final Logger LOGGER = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private List<DRepresentation> representations;
    private boolean parent = false;

    public OpenRepresentationsAction() {
        super("Open");
    }

    public OpenRepresentationsAction(RepresentationDescription description, DRepresentation drep) {
        super(drep.getName());
        this.parent = true;
        this.representations = new ArrayList<DRepresentation>();
        this.representations.add(drep);
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = description instanceof CrossTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/CrossTableDescription.gif") : (description instanceof EditionTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/DTable.gif") : (description instanceof SequenceDiagramDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.diagram.sequence.edit", (String)"/icons/full/obj16/TSequenceDiagram.gif") : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.diagram.ui", (String)"/icons/full/obj16/DDiagram.gif")));
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        List reps = this.parent ? this.representations : RepresentationHelper.getRepresentations((IStructuredSelection)this.getStructuredSelection());
        if (reps.isEmpty()) {
            return;
        }
        OpenRepresentationsRunnable runnable = new OpenRepresentationsRunnable(reps, false);
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progressDialog.run(false, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            LOGGER.debug((Object)new EmbeddedMessage(e.getMessage(), "User Interface"));
        }
        catch (InterruptedException e) {
            LOGGER.debug((Object)new EmbeddedMessage(e.getMessage(), "User Interface"));
        }
        this.parent = false;
    }
}

