/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.ui.tools.api.dialog.RenameDialog;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.sirius.ui.Messages;

public class RenameRepresentationAction
extends BaseSelectionListenerAction {
    public RenameRepresentationAction() {
        super("Rename");
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        IReadOnlySectionHandler handler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
        if (handler != null) {
            for (Object selectedObject : selection) {
                if (selectedObject instanceof DRepresentationDescriptor) {
                    selectedObject = ((DRepresentationDescriptor)selectedObject).getRepresentation();
                }
                if (!(selectedObject instanceof DRepresentation) || !handler.isLockedByOthers((EObject)((DRepresentation)selectedObject))) continue;
                return false;
            }
        }
        return true;
    }

    public void run() {
        List representations = RepresentationHelper.getRepresentations((IStructuredSelection)this.getStructuredSelection());
        for (DRepresentation representation : representations) {
            String newName;
            final String oldName = representation.getName() != null ? representation.getName() : "";
            RenameDialog dialog = new RenameDialog(Display.getDefault().getActiveShell(), oldName){

                public int open() {
                    this.create();
                    return super.open();
                }

                public void create() {
                    super.create();
                    this.setTitle(Messages.RenameRepresentationAction_Title);
                    this.setOldName(oldName);
                    this.getShell().setSize(this.getShell().computeSize(-1, -1));
                }
            };
            if (dialog.open() != 0 || oldName.equals(newName = dialog.getNewName())) continue;
            TransactionHelper.getExecutionManager((EObject)representation).execute((ICommand)new RenameRepresentationCommand(representation, newName));
        }
    }

    private class RenameRepresentationCommand
    extends AbstractReadWriteCommand {
        private String newName;
        private DRepresentation selectedRepresentation;

        public RenameRepresentationCommand(DRepresentation representation, String name) {
            this.newName = name;
            this.selectedRepresentation = representation;
        }

        public void run() {
            this.selectedRepresentation.setName(this.newName);
        }
    }
}

