/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.closeproject;

import java.io.IOException;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.ResourceSaveDiagnose;
import org.eclipse.sirius.common.tools.api.util.ECrossReferenceAdapterWithUnproxyCapability;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class SessionCloseManager {
    private static boolean DEBUG = false;
    private static Map<?, ?> saveOptions;

    public static boolean isSaveable(Session session, Collection<IFile> unsaveableFiles) {
        if (DEBUG) {
            System.out.println("> isSaveable");
            System.out.println("  >> session : " + session);
        }
        boolean result = SessionHelper.areSessionResourcesSaveable(session, unsaveableFiles);
        if (DEBUG) {
            System.out.println("  >< unsaveableFiles : " + unsaveableFiles);
            System.out.println("  << " + result);
        }
        return result;
    }

    private static boolean hasChangesToSave(Resource resource) {
        boolean hasChangesToSave = false;
        ResourceSaveDiagnose diagnose = new ResourceSaveDiagnose(resource);
        try {
            HashMap mergedOptions = new HashMap(SessionCloseManager.getDefaultSaveOptions());
            if (saveOptions != null) {
                mergedOptions.putAll(saveOptions);
            }
            hasChangesToSave = diagnose.isSaveable() && diagnose.hasDifferentSerialization(mergedOptions);
        }
        catch (IOException e) {
            SiriusPlugin.getDefault().error("Error saving resource", (Throwable)e);
        }
        return hasChangesToSave;
    }

    private static Map<?, ?> getDefaultSaveOptions() {
        HashMap<String, Constable> defaultSaveOptions = new HashMap<String, Constable>();
        defaultSaveOptions.put("FLUSH_THRESHOLD", Integer.valueOf(0x1000000));
        defaultSaveOptions.put("USE_FILE_BUFFER", Boolean.TRUE);
        return defaultSaveOptions;
    }

    public static void saveSession(Session session) {
        if (DEBUG) {
            System.out.println("> saveSession");
            System.out.println("  >> session : " + session);
        }
        session.save((IProgressMonitor)new NullProgressMonitor());
        if (DEBUG) {
            System.out.println("  <<");
        }
    }

    public static IEditingSession getUISession(Session session) {
        if (DEBUG) {
            System.out.println("> getUISession");
            System.out.println("  >> session : " + session);
        }
        IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(session);
        if (DEBUG) {
            System.out.println("  << " + editingSession);
        }
        return editingSession;
    }

    public static void closeUISession(IEditingSession uiSession, boolean saveIsNeeded) {
        if (DEBUG) {
            System.out.println("> closeUISession");
            System.out.println("  >> uiSession : " + uiSession);
            System.out.println("  >> saveIsNeeded : " + saveIsNeeded);
        }
        uiSession.close(saveIsNeeded);
        if (DEBUG) {
            System.out.println("  <<");
        }
    }

    public static void removeUiSession(IEditingSession uiSession) {
        if (DEBUG) {
            System.out.println("> removeUiSession");
            System.out.println("  >> uiSession : " + uiSession);
        }
        SessionUIManager.INSTANCE.remove(uiSession);
        if (DEBUG) {
            System.out.println("  <<");
        }
    }

    public static boolean isDirty(Session session) {
        if (DEBUG) {
            System.out.println("> isDirty");
            System.out.println("  >> session : " + session);
        }
        boolean result = SessionStatus.DIRTY.equals((Object)session.getStatus());
        if (DEBUG) {
            System.out.println("  << " + result);
        }
        return result;
    }

    public static void closeSession(Session session) {
        SessionCloseManager.closeSession(session, null);
    }

    public static void closeSession(Session session, IProgressMonitor monitor) {
        if (DEBUG) {
            System.out.println("> closeSession");
            System.out.println("  >> session : " + session);
        }
        session.close(monitor);
        if (DEBUG) {
            System.out.println("  <<");
        }
    }

    public static void cleanSession(Session session) {
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((Session)session);
        if (session instanceof DAnalysisSessionImpl) {
            ECrossReferenceAdapterWithUnproxyCapability cross = ((DAnalysisSessionImpl)session).getSemanticCrossReferencer();
            cross.disableResolveProxy();
        }
        try {
            for (Resource resource : session.getAllSessionResources()) {
                resource.unload();
                editingDomain.getResourceSet().getResources().remove((Object)resource);
            }
            for (Resource resource : session.getSemanticResources()) {
                resource.unload();
                editingDomain.getResourceSet().getResources().remove((Object)resource);
            }
        }
        finally {
            if (session instanceof DAnalysisSessionImpl) {
                ECrossReferenceAdapterWithUnproxyCapability cross = ((DAnalysisSessionImpl)session).getSemanticCrossReferencer();
                cross.enableResolveProxy();
            }
        }
        SessionManager.INSTANCE.remove(session);
    }
}

