/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.egf.genchain.diagram.ui.dialog;

import java.util.List;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.Node;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.NodeContentProvider;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.NodeLabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.egf.genchain.diagram.message.Messages;

public class ReorderDialog
extends TitleAreaDialog {
    private ListViewer viewer;
    private Button upButton;
    private Button downButton;
    private final List<Node> model;

    public ReorderDialog(Shell parentShell, List<Node> model) {
        super(parentShell);
        this.model = model;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite mainArea = (Composite)super.createDialogArea(parent);
        Composite control = new Composite(mainArea, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control.setLayout((Layout)new GridLayout(2, false));
        this.setTitle(Messages.ReorderDialog_title);
        this.setMessage(Messages.ReorderDialog_description);
        this.createViewerControl(control);
        this.createButtonControl(control);
        this.viewer.setInput(this.getModels());
        this.refreshButtons();
        return mainArea;
    }

    private void createViewerControl(Composite control) {
        this.viewer = new ListViewer(control, 2048);
        this.viewer.getList().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new NodeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new NodeContentProvider());
        this.viewer.getList().addSelectionListener((SelectionListener)new MySelectionListener(){

            @Override
            protected void buttonSelected() {
            }
        });
    }

    private void createButtonControl(Composite parent) {
        parent = new Composite(parent, 0);
        GridData gd = new GridData(1040);
        parent.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setFont(parent.getFont());
        parent.setLayout((Layout)layout);
        this.upButton = new Button(parent, 8);
        this.upButton.setToolTipText(org.eclipse.egf.portfolio.genchain.tools.ui.Messages.genchain_wizard_upButton_label);
        this.upButton.setImage(Activator.getDefault().getImage("obj16/upward.gif"));
        this.upButton.addSelectionListener((SelectionListener)new MySelectionListener(){

            @Override
            protected void buttonSelected() {
                IStructuredSelection selection = (IStructuredSelection)ReorderDialog.this.viewer.getSelection();
                if (selection.size() == 1) {
                    Node node = (Node)selection.getFirstElement();
                    int index = ReorderDialog.this.getModels().indexOf(node);
                    if (index > 0) {
                        ReorderDialog.this.getModels().remove(node);
                        ReorderDialog.this.getModels().add(index - 1, node);
                    }
                }
                ReorderDialog.this.viewer.refresh();
            }
        });
        this.downButton = new Button(parent, 8);
        this.downButton.setToolTipText(org.eclipse.egf.portfolio.genchain.tools.ui.Messages.genchain_wizard_downButton_label);
        this.downButton.setImage(Activator.getDefault().getImage("obj16/downward.gif"));
        this.downButton.addSelectionListener((SelectionListener)new MySelectionListener(){

            @Override
            protected void buttonSelected() {
                IStructuredSelection selection = (IStructuredSelection)ReorderDialog.this.viewer.getSelection();
                if (selection.size() == 1) {
                    Node node = (Node)selection.getFirstElement();
                    int index = ReorderDialog.this.getModels().indexOf(node);
                    if (index < ReorderDialog.this.getModels().size() - 1) {
                        ReorderDialog.this.getModels().remove(node);
                        ReorderDialog.this.getModels().add(index + 1, node);
                    }
                }
                ReorderDialog.this.viewer.refresh();
            }
        });
    }

    protected void refreshButtons() {
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            Node node = (Node)selection.getFirstElement();
            int index = this.getModels().indexOf(node);
            this.upButton.setEnabled(index > 0);
            this.downButton.setEnabled(index < this.getModels().size() - 1);
        }
    }

    public List<Node> getModels() {
        return this.model;
    }

    private abstract class MySelectionListener
    implements SelectionListener {
        private MySelectionListener() {
        }

        protected abstract void buttonSelected();

        public void widgetSelected(SelectionEvent e) {
            this.buttonSelected();
            ReorderDialog.this.refreshButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

