/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.ext;

import java.util.Collection;
import org.eclipse.emf.diffmerge.patterns.capella.Messages;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IDeleteOperationProvider;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.ModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.operations.DeleteOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.helpers.HoldingResource;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaDeleteAction;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.platform.sirius.ui.preferences.IDeletePreferences;

public class CapellaDeleteOperationProvider
implements IDeleteOperationProvider {
    public CapellaDeleteOperation getDeleteOperation(Collection<? extends EObject> toDelete_p, boolean skipConfirmation_p, boolean isExpensive_p, Object modelSideContext_p) {
        return new CapellaDeleteOperation(toDelete_p, skipConfirmation_p, isExpensive_p, modelSideContext_p);
    }

    public boolean isInModel(EObject element_p) {
        Resource resource = element_p.eResource();
        return resource != null && !(resource instanceof HoldingResource);
    }

    private static class CapellaDeleteOperation
    extends DeleteOperation {
        private final boolean _skipConfirmation;

        public CapellaDeleteOperation(Collection<? extends EObject> toDelete_p, boolean skipConfirmation_p, boolean isExpensive_p, Object targetContext_p) {
            super(toDelete_p, isExpensive_p, targetContext_p);
            this._skipConfirmation = skipConfirmation_p;
        }

        protected IModelTransformationStatus run() {
            ModelTransformationStatus result;
            Collection toDelete = this.getElementsToDelete();
            ExecutionManager executionManager = TransactionHelper.getExecutionManager((Collection)toDelete);
            if (CapellaDeleteAction.canDelete((Collection)toDelete) && executionManager != null) {
                boolean confirmed = true;
                if (!this._skipConfirmation && IDeletePreferences.INSTANCE.isConfirmationRequired()) {
                    confirmed = CapellaDeleteCommand.confirmDeletion((ExecutionManager)executionManager, (Collection)toDelete);
                }
                if (confirmed) {
                    CapellaDeleteCommand deleteCmd = new CapellaDeleteCommand(executionManager, toDelete, false, false, this.isExpensive());
                    deleteCmd.execute();
                    result = new ModelTransformationStatus(true, false, null, true);
                    for (Object affected : deleteCmd.getAffectedObjects()) {
                        if (!(affected instanceof EObject)) continue;
                        result.getDeletedElements().add((EObject)affected);
                    }
                    result.freeze();
                } else {
                    result = new ModelTransformationStatus(false, false, null);
                    this.abort();
                }
            } else {
                result = new ModelTransformationStatus(false, Messages.CapellaDeleteOperationProvider_DeleteFailed);
            }
            return result;
        }
    }
}

