/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filesystem;

import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSURI;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;

public class CVSFileStore
extends FileStore {
    private final CVSURI uri;
    private IFileInfo info;

    public CVSFileStore(CVSURI uri, IFileInfo info) {
        this.uri = uri;
        this.info = info;
    }

    public boolean canReturnFullTree() {
        return true;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        IFileInfo[] infos = this.childInfos(options, monitor);
        String[] names = new String[infos.length];
        int i = 0;
        while (i < infos.length) {
            names[i] = infos[i].getName();
            ++i;
        }
        return names;
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        if (this.info != null && !this.info.isDirectory()) {
            return new IFileInfo[0];
        }
        ICVSRemoteFolder folder = this.uri.toFolder();
        ICVSResource[] children = folder.fetchChildren(monitor);
        IFileInfo[] childInfos = new IFileInfo[children.length];
        int i = 0;
        while (i < children.length) {
            IFileInfo info;
            ICVSResource child = children[i];
            childInfos[i] = info = this.getFileInfo(child, monitor);
            ++i;
        }
        return childInfos;
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        IFileInfo[] infos = this.childInfos(options, monitor);
        IFileStore[] children = new IFileStore[infos.length];
        int i = 0;
        while (i < infos.length) {
            children[i] = this.getChild(infos[i]);
            ++i;
        }
        return children;
    }

    private IFileStore getChild(IFileInfo info) {
        return new CVSFileStore(this.uri.append(info.getName()), info);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        if (this.isStickyRevision()) {
            ICVSRemoteFile file = this.uri.toFile();
            return this.getFileInfo(file, monitor);
        }
        ICVSRemoteFolder folder = this.uri.getParentFolder();
        if (folder == null) {
            FileInfo info = new FileInfo();
            info.setExists(true);
            info.setName(this.uri.getRepositoryName());
            info.setDirectory(true);
        }
        ICVSResource[] children = folder.fetchChildren(monitor);
        ICVSResource resource = null;
        int i = 0;
        while (i < children.length) {
            ICVSResource child = children[i];
            if (child.getName().equals(this.getName())) {
                resource = child;
                break;
            }
            ++i;
        }
        return this.getFileInfo(resource, monitor);
    }

    private boolean isStickyRevision() {
        String revision = this.uri.getRevision();
        CVSTag tag = this.uri.getTag();
        if (revision == null) {
            return false;
        }
        if (tag == null) {
            return false;
        }
        return revision.equals(tag.getName());
    }

    private IFileInfo getFileInfo(ICVSResource resource, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        if (resource == null) {
            return null;
        }
        FileInfo info = new FileInfo();
        info.setExists(true);
        info.setName(resource.getName());
        if (!resource.isFolder()) {
            RemoteFile remote;
            CachedResourceVariant variant;
            ICVSRemoteFile file = (ICVSRemoteFile)resource;
            if (file instanceof RemoteFile && (variant = (remote = (RemoteFile)file).getCachedHandle()) instanceof ICVSRemoteFile) {
                file = (ICVSRemoteFile)variant;
            }
            ILogEntry entry = file.getLogEntry(monitor);
            info.setLastModified(entry.getDate().getTime());
        } else {
            info.setLastModified(0L);
            info.setDirectory(true);
        }
        return info;
    }

    public IFileStore getChild(String name) {
        if (this.info != null && !this.info.isDirectory()) {
            return null;
        }
        return new CVSFileStore(this.uri.append(name), null);
    }

    public IFileStore getChild(IPath path) {
        return new CVSFileStore(this.uri.append(path), null);
    }

    public String getName() {
        return this.uri.getLastSegment();
    }

    public IFileStore getParent() {
        if (this.uri.isRepositoryRoot()) {
            return null;
        }
        return new CVSFileStore(this.uri.removeLastSegment(), null);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        ICVSRemoteFile file = this.uri.toFile();
        IStorage storage = ((IResourceVariant)file).getStorage(monitor);
        return storage.getContents();
    }

    public URI toURI() {
        return this.uri.toURI();
    }

    public CVSURI getCVSURI() {
        return this.uri;
    }
}

