/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.core.transition.common.exception.TransitionException;
import org.polarsys.capella.core.transition.common.handlers.log.DefaultLogHandler;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.launcher.ActivitiesLauncher;
import org.polarsys.capella.core.transition.common.launcher.ILoopActivityDispatcher;
import org.polarsys.capella.core.transition.common.transposer.ExtendedTransposer;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;

public class TransposerLauncher
extends ActivitiesLauncher {
    private final String PURPOSE = "org.polarsys.capella.core.transition";
    private final String MAPPING = "org.polarsys.capella.core.transition.defaultMapping";
    protected ExtendedTransposer _transposer;
    protected ILoopActivityDispatcher _dispatcher;

    protected ExtendedTransposer getTransposer() {
        return this._transposer;
    }

    protected String getPurpose() {
        return "org.polarsys.capella.core.transition";
    }

    protected String getMapping() {
        return "org.polarsys.capella.core.transition.defaultMapping";
    }

    protected ExtendedTransposer createTransposer(String purpose, String mappingId) {
        return new ExtendedTransposer(purpose, mappingId){

            @Override
            public void initCadence() {
                this.cadenceLauncher = TransposerLauncher.this._cadenceLauncher;
            }
        };
    }

    public ILoopActivityDispatcher createDispatcher() {
        return null;
    }

    public ILoopActivityDispatcher getDispatcher() {
        if (this._dispatcher == null) {
            this._dispatcher = this.createDispatcher();
        }
        return this._dispatcher;
    }

    protected void initializeLogHandler() {
        DefaultLogHandler handler = new DefaultLogHandler(this.getReportComponent());
        handler.init(TransitionContext.EMPTY_CONTEXT);
        LogHelper.setInstance(handler);
    }

    @Override
    protected void dispose() {
        if (this._transposer != null) {
            this._transposer.dispose();
        }
        LogHelper.getInstance().flush();
        LogHelper.dispose();
        super.dispose();
        this._transposer = null;
    }

    public void run(Collection<?> selection1, boolean save, IProgressMonitor monitor) {
        ArrayList selection = new ArrayList();
        selection.addAll(selection1);
        this.launch(selection, this.getPurpose(), this.getMapping(), monitor);
    }

    @Override
    public void launch(Collection<?> selection, String purpose, String mappingId, IProgressMonitor monitor) {
        try {
            try {
                this.initializeLogHandler();
                this._transposer = this.createTransposer(purpose, mappingId);
                this._transposer.getContext().put((Object)"TRANSPOSER_INSTANCE", (Object)this._transposer);
                this._transposer.getContext().put((Object)"TRANSPOSER_SELECTION", selection);
                this._transposer.getContext().put((Object)"TRANSPOSER_PURPOSE", (Object)purpose);
                this._transposer.getContext().put((Object)"COMMAND_NAME", (Object)this.getName());
                this._transposer.getContext().put((Object)"TRANSPOSER_MAPPING", (Object)mappingId);
                this._transposer.getContext().put((Object)"TransposerAnalysisSources", new ArrayList());
                this.initializeParameters();
                this.triggerActivities(selection, this.getWorkflow(), monitor);
            }
            catch (OperationCanceledException e) {
                this.processCancel();
                throw e;
            }
            catch (TransitionException e) {
                LogHelper.getInstance().error(e.getMessage(), Messages.Activity_Transition);
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                LogHelper.getInstance().error(e.getMessage(), Messages.Activity_Transition);
                e.printStackTrace();
                throw new TransitionException(e);
            }
        }
        finally {
            this.dispose();
        }
    }

    protected void initializeParameters() {
        this.addSharedParameter(new GenericParameter("TransposerContext", (Object)this._transposer.getContext(), "Context used during rules execution"));
    }

    public class DispatcherArrayIterator
    implements Iterator<String> {
        private String[] array;
        private int pos = 0;

        public DispatcherArrayIterator(String[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            ILoopActivityDispatcher dispatcher = TransposerLauncher.this.getDispatcher();
            if (this.pos < this.array.length - 1) {
                if (dispatcher.loop(TransposerLauncher.this.getTransposer().getContext(), this.array[this.pos])) {
                    return true;
                }
                return true;
            }
            return this.pos < this.array.length && dispatcher.loop(TransposerLauncher.this.getTransposer().getContext(), this.array[this.pos]);
        }

        @Override
        public String next() throws NoSuchElementException {
            ILoopActivityDispatcher dispatcher = TransposerLauncher.this.getDispatcher();
            if (dispatcher.loop(TransposerLauncher.this.getTransposer().getContext(), this.array[this.pos])) {
                return this.array[this.pos];
            }
            return this.array[this.pos++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

