/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.emf.EClassQuery;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class EObjectQuery {
    protected EObject eObject;
    protected ECrossReferenceAdapter xref;

    public EObjectQuery(EObject eObject) {
        this.eObject = eObject;
    }

    public EObjectQuery(EObject eObject, ECrossReferenceAdapter xref) {
        this.eObject = eObject;
        this.xref = xref;
    }

    public Option<DRepresentation> getRepresentation() {
        EObject current = this.eObject;
        while (current != null) {
            if (current instanceof DRepresentation) {
                return Options.newSome((Object)((DRepresentation)current));
            }
            current = current.eContainer();
        }
        return Options.newNone();
    }

    public EObject getResourceContainer() {
        EObject result = this.eObject;
        if (this.eObject instanceof InternalEObject) {
            result = ((InternalEObject)this.eObject).eDirectResource() != null ? this.eObject : new EObjectQuery(this.eObject.eContainer()).getResourceContainer();
        }
        return result;
    }

    public Option<EObject> getFirstAncestorOfType(EClass klass) {
        EObject current = this.eObject.eContainer();
        while (current != null && !klass.isInstance((Object)current)) {
            current = current.eContainer();
        }
        if (current != null) {
            return Options.newSome((Object)current);
        }
        return Options.newNone();
    }

    public Collection<EObject> getInverseReferences(final String featureName) {
        Preconditions.checkNotNull((Object)featureName);
        return this.getInverseReferences(new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting input) {
                return input != null && input.getEStructuralFeature() != null && featureName.equals(input.getEStructuralFeature().getName());
            }
        });
    }

    public Collection<EObject> getInverseReferences(final EReference ref) {
        Preconditions.checkNotNull((Object)ref);
        return this.getInverseReferences(new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting input) {
                return input != null && ref.equals(input.getEStructuralFeature());
            }
        });
    }

    public Collection<EObject> getInverseReferences(final Set<EReference> refs) {
        Preconditions.checkNotNull(refs);
        return this.getInverseReferences(new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting input) {
                return input != null && refs.contains(input.getEStructuralFeature());
            }
        });
    }

    private Collection<EObject> getInverseReferences(Predicate<EStructuralFeature.Setting> predicate) {
        Session session;
        Preconditions.checkNotNull(predicate);
        if (this.xref == null && (session = this.getSession()) != null) {
            this.xref = session.getSemanticCrossReferencer();
        }
        if (this.xref == null) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        for (EStructuralFeature.Setting setting : Iterables.filter((Iterable)this.xref.getInverseReferences(this.eObject), predicate)) {
            result.add(setting.getEObject());
        }
        return result;
    }

    public Session getSession() {
        Session found = SessionManager.INSTANCE.getSession(this.eObject);
        if (found == null) {
            try {
                Resource res;
                EObject root = EcoreUtil.getRootContainer((EObject)this.eObject);
                Resource resource = res = root != null ? root.eResource() : null;
                if (res != null && new ResourceQuery(res).isRepresentationsResource()) {
                    found = this.getSession(res);
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return found;
    }

    private Session getSession(Resource airdResource) {
        Session found = null;
        Iterator<Session> sessions = SessionManager.INSTANCE.getSessions().iterator();
        while (sessions.hasNext() && found == null) {
            Session sess = sessions.next();
            if (!(sess instanceof DAnalysisSession) || !sess.getAllSessionResources().contains(airdResource)) continue;
            found = sess;
        }
        return found;
    }

    public Collection<URI> getResolvedDependencies() {
        HashSet dependencies = Sets.newHashSet();
        TreeIterator iter = EcoreUtil.getAllProperContents((EObject)this.eObject, (boolean)false);
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof EObject)) continue;
            this.addResolvedDependencies((EObject)obj, dependencies);
        }
        this.addResolvedDependencies(this.eObject, dependencies);
        Resource eObjectResource = this.eObject.eResource();
        if (eObjectResource != null) {
            dependencies.remove(eObjectResource.getURI());
        }
        return dependencies;
    }

    private void addResolvedDependencies(EObject eObj, Collection<URI> dependencies) {
        for (EReference ref : Iterables.filter((Iterable)new EClassQuery(eObj.eClass()).getAllNonContainmentFeatures(), EReference.class)) {
            Object value = eObj.eGet((EStructuralFeature)ref, false);
            if (value instanceof Collection) {
                for (EObject atomicValue : Iterables.filter((Iterable)((Collection)value), EObject.class)) {
                    this.addNonProxyResourceURI(atomicValue, dependencies);
                }
                continue;
            }
            if (!(value instanceof EObject)) continue;
            this.addNonProxyResourceURI((EObject)value, dependencies);
        }
    }

    private void addNonProxyResourceURI(EObject value, Collection<URI> dependencies) {
        Resource valueResource;
        if (value != null && !value.eIsProxy() && (valueResource = value.eResource()) != this.eObject.eResource() && valueResource != null) {
            dependencies.add(valueResource.getURI());
        }
    }

    public Collection<URI> getUnresolvedDependencies() {
        HashSet dependencies = Sets.newHashSet();
        TreeIterator iter = EcoreUtil.getAllProperContents((EObject)this.eObject, (boolean)false);
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof EObject)) continue;
            this.addUnresolvedDependencies((EObject)obj, dependencies);
        }
        this.addUnresolvedDependencies(this.eObject, dependencies);
        return dependencies;
    }

    public List<EObject> getValues(EReference ref) {
        ArrayList result = Collections.emptyList();
        if (ref.isMany()) {
            Object rawValue = this.eObject.eGet((EStructuralFeature)ref);
            if (rawValue != null && !(rawValue instanceof EList)) {
                throw new RuntimeException(MessageFormat.format(Messages.EObjectQuery_valuesErrorMsg, ref.getName(), rawValue.getClass()));
            }
            if (rawValue != null) {
                result = Lists.newArrayList((Iterable)((EList)rawValue));
            }
        } else {
            EObject rawValue = (EObject)this.eObject.eGet((EStructuralFeature)ref);
            if (rawValue != null) {
                result = Collections.singletonList(rawValue);
            }
        }
        return result;
    }

    private void addUnresolvedDependencies(EObject eObj, Collection<URI> dependencies) {
        for (EReference ref : Iterables.filter((Iterable)new EClassQuery(eObj.eClass()).getAllNonContainmentFeatures(), EReference.class)) {
            Object value = eObj.eGet((EStructuralFeature)ref, false);
            if (value instanceof Collection) {
                for (EObject atomicValue : Iterables.filter((Iterable)((Collection)value), EObject.class)) {
                    this.addProxyResourceURI(atomicValue, dependencies);
                }
                continue;
            }
            if (!(value instanceof EObject)) continue;
            this.addProxyResourceURI((EObject)value, dependencies);
        }
    }

    private void addProxyResourceURI(EObject value, Collection<URI> dependencies) {
        if (value != null && value.eIsProxy()) {
            dependencies.add(((InternalEObject)value).eProxyURI().trimFragment());
        }
    }

    public boolean isContainedIn(EObject parentToCheck) {
        EObject current = this.eObject;
        while (current.eContainer() != null) {
            if (current.eContainer().equals(parentToCheck)) {
                return true;
            }
            current = current.eContainer();
        }
        return false;
    }

    public Collection<Viewpoint> getAvailableViewpointsInResourceSet() {
        Resource eResource = this.eObject.eResource();
        if (eResource != null) {
            ResourceSet resourceSet = eResource.getResourceSet();
            HashSet<Viewpoint> viewpoints = new HashSet<Viewpoint>();
            for (Resource resource : resourceSet.getResources()) {
                if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof Group)) continue;
                Group group = (Group)resource.getContents().get(0);
                viewpoints.addAll((Collection<Viewpoint>)group.getOwnedViewpoints());
            }
            return viewpoints;
        }
        return Collections.emptySet();
    }

    public DAnalysis getDAnalysis() {
        DRepresentationDescriptor representationDescriptor;
        EObject rootContainer;
        DAnalysis dAnalysis = null;
        Option<DRepresentation> representation = this.getRepresentation();
        if (representation.some() && (rootContainer = EcoreUtil.getRootContainer((EObject)(representationDescriptor = new DRepresentationQuery((DRepresentation)representation.get()).getRepresentationDescriptor()), (boolean)false)) instanceof DAnalysis) {
            dAnalysis = (DAnalysis)rootContainer;
        }
        return dAnalysis;
    }
}

