/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.resource.DraggedObjectTester;
import org.eclipse.sirius.business.internal.session.SessionTransientAttachment;
import org.eclipse.sirius.viewpoint.DFile;
import org.eclipse.sirius.viewpoint.DFolder;
import org.eclipse.sirius.viewpoint.DModel;
import org.eclipse.sirius.viewpoint.DProject;
import org.eclipse.sirius.viewpoint.DResource;
import org.eclipse.sirius.viewpoint.DResourceContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointFactory;

public class WorkspaceDragAndDropSupport {
    public EObject convert(Object draggedElement, Session session) {
        EObject eObject = null;
        DraggedObjectTester tester = new DraggedObjectTester(draggedElement);
        if (tester.isEObject()) {
            if (tester.isInSession(session)) {
                eObject = tester.getEObject();
            } else if (tester.isDSemanticDecoratorAndTargetIsInSession(session)) {
                eObject = ((DSemanticDecorator)draggedElement).getTarget();
            }
        } else if (tester.isWorkspaceResource()) {
            eObject = tester.isWorkspaceFile() && tester.isLoadableModel() ? this.convertModel((IFile)draggedElement, session) : this.convertResource((IResource)draggedElement, session);
        }
        return eObject;
    }

    private DResource convertResource(IResource resource, Session session) {
        DResource dResource = null;
        if (resource instanceof IContainer) {
            dResource = this.convertContainer((IContainer)resource, session);
        } else if (resource instanceof IFile) {
            dResource = this.convertFile((IFile)resource, session);
        }
        return dResource;
    }

    private DResourceContainer convertContainer(IContainer container, Session session) {
        DResourceContainer dContainer = null;
        if (container instanceof IProject) {
            dContainer = this.createDProject((IProject)container);
        } else if (container instanceof IFolder) {
            dContainer = this.createDFolder((IFolder)container);
        }
        if (dContainer != null) {
            this.attachSession(dContainer, session);
            if (container.isAccessible()) {
                try {
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        DResource dResource = this.convertResource(resource, session);
                        if (dResource != null) {
                            dContainer.getMembers().add((Object)dResource);
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return dContainer;
    }

    private DModel convertModel(IFile file, Session session) {
        DModel model = this.createDModel(file);
        this.attachSession(model, session);
        return model;
    }

    private DModel createDModel(IFile file) {
        DModel model = ViewpointFactory.eINSTANCE.createDModel();
        model.setName(file.getName());
        model.setPath(this.convertPathToString((IResource)file));
        return model;
    }

    private DFile convertFile(IFile file, Session session) {
        DFile dFile = this.createDFile(file);
        this.attachSession(dFile, session);
        return dFile;
    }

    private void attachSession(EObject eObject, Session session) {
        eObject.eAdapters().add((Object)new SessionTransientAttachment(session));
    }

    private DFile createDFile(IFile file) {
        DFile dFile = ViewpointFactory.eINSTANCE.createDFile();
        dFile.setName(file.getName());
        dFile.setPath(this.convertPathToString((IResource)file));
        return dFile;
    }

    private DFolder createDFolder(IFolder folder) {
        DFolder dFolder = ViewpointFactory.eINSTANCE.createDFolder();
        dFolder.setName(folder.getName());
        dFolder.setPath(this.convertPathToString((IResource)folder));
        return dFolder;
    }

    private DProject createDProject(IProject project) {
        DProject dProject = ViewpointFactory.eINSTANCE.createDProject();
        dProject.setName(project.getName());
        dProject.setPath(this.convertPathToString((IResource)project));
        return dProject;
    }

    public void addSemanticResourceToSession(Resource resource, Session session) {
        if (!this.hasURIInSemanticResources(session.getSemanticResources(), resource.getURI()) && session != null) {
            session.addSemanticResource(resource.getURI(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private boolean hasURIInSemanticResources(Iterable<Resource> resources, URI uri) {
        boolean found = false;
        if (uri != null) {
            for (Resource resource : resources) {
                if (!resource.getURI().equals(uri)) continue;
                found = true;
            }
        }
        return found;
    }

    private String convertPathToString(IResource resource) {
        return resource.getLocation().toString();
    }

    public IFile getWorkspaceFile(DFile file) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getPath()));
    }
}

