/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource.strategy;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.internal.resource.strategy.DefaultOptimizedResourceStrategyImpl;
import org.eclipse.sirius.business.internal.resource.strategy.ResourceStrategy;

public final class ResourceStrategyRegistry {
    private static final ResourceStrategyRegistry INSTANCE = new ResourceStrategyRegistry();
    private ResourceStrategy defaultResourceStrategy = new DefaultOptimizedResourceStrategyImpl();
    private Set<ResourceStrategy> providedResourceStrategies = new LinkedHashSet<ResourceStrategy>();

    private ResourceStrategyRegistry() {
    }

    public static ResourceStrategyRegistry getInstance() {
        return INSTANCE;
    }

    public void addResourceStrategy(ResourceStrategy resourceStrategy) {
        this.providedResourceStrategies.add(resourceStrategy);
    }

    public void removeResourceStrategy(ResourceStrategy resourceStrategy) {
        this.providedResourceStrategies.remove(resourceStrategy);
    }

    public Collection<ResourceStrategy> getProvidedResourceStrategies() {
        return this.providedResourceStrategies;
    }

    public void dispose() {
        this.providedResourceStrategies.clear();
    }

    private ResourceStrategy getResourceStrategy(ResourceStrategy.ResourceStrategyType resStrategyType, Resource resource) {
        for (ResourceStrategy iResourceStrategy : this.providedResourceStrategies) {
            if (!iResourceStrategy.canHandle(resource, resStrategyType)) continue;
            return iResourceStrategy;
        }
        return this.defaultResourceStrategy;
    }

    private ResourceStrategy getResourceStrategy(ResourceStrategy.ResourceStrategyType resStrategyType, URI resourceURI) {
        for (ResourceStrategy iResourceStrategy : this.providedResourceStrategies) {
            if (!iResourceStrategy.canHandle(resourceURI, resStrategyType)) continue;
            return iResourceStrategy;
        }
        return this.defaultResourceStrategy;
    }

    public IStatus unloadAtResourceSetDispose(Resource resource, IProgressMonitor monitor) {
        ResourceStrategy resourceStrategy = this.getResourceStrategy(ResourceStrategy.ResourceStrategyType.RELEASE_RESOURCE_AT_RESOURCESET_DISPOSE, resource);
        return resourceStrategy.releaseResourceAtResourceSetDispose(resource, monitor);
    }
}

