/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource.strategy;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.business.internal.resource.strategy.ResourceStrategy;
import org.eclipse.sirius.business.internal.resource.strategy.ResourceStrategyRegistry;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class ResourceStrategyRegistryListener
implements IRegistryEventListener {
    public static final String RESOURCE_STRATEGY_EXTENSION_POINT = "org.eclipse.sirius.resourceStrategy";
    private static final String RESOURCE_STRATEGY_TAG_EXTENSION = "resourceStrategy";
    private static final String RESOURCE_STRATEGY_CLASS_ATTRIBUTE = "class";

    public void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this, RESOURCE_STRATEGY_EXTENSION_POINT);
        this.parseInitialContributions();
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                if (RESOURCE_STRATEGY_TAG_EXTENSION.equals(elem.getName())) {
                    String extensionClassName = elem.getAttribute(RESOURCE_STRATEGY_CLASS_ATTRIBUTE);
                    Collection<ResourceStrategy> resourceStrategies = ResourceStrategyRegistry.getInstance().getProvidedResourceStrategies();
                    for (ResourceStrategy resourceStrategy : resourceStrategies) {
                        if (!extensionClassName.equals(resourceStrategy.getClass())) continue;
                        ResourceStrategyRegistry.getInstance().removeResourceStrategy(resourceStrategy);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(RESOURCE_STRATEGY_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            try {
                Object contribution = elem.createExecutableExtension(RESOURCE_STRATEGY_CLASS_ATTRIBUTE);
                if (contribution instanceof ResourceStrategy) {
                    ResourceStrategyRegistry.getInstance().addResourceStrategy((ResourceStrategy)contribution);
                }
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", Messages.AbstractSiriusMigrationService_contributionInstantiationErrorMsg, (Throwable)e));
            }
            ++n2;
        }
    }

    public void dispose() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener((IRegistryEventListener)this);
        ResourceStrategyRegistry.getInstance().dispose();
    }
}

