/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.internal.session.danalysis.AnalysisResourceReloadedCommand;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.tools.api.command.semantic.RemoveSemanticResourceCommand;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.SyncStatus;

public class SessionResourcesSynchronizer
implements ResourceSyncClient {
    private final DAnalysisSessionImpl session;

    public SessionResourcesSynchronizer(DAnalysisSessionImpl session) {
        this.session = (DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session);
    }

    public void statusChanged(Resource resource, ResourceSetSync.ResourceStatus oldStatus, ResourceSetSync.ResourceStatus newStatus) {
    }

    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (this.session.isOpen()) {
            Multimap<ResourceSetSync.ResourceStatus, Resource> newStatuses = this.getImpactingNewStatuses(changes);
            boolean allResourcesSync = this.allResourcesAreInSync();
            for (ResourceSetSync.ResourceStatus newStatus : newStatuses.keySet()) {
                switch (newStatus) {
                    case SYNC: {
                        if (!allResourcesSync) break;
                        this.session.notifyListeners(3);
                        break;
                    }
                    case CHANGED: {
                        this.session.notifyListeners(2);
                        break;
                    }
                    case EXTERNAL_CHANGED: 
                    case CONFLICTING_CHANGED: 
                    case CONFLICTING_DELETED: 
                    case DELETED: 
                    case CHANGES_CANCELED: {
                        NullProgressMonitor pm = new NullProgressMonitor();
                        for (Resource resource : newStatuses.get((Object)newStatus)) {
                            try {
                                if (this.isInProjectDeletedRenamedOrClosed(resource)) {
                                    this.processAction(ReloadingPolicy.Action.CLOSE_SESSION, resource, (IProgressMonitor)pm);
                                    return;
                                }
                                this.processActions(this.session.getReloadingPolicy().getActions(this.session, resource, newStatus), resource, (IProgressMonitor)pm);
                            }
                            catch (Exception e) {
                                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.SessionResourcesSynchronizer_cantHandleResourceChangeMsg, resource.getURI()), e);
                            }
                        }
                        allResourcesSync = this.allResourcesAreInSync();
                        if (allResourcesSync) {
                            this.session.notifyListeners(3);
                            break;
                        }
                        this.session.notifyListeners(2);
                        break;
                    }
                }
            }
            if (allResourcesSync) {
                this.session.setSynchronizationStatus(SyncStatus.SYNC);
            } else {
                this.session.setSynchronizationStatus(SyncStatus.DIRTY);
            }
        }
    }

    private boolean isInProjectDeletedRenamedOrClosed(Resource resource) {
        IProject project;
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null && (project = file.getProject()) != null) {
            return !project.exists() || !project.isOpen();
        }
        return false;
    }

    private void processActions(List<ReloadingPolicy.Action> actions, Resource resource, IProgressMonitor pm) throws Exception {
        for (ReloadingPolicy.Action action : actions) {
            this.processAction(action, resource, pm);
        }
    }

    private void processAction(ReloadingPolicy.Action action, Resource resource, IProgressMonitor pm) throws Exception {
        switch (action) {
            case CLOSE_SESSION: {
                this.session.close(pm);
                break;
            }
            case RELOAD: {
                if (!this.session.isOpen()) break;
                this.reloadResource(resource);
                break;
            }
            case REMOVE: {
                this.removeResourceFromSession(resource, pm);
                break;
            }
        }
    }

    private void reloadResource(final Resource resource) throws IOException {
        this.session.notifyListeners(4);
        TransactionalEditingDomain ted = this.session.getTransactionalEditingDomain();
        AnalysisResourceReloadedCommand reloadingAnalysisCmd = null;
        ResourceQuery resourceQuery = new ResourceQuery(resource);
        boolean representationsResource = resourceQuery.isRepresentationsResource();
        if (representationsResource) {
            reloadingAnalysisCmd = new AnalysisResourceReloadedCommand(this.session, ted, resource);
        }
        ArrayList resourcesBeforeReload = Lists.newArrayList((Iterable)ted.getResourceSet().getResources());
        RunnableWithResult.Impl<Object> reload = new RunnableWithResult.Impl<Object>(){

            public void run() {
                SessionResourcesSynchronizer.this.session.disableCrossReferencerResolve(resource);
                resource.unload();
                SessionResourcesSynchronizer.this.session.enableCrossReferencerResolve(resource);
                try {
                    resource.load(Collections.EMPTY_MAP);
                    EcoreUtil.resolveAll((Resource)resource);
                    SessionResourcesSynchronizer.this.session.getSemanticCrossReferencer().resolveProxyCrossReferences(resource);
                }
                catch (IOException e) {
                    this.setResult(e);
                }
            }
        };
        try {
            ted.runExclusive((Runnable)reload);
            if (reload.getResult() != null) {
                throw (IOException)reload.getResult();
            }
            if (!reload.getStatus().isOK()) {
                SiriusPlugin.getDefault().error(Messages.SessionResourcesSynchronizer_reloadOperationFailErrorMsg, null);
            } else {
                if (representationsResource) {
                    ted.getCommandStack().execute((Command)reloadingAnalysisCmd);
                    if (resource.getURI().equals(this.session.getSessionResource().getURI())) {
                        this.session.sessionResourceReloaded(resource);
                    }
                }
                this.session.discoverAutomaticallyLoadedResources(resourcesBeforeReload);
                this.session.notifyListeners(5);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void removeResourceFromSession(Resource resource, IProgressMonitor pm) {
        if (this.session.getAllSemanticResources().contains(resource)) {
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RemoveSemanticResourceCommand(this.session, resource, (IProgressMonitor)new NullProgressMonitor(), false));
        } else if (this.session.getAllSessionResources().contains(resource)) {
            this.session.removeAnalysis(resource);
        }
        if (this.session.getResources().contains((Object)resource)) {
            for (EObject root : Lists.newArrayList((Iterable)resource.getContents())) {
                EcoreUtil.remove((EObject)root);
            }
            this.session.getResources().remove((Object)resource);
        }
        if (this.session.getAllSessionResources().isEmpty()) {
            this.session.close(pm);
        }
    }

    protected boolean allResourcesAreInSync() {
        return this.checkResourcesAreInSync(this.getAllSessionResources());
    }

    protected boolean checkResourcesAreInSync(Iterable<? extends Resource> resourcesToConsider) {
        boolean allResourceAreInSync = true;
        for (Resource resource : resourcesToConsider) {
            ResourceSetSync.ResourceStatus status = ResourceSetSync.getStatus((Resource)resource);
            boolean bl = allResourceAreInSync = status == ResourceSetSync.ResourceStatus.SYNC || !resource.isModified();
            if (!allResourceAreInSync) break;
        }
        return allResourceAreInSync;
    }

    private Multimap<ResourceSetSync.ResourceStatus, Resource> getImpactingNewStatuses(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        LinkedHashMultimap impactingNewStatuses = LinkedHashMultimap.create();
        LinkedHashMultimap representationResourcesNewStatuses = LinkedHashMultimap.create();
        Iterable<Resource> semanticOrControlledresources = this.getAllSemanticResources();
        Set<Resource> representationResources = this.session.getAllSessionResources();
        for (ResourceSyncClient.ResourceStatusChange change : changes) {
            if (this.session.isResourceOfSession(change.getResource(), semanticOrControlledresources)) {
                impactingNewStatuses.put((Object)change.getNewStatus(), (Object)change.getResource());
                continue;
            }
            if (!this.session.isResourceOfSession(change.getResource(), representationResources)) continue;
            representationResourcesNewStatuses.put((Object)change.getNewStatus(), (Object)change.getResource());
        }
        impactingNewStatuses.putAll((Multimap)representationResourcesNewStatuses);
        return impactingNewStatuses;
    }

    private Iterable<Resource> getAllSessionResources() {
        return Iterables.concat(this.session.getSemanticResources(), this.session.getAllSessionResources(), this.session.getControlledResources());
    }

    private Iterable<Resource> getAllSemanticResources() {
        return Iterables.concat(this.session.getSemanticResources(), this.session.getControlledResources());
    }
}

