/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transfo.operationalcapability.rules.tomission;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.model.helpers.SystemAnalysisExt;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.log.LogHelper;
import org.polarsys.capella.core.projection.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.projection.common.rules.fa.Rule_FunctionPkg;

public class Rule_OperationalActivityPkg
extends Rule_FunctionPkg {
    public Rule_OperationalActivityPkg() {
        super(OaPackage.Literals.OPERATIONAL_ACTIVITY_PKG, CtxPackage.Literals.MISSION_PKG);
    }

    protected EObject transformDirectElement(EObject element_p, IContext context_p) {
        MissionPkg result;
        SystemAnalysis architecture;
        if (element_p.eContainer() instanceof BlockArchitecture && (architecture = (SystemAnalysis)context_p.get("transfoTargetContainer")) != null && (result = SystemAnalysisExt.getMissionPkg((SystemAnalysis)architecture)) != null) {
            LogHelper.getInstance().info(NLS.bind((String)ProjectionMessages.ElementTransitionedToExistingElement, (Object)EObjectLabelProviderHelper.getText((EObject)element_p), (Object)EObjectLabelProviderHelper.getText((EObject)result)), (Object)new Object[]{element_p, result}, ProjectionMessages.Activity_Transformation);
            return result;
        }
        return super.transformDirectElement(element_p, context_p);
    }

    protected void retrieveContainer(EObject element_p, List<EObject> result_p, IContext context_p) {
        result_p.add(this.getSourceContainer(element_p, null, context_p));
    }

    protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject bestContainer = null;
        EObject container = this.getSourceContainer(element_p, result_p, context_p);
        if (container != null) {
            bestContainer = TransformationHandlerHelper.getInstance((IContext)context_p).getBestTracedElement(container, context_p, TransformationHandlerHelper.getInstance((IContext)context_p).getTargetType(container, context_p));
        }
        return bestContainer;
    }

    protected EObject getSourceContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject parent = element_p.eContainer();
        while (parent != null) {
            if (parent instanceof FunctionPkg) {
                return parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    protected EObject getDefaultContainer(EObject element_p, EObject result_p, IContext context_p) {
        SystemAnalysis architecture = (SystemAnalysis)context_p.get("transfoTargetContainer");
        if (architecture != null) {
            return SystemAnalysisExt.getMissionPkg((SystemAnalysis)architecture);
        }
        return null;
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element_p, EObject result_p, EObject container_p, IContext context_p) {
        if (container_p instanceof BlockArchitecture) {
            return CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_MISSION_PKG;
        }
        return CtxPackage.Literals.MISSION_PKG__OWNED_MISSION_PKGS;
    }
}

