/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement;

import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.Messages;
import org.polarsys.capella.core.refinement.merge.processor.ScenarioMergeProcessor;
import org.polarsys.capella.core.refinement.scenarios.core.ScenarioRefinement;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;

public class RefinementMerge
extends ScenarioRefinement {
    Scenario _scenario;
    private IProcessor _merge = null;
    private Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");

    public RefinementMerge(Scenario srcDiagram, ComponentArchitecture arch) {
        super(srcDiagram, (NamedElement)arch);
        this._scenario = srcDiagram;
        this._merge = new ScenarioMergeProcessor();
        this._merge.setContext((ModelElement)this._scenario);
        this._merge.setTarget((NamedElement)((AbstractCapability)this._scenario.eContainer()));
    }

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        if (this._merge != null) {
            try {
                this._merge.execute(progressMonitor);
            }
            catch (ProcessorException exception) {
                this._logger.error((Object)new EmbeddedMessage(Messages.refinementAbortedDueToMergeFailure, "Refinement", (Object)this._scenario));
                throw exception;
            }
            Scenario mergeResult = (Scenario)this._merge.getResult();
            this.setContext((ModelElement)mergeResult);
            super.execute(progressMonitor);
            String scName = mergeResult.getName();
            scName = String.valueOf(scName) + " [merged]";
            mergeResult.setName(scName);
            NamedElement elt = (NamedElement)this.getResult();
            scName = elt.getName();
            String string = scName.replace(MessageFormat.format(ScenarioRefinement.REFINED_SCENARIO_PREFIX, 0), "");
        }
    }
}

