/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.explorer.activity.ui.viewer;

import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.BasicSessionActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SelectionHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers.DiagramViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.core.explorer.activity.ui.pages.AbstractCapellaPage;
import org.polarsys.capella.core.explorer.activity.ui.viewer.CapellaArchitectureContentProvider;
import org.polarsys.capella.core.explorer.activity.ui.viewer.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.CloneAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.representation.MoveRepresentationAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaNavigatorLabelProvider;
import org.polarsys.capella.core.sirius.ui.actions.DeleteRepresentationAction;
import org.polarsys.capella.core.sirius.ui.actions.OpenRepresentationsAction;
import org.polarsys.capella.core.sirius.ui.actions.RenameRepresentationAction;

public class CapellaDiagramViewer
extends DiagramViewer {
    private static final String GROUP_MOVE = "Move";
    private MoveRepresentationAction _moveDiagramAction;
    private OpenRepresentationsAction _openRepresentation;
    private RenameRepresentationAction _renameRepresentationAction;
    private BaseSelectionListenerAction _showInCapellaExplorerAction;
    private CloneAction _cloneAction;
    private DeleteRepresentationAction _deleteRepresentationAction;

    public CapellaDiagramViewer(BasicSessionActivityExplorerPage page) {
        super(page);
    }

    protected void addListenersOnViewer(TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                OpenRepresentationsAction action = new OpenRepresentationsAction();
                action.selectionChanged(selection);
                action.run();
            }
        });
    }

    protected MenuManager initMenuToViewer(final TreeViewer treeViewer) {
        MenuManager contextMenuManager = new MenuManager("viewerPopup");
        Control control = treeViewer.getControl();
        this.declareViewerActions(contextMenuManager, treeViewer);
        Menu contextMenu = contextMenuManager.createContextMenu(control);
        control.setMenu(contextMenu);
        contextMenuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToHide(IMenuManager manager) {
                manager.remove("MoveDiagrams.Menu.ID");
                CapellaDiagramViewer.this._moveDiagramAction.dispose();
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.appendToGroup(CapellaDiagramViewer.GROUP_MOVE, (IContributionItem)CapellaDiagramViewer.this._moveDiagramAction.fillContextMenu((IStructuredSelection)treeViewer.getSelection()));
            }
        });
        return contextMenuManager;
    }

    protected void declareViewerActions(MenuManager contextMenuManager, TreeViewer treeViewer) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ISelectionProvider selectionProvider = this.page.getEditorSite().getSelectionProvider();
        this._showInCapellaExplorerAction = new BaseSelectionListenerAction(Messages.AbstractCapellaArchitectureActivityExplorerPage_ShowInCapellaExplorerAction_Title){

            public void run() {
                LocateInCapellaExplorerAction callback = new LocateInCapellaExplorerAction();
                callback.setSite((IWorkbenchPartSite)CapellaDiagramViewer.this.page.getEditorSite());
                callback.run((IAction)CapellaDiagramViewer.this._showInCapellaExplorerAction);
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                return CapellaDiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        this._showInCapellaExplorerAction.setActionDefinitionId("org.polarsys.capella.core.platform.sirius.ui.navigator.locateInCapellaExplorerCommand");
        this._showInCapellaExplorerAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._showInCapellaExplorerAction, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this._showInCapellaExplorerAction);
        contextMenuManager.add((IContributionItem)new Separator());
        this._openRepresentation = new OpenRepresentationsAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return CapellaDiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._openRepresentation, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this._openRepresentation);
        contextMenuManager.add((IContributionItem)new Separator());
        this._cloneAction = new CloneAction(treeViewer);
        this._cloneAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._cloneAction, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this._cloneAction);
        this._deleteRepresentationAction = new DeleteRepresentationAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return CapellaDiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        this._deleteRepresentationAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this._deleteRepresentationAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._deleteRepresentationAction, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this._deleteRepresentationAction);
        contextMenuManager.add((IContributionItem)new Separator(GROUP_MOVE));
        this._moveDiagramAction = new MoveRepresentationAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._moveDiagramAction, (ISelectionProvider)selectionProvider);
        this._renameRepresentationAction = new RenameRepresentationAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return CapellaDiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._renameRepresentationAction, (ISelectionProvider)selectionProvider);
        contextMenuManager.add((IAction)this._renameRepresentationAction);
        this.updateActionBars();
    }

    protected ILabelProvider getLabelProvider() {
        return new CapellaNavigatorLabelProvider();
    }

    protected IContentProvider getContentProvider() {
        return new CapellaArchitectureContentProvider(((AbstractCapellaPage)this.page).getHandledViewpoint(), ((AbstractCapellaPage)this.page).getFilteringMetaClassForCommonViewpoint());
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.page.getEditorSite().getSelectionProvider();
        if (this._renameRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._renameRepresentationAction);
            this._renameRepresentationAction = null;
        }
        if (this._deleteRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._deleteRepresentationAction);
            this._deleteRepresentationAction = null;
        }
        if (this._openRepresentation != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._openRepresentation);
            this._openRepresentation = null;
        }
        if (this._moveDiagramAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._moveDiagramAction);
            this._moveDiagramAction.dispose();
            this._moveDiagramAction = null;
        }
        if (this._cloneAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._cloneAction);
            this._cloneAction = null;
        }
        if (this._showInCapellaExplorerAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._showInCapellaExplorerAction);
            this._showInCapellaExplorerAction = null;
        }
    }

    private void updateActionBars() {
        IActionBars editorActionBars = this.page.getEditorSite().getActionBars();
        editorActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this._deleteRepresentationAction);
        editorActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this._renameRepresentationAction);
        editorActionBars.updateActionBars();
    }

    protected class DelegatedViewerFilter
    extends ViewerFilter {
        private ViewerFilter _delegatedFilter;

        protected DelegatedViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean selected = true;
            if (this._delegatedFilter != null) {
                selected = this._delegatedFilter.select(viewer, parentElement, element);
            }
            return selected;
        }

        public void setDelegatedFilter(ViewerFilter delegatedFilter) {
            this._delegatedFilter = delegatedFilter;
        }
    }
}

