/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;

public abstract class AbstractViewerDialog
extends TitleAreaDialog {
    private String _dialogTitle;
    private String _shellTitle;
    private String _dialogMessage;

    public AbstractViewerDialog(Shell parentShell, String title, String message, String shellTitle) {
        super(parentShell);
        this._dialogTitle = title == null ? "" : title;
        this._dialogMessage = message == null ? "" : message;
        this._shellTitle = shellTitle == null ? "" : shellTitle;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this._shellTitle);
    }

    protected void constrainViewer(TreeViewer viewer, int heightHint) {
        Control tree = viewer.getControl();
        Point computeSize = tree.computeSize(-1, heightHint);
        this.constrainViewer(viewer, heightHint, computeSize.x);
    }

    protected void constrainViewer(TreeViewer viewer, int heightHint, int widthHint) {
        GridData gridData = (GridData)viewer.getControl().getLayoutData();
        gridData.heightHint = this.convertHeightInCharsToPixels(heightHint);
        gridData.widthHint = widthHint;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.AbstractViewerDialog_OK_Title, false);
        this.createButton(parent, 1, Messages.AbstractViewerDialog_CANCEL_Title, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        ScrolledComposite scrolled = new ScrolledComposite(dialogAreaComposite, 2832);
        scrolled.setBackground(Display.getCurrent().getSystemColor(9));
        Composite composite = new Composite((Composite)scrolled, 16);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(dialogAreaComposite.getFont());
        this.doCreateDialogArea(composite);
        this.customizeDialogAppearance();
        scrolled.setContent((Control)composite);
        scrolled.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolled.setLayout((Layout)new GridLayout());
        scrolled.setExpandVertical(true);
        scrolled.setExpandHorizontal(true);
        scrolled.setMinSize(composite.computeSize(-1, -1));
        scrolled.setVisible(true);
        return parent;
    }

    protected Label createLabel(Composite parent, String title) {
        Label label = new Label(parent, 0);
        label.setText(title);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        return label;
    }

    protected Text createText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(4, 1, true, false));
        return text;
    }

    protected void customizeDialogAppearance() {
        this.setTitle(this._dialogTitle);
        this.setMessage(this._dialogMessage);
    }

    protected abstract void doCreateDialogArea(Composite var1);

    protected abstract Object getResult();

    protected int getViewerHeighthint() {
        return 20;
    }
}

