/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.fields;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.common.ui.toolkit.fields.IMdeFieldEditor;
import org.polarsys.capella.common.ui.toolkit.services.behaviors.IInputBehavior;
import org.polarsys.capella.common.ui.toolkit.services.validators.IValidator;

public abstract class MdeFieldEditor
extends FieldEditor
implements IMdeFieldEditor {
    protected int _labelStyle = 16384;
    protected int _valueStyle = 0;
    private IInputBehavior _inputBehavior = null;
    private IValidator _validator = null;
    private String _errorMessage = null;

    protected MdeFieldEditor() {
    }

    protected MdeFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 16384, 0);
    }

    protected MdeFieldEditor(String name, String labelText, Composite parent, int labelStyle, int valueStyle) {
        this.init(name, labelText, labelStyle, valueStyle);
        this.createControl(parent);
    }

    protected void init(String name, String text, int labelStyle, int valueStyle) {
        if (name == null) {
            throw new NullPointerException("The property name should not be null value.");
        }
        if (text == null) {
            throw new NullPointerException("The label text should not be null value.");
        }
        this._labelStyle = this.checkLabelStyle(labelStyle);
        this._valueStyle = this.checkValueStyle(valueStyle);
        this.setLabelText(text);
        this.setPreferenceName(name);
    }

    private int checkLabelStyle(int labelStyle) {
        int newStyle = labelStyle;
        if ((2 & newStyle) != 0) {
            newStyle -= 2;
        }
        if ((0x40 & newStyle) != 0) {
            newStyle -= 64;
        }
        if (newStyle == 0) {
            newStyle = 16384;
        }
        return newStyle;
    }

    protected int checkValueStyle(int valueStyle) {
        return valueStyle;
    }

    protected void createControl(Composite parent) {
        Layout layout = parent.getLayout();
        if (!(layout instanceof GridLayout)) {
            GridLayout gdLayout = new GridLayout();
            gdLayout.numColumns = this.getNumberOfControls();
            gdLayout.horizontalSpacing = 8;
            parent.setLayout((Layout)gdLayout);
            this.doFillIntoGrid(parent, gdLayout.numColumns);
        } else {
            GridLayout gdLayout = (GridLayout)layout;
            this.doFillIntoGrid(parent, gdLayout.numColumns);
        }
    }

    public Label getLabelControl(Composite parent) {
        Label label = super.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        label.setLayoutData((Object)gd);
        int alignement = 0x20000 & this._labelStyle;
        if (alignement == 0) {
            alignement = 0x1000000 & this._labelStyle;
        }
        if (alignement == 0) {
            alignement = 16384;
        }
        label.setAlignment(alignement);
        return label;
    }

    public void setErrorMessage(String message) {
        this._errorMessage = message;
    }

    protected abstract void doFillIntoGrid(Composite var1, int var2);

    protected abstract Object getValue(Control var1);

    @Override
    public Label getLabel() {
        return this.getLabelControl();
    }

    @Override
    public abstract Control getValueControl();

    @Override
    public abstract Control getHelperControl();

    @Override
    public IInputBehavior getInputBehavior() {
        return this._inputBehavior;
    }

    @Override
    public void setInputBehavior(IInputBehavior behavior) {
        this._inputBehavior = behavior;
    }

    @Override
    public String getErrorMessage() {
        return this._errorMessage;
    }

    @Override
    public IValidator getValidator() {
        return this._validator;
    }

    @Override
    public void setValidator(IValidator validator) {
        this._validator = validator;
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 0;
    }

    @Override
    public boolean isValid() {
        boolean isValid = true;
        if (this._validator != null) {
            Control control = this.getValueControl();
            Object value = this.getValue(control);
            this._errorMessage = this._validator.isValid(value);
            boolean bl = isValid = this._errorMessage == null;
            if (this.getPage() != null) {
                this.showErrorMessage(this._errorMessage);
            }
        }
        return isValid;
    }

    protected boolean doCheckState() {
        return this.isValid();
    }

    @Override
    public String getFieldName() {
        return this.getPreferenceName();
    }

    @Override
    public DialogPage getFieldPage() {
        return this.getPage();
    }

    @Override
    public void setFieldPage(DialogPage page) {
        this.setPage(page);
    }

    @Override
    public boolean isHelperEnabled() {
        boolean enabled = false;
        Control helperControl = this.getHelperControl();
        if (helperControl != null) {
            enabled = helperControl.isEnabled();
        }
        return enabled;
    }

    @Override
    public void setHelperEnabled(boolean enabled) {
        Control helperControl = this.getHelperControl();
        if (helperControl != null) {
            helperControl.setEnabled(enabled);
        }
    }

    @Override
    public boolean isValueEnabled() {
        boolean enabled = false;
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            enabled = valueControl.isEnabled();
        }
        return enabled;
    }

    @Override
    public void setValueEnabled(boolean enabled) {
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            valueControl.setEnabled(enabled);
        }
    }

    @Override
    public void setFocus() {
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            valueControl.setFocus();
        }
    }

    @Override
    public boolean isFocused() {
        Control valueControl = this.getValueControl();
        Control helperControl = this.getHelperControl();
        boolean focused = false;
        if (valueControl != null) {
            focused = valueControl.isFocusControl();
        }
        if (helperControl != null) {
            focused |= helperControl.isFocusControl();
        }
        return focused;
    }

    @Override
    public void defaultLayout() {
        Composite parent = this.getLabelControl().getParent();
        GridLayout layout = (GridLayout)parent.getLayout();
        this.fillIntoGrid(parent, layout.numColumns);
    }

    @Override
    public void layout(int numColumns) {
        this.adjustForNumColumns(numColumns);
    }

    public void setEnabled(boolean enabled) {
        Label control = this.getLabelControl();
        if (control != null) {
            control.setEnabled(enabled);
        }
        if ((control = this.getValueControl()) != null) {
            control.setEnabled(enabled);
        }
        if ((control = this.getHelperControl()) != null) {
            control.setEnabled(enabled);
        }
    }
}

