/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.ctx.validation.actor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.OperationalActorRealization;
import org.polarsys.capella.core.data.ctx.OperationalEntityRealization;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class SystemActorRealizationConsistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Actor) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            Actor actor = (Actor)eObj;
            EList traces = actor.getOutgoingTraces();
            if (traces.size() < 1) {
                return ctx.createSuccessStatus();
            }
            for (AbstractTrace next : traces) {
                TraceableElement sourceElement;
                if (!(next instanceof OperationalActorRealization) && !(next instanceof OperationalEntityRealization)) continue;
                TraceableElement targetElement = next.getTargetElement();
                if (targetElement == null || !(targetElement instanceof Entity)) {
                    statuses.add(ctx.createFailureStatus(new Object[]{String.valueOf(actor.getName()) + " (" + actor.eClass().getName() + ") contain realization with inconsistent Target (it should be an Entity or Operational Actor)"}));
                }
                if ((sourceElement = next.getSourceElement()) != null && sourceElement instanceof Actor) continue;
                statuses.add(ctx.createFailureStatus(new Object[]{String.valueOf(actor.getName()) + " (" + actor.eClass().getName() + ") contain realization with inconsistent Source (it should be System Actor)"}));
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

