/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.activator.SolFaCommonActivator;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.model.handler.command.ICapellaResourceHelper;

public class CapellaResourceHelper {
    public static final String CAPELLA_MODEL_FILE_EXTENSION = "melodymodeller";
    public static final String CAPELLA_FRAGMENT_FILE_EXTENSION = "melodyfragment";
    public static final String AIRD_FRAGMENT_FILE_EXTENSION = "airdfragment";
    public static final String AIRD_FILE_EXTENSION = "aird";
    public static final String AFM_FILE_EXTENSION = "afm";
    public static final String FRAGMENTS_DEFAULT_FOLDER = "fragments";
    private static boolean __delegatedCapellaResourceHelperLoaded = false;
    private static ICapellaResourceHelper __delegatedCapellaResourceHelper;
    public static final String CAPELLA_PROJECT_NATURE = "org.polarsys.capella.project.nature";
    public static final String CAPELLA_LIBRARY_PROJECT_NATURE = "org.polarsys.capella.library.nature";
    public static final String CAPELLA_CONFIGURATION_PROJECT_NATURE = "org.polarsys.capella.core.preferences.project.nature.configNature";

    public static boolean ensureResourceIsWritable(Resource resource) {
        boolean result = false;
        if (resource == null) {
            return result;
        }
        IFile file = EcoreUtil2.getFile((Resource)resource);
        result = file != null && file.isReadOnly() ? SolFaCommonActivator.getDefault().getUserEnforcedHelper().makeFileWritable(file).isOK() : true;
        return result;
    }

    private static boolean hasFileExtension(IResource resource, boolean ignoreFragment, String fragmentFileExtension, String modelFileExtension) {
        boolean result = false;
        if (resource == null || 1 != resource.getType()) {
            return result;
        }
        String fileExtension = resource.getFileExtension();
        result = modelFileExtension.equals(fileExtension);
        if (!result && !ignoreFragment) {
            result = fragmentFileExtension.equals(fileExtension);
        }
        return result;
    }

    public static boolean isAirdResource(IResource resource, boolean ignoreAirdFragment) {
        return CapellaResourceHelper.hasFileExtension(resource, ignoreAirdFragment, AIRD_FRAGMENT_FILE_EXTENSION, AIRD_FILE_EXTENSION);
    }

    public static boolean isAirdResource(URI uri) {
        return uri != null && (AIRD_FILE_EXTENSION.equals(uri.fileExtension()) || AIRD_FRAGMENT_FILE_EXTENSION.equals(uri.fileExtension()));
    }

    public static boolean isCapellaFragment(URI uri) {
        return uri != null ? CAPELLA_FRAGMENT_FILE_EXTENSION.equals(uri.fileExtension()) : false;
    }

    public static boolean isCapellaResource(IResource resource) {
        return CapellaResourceHelper.isCapellaResource(resource, false);
    }

    public static boolean isCapellaResource(IResource resource, boolean ignoreCapellaFragment) {
        return CapellaResourceHelper.hasFileExtension(resource, ignoreCapellaFragment, CAPELLA_FRAGMENT_FILE_EXTENSION, CAPELLA_MODEL_FILE_EXTENSION);
    }

    public static boolean isCapellaResource(Object object) {
        return object instanceof Resource && CapellaResourceHelper.isCapellaResource((Resource)object);
    }

    public static boolean isCapellaResource(Resource resource) {
        return resource != null ? CapellaResourceHelper.isCapellaResource(resource.getURI()) : false;
    }

    public static boolean isCapellaResource(URI uri) {
        boolean isCapellaResource;
        if (uri == null) {
            return false;
        }
        if (!__delegatedCapellaResourceHelperLoaded) {
            __delegatedCapellaResourceHelper = CapellaResourceHelper.loadDelegatedCapellaResourceHelper();
        }
        boolean bl = isCapellaResource = __delegatedCapellaResourceHelper != null ? __delegatedCapellaResourceHelper.isCapellaResource(uri) : false;
        return isCapellaResource || CAPELLA_MODEL_FILE_EXTENSION.equals(uri.fileExtension()) || CapellaResourceHelper.isCapellaFragment(uri);
    }

    public static boolean isSemanticElement(Object object) {
        return object instanceof EObject && !CapellaResourceHelper.isSiriusElement(object);
    }

    private static boolean isSiriusElement(Object object) {
        return object instanceof DRefreshable || object instanceof DRepresentationDescriptor;
    }

    public static boolean isSemanticElements(Collection<?> objects) {
        for (Object o : objects) {
            if (CapellaResourceHelper.isSemanticElement(o)) continue;
            return false;
        }
        return true;
    }

    public static Resource createCapellaResource(IProject project, String filename, TransactionalEditingDomain domain) {
        String fullPath = String.valueOf(project.getFullPath().toString()) + '/' + filename + '.' + CAPELLA_MODEL_FILE_EXTENSION;
        URI capellaModelURI = URI.createPlatformResourceURI((String)fullPath, (boolean)true);
        ResourceSet set = domain.getResourceSet();
        Resource xmiResource = set.createResource(capellaModelURI);
        return xmiResource;
    }

    private static ICapellaResourceHelper loadDelegatedCapellaResourceHelper() {
        ICapellaResourceHelper delegatedHelper = null;
        IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.core.model.handler", (String)"delegatedCapellaResourceHelper");
        if (configurationElements.length > 0) {
            delegatedHelper = (ICapellaResourceHelper)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElements[0], (String)"class");
        }
        __delegatedCapellaResourceHelperLoaded = true;
        return delegatedHelper;
    }

    public static EAttribute getEditableAttribute(EObject selectedElement) {
        EAttribute attribute = null;
        if (selectedElement != null) {
            EStructuralFeature feature;
            if (selectedElement instanceof AbstractNamedElement) {
                attribute = ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME;
            } else if (selectedElement.eClass() != null && (feature = selectedElement.eClass().getEStructuralFeature("name")) != null && feature instanceof EAttribute) {
                attribute = (EAttribute)feature;
            }
        }
        return attribute;
    }

    public static boolean isCapellaProject(IProject targetProject) {
        try {
            return targetProject.hasNature(CAPELLA_PROJECT_NATURE) || targetProject.hasNature(CAPELLA_LIBRARY_PROJECT_NATURE);
        }
        catch (CoreException exception) {
            return false;
        }
    }

    public static boolean isCapellaProject(Resource resource) {
        IProject project;
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null && (project = file.getProject()) != null) {
            return CapellaResourceHelper.isCapellaProject(project);
        }
        return false;
    }

    public static Resource getMainModelResource(EObject eObject) {
        Resource objRes = eObject.eResource();
        if (objRes != null) {
            if (CapellaResourceHelper.isCapellaFragment(objRes.getURI())) {
                Resource mainModelResource = EcoreUtil.getRootContainer((EObject)eObject, (boolean)true).eResource();
                if (mainModelResource != null) {
                    return mainModelResource;
                }
            } else {
                return objRes;
            }
        }
        return null;
    }
}

