/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;

public class CapellaAdapterHelper {
    public static EObject resolveSemanticObject(Object object) {
        return CapellaAdapterHelper.resolveSemanticObject(object, false);
    }

    public static EObject resolveSemanticObject(Object object, boolean onlySemantic) {
        Object adapter;
        if (object instanceof EObject) {
            return CapellaAdapterHelper.resolveEObject((EObject)object, onlySemantic);
        }
        if (object instanceof IAdaptable && (adapter = ((IAdaptable)object).getAdapter(EObject.class)) instanceof EObject) {
            return CapellaAdapterHelper.resolveEObject((EObject)adapter, onlySemantic);
        }
        return null;
    }

    private static EObject resolveEObject(EObject object, boolean onlySemantic) {
        if (!onlySemantic && (object instanceof DRepresentationDescriptor || object instanceof DRepresentation)) {
            return object instanceof DRepresentationDescriptor ? ((DRepresentationDescriptor)object).getRepresentation() : object;
        }
        return CapellaAdapterHelper.getBusinessObject(object);
    }

    private static EObject getBusinessObject(EObject object) {
        if (object != null) {
            if (CapellaResourceHelper.isSemanticElement(object)) {
                return CapellaAdapterHelper.getRelatedSemanticObject(object);
            }
            EObject obj = (EObject)Platform.getAdapterManager().getAdapter((Object)object, ModelElement.class);
            if (obj == null) {
                obj = (EObject)Platform.getAdapterManager().loadAdapter((Object)object, ModelElement.class.getName());
            }
            if (obj == null) {
                return null;
            }
            if (obj.eContainer() == null || obj.eResource() == null) {
                return null;
            }
            return CapellaAdapterHelper.getRelatedSemanticObject(obj);
        }
        return null;
    }

    private static EObject getRelatedSemanticObject(EObject object) {
        AbstractType type;
        boolean allowMultiplePart;
        if (object.eClass().equals(CsPackage.eINSTANCE.getPart()) && !(allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven(object))) && (type = ((Part)object).getAbstractType()) != null && !(type instanceof ConfigurationItem)) {
            return type;
        }
        return object;
    }
}

