/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.model.handler.helpers.HoldingResource;

public class HoldingResourceHelper {
    protected static URI uri = URI.createURI((String)"capella://capella/holdingResource.melodymodeller");

    public static Resource getHoldingResource(TransactionalEditingDomain domain) {
        return HoldingResourceHelper.getHoldingResource(domain, true);
    }

    protected static Resource getHoldingResource(final TransactionalEditingDomain domain, boolean create) {
        Resource hresource = domain.getResourceSet().getResource(uri, false);
        if (hresource == null && create) {
            ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)domain).execute((ICommand)new AbstractNonDirtyingCommand(){

                public void run() {
                    HoldingResource resource = new HoldingResource(uri);
                    domain.getResourceSet().getResources().add((Object)resource);
                }
            });
        }
        hresource = domain.getResourceSet().getResource(uri, false);
        return hresource;
    }

    public static boolean isHoldByHoldingResource(EObject object) {
        return object.eResource() instanceof HoldingResource;
    }

    public static void flushHoldingResource(TransactionalEditingDomain domain) {
        Resource resource = HoldingResourceHelper.getHoldingResource(domain, false);
        if (resource != null) {
            HashSet<EObject> all = new HashSet<EObject>();
            TreeIterator child = resource.getAllContents();
            while (child.hasNext()) {
                all.add((EObject)child.next());
            }
            for (EObject obj : all) {
                EcoreUtil.remove((EObject)obj);
            }
            resource.getContents().clear();
            resource.unload();
            domain.getResourceSet().getResources().remove((Object)resource);
        }
    }

    public static void attachToHoldingResource(EObject element, Resource resource) {
        if (resource != null) {
            resource.getContents().add((Object)element);
        }
    }

    public static void ensureMoveElement(EObject element, EObject newContainer) {
        Resource elementResource;
        Resource newContainerResource;
        if (newContainer != null && (newContainerResource = newContainer.eResource()) != null && element != null && (elementResource = element.eResource()) != null && HoldingResourceHelper.isHoldByHoldingResource(element) && !HoldingResourceHelper.isHoldByHoldingResource(newContainer)) {
            ((Resource.Internal)elementResource).getContents().remove((Object)element);
            ((Resource.Internal)newContainerResource).attached(element);
            for (EObject o : element.eContents()) {
                HoldingResourceHelper.ensureMoveElement(o, newContainer);
            }
        }
    }
}

