/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

public class PackageRegistryIndex {
    private static final String SEPARATOR = ".";
    private final EPackage.Registry runtimeTypeRegistry;
    private final Predicate<EPackage> packageFilter;
    private final Multimap<String, EClass> index = HashMultimap.create();
    private boolean initializedDescriptors;

    public PackageRegistryIndex(EPackage.Registry registry, Predicate<EPackage> packageFilter) {
        this.runtimeTypeRegistry = registry;
        this.packageFilter = packageFilter;
        this.indexTypesFromRegistry(false);
        if (!Boolean.valueOf(System.getProperty("org.eclipse.sirius.enableUnsafeOptimisations", "false")).booleanValue()) {
            this.indexTypesFromRegistry(true);
        }
    }

    private void indexTypesFromRegistry(boolean descriptors) {
        if (descriptors) {
            this.index.clear();
        }
        for (Object value : new ArrayList(this.runtimeTypeRegistry.values())) {
            if (!descriptors && value instanceof EPackage) {
                this.indexTypesFrom((EPackage)value);
                continue;
            }
            if (!descriptors) continue;
            if (value instanceof EPackage) {
                this.indexTypesFrom((EPackage)value);
                continue;
            }
            if (!(value instanceof EPackage.Descriptor)) continue;
            try {
                this.indexTypesFrom(((EPackage.Descriptor)value).getEPackage());
            }
            catch (Throwable throwable) {}
        }
    }

    public Collection<EClass> getEClassesFromName(String name) {
        Collection result = this.index.get((Object)name);
        if (Boolean.valueOf(System.getProperty("org.eclipse.sirius.enableUnsafeOptimisations", "false")).booleanValue() && result.isEmpty() && !this.initializedDescriptors) {
            this.indexTypesFromRegistry(true);
            this.initializedDescriptors = true;
            result = this.index.get((Object)name);
        }
        return result;
    }

    private void indexTypesFrom(EPackage value) {
        if (this.packageFilter.apply((Object)value)) {
            for (EClass cur : Iterables.filter((Iterable)value.getEClassifiers(), EClass.class)) {
                this.index.put((Object)cur.getName(), (Object)cur);
                this.index.put((Object)(String.valueOf(value.getName()) + SEPARATOR + cur.getName()), (Object)cur);
            }
        }
    }
}

