/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.extension.points.ParameterizedComposerElement;
import org.polarsys.kitalpha.composer.ui.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComposerWidget {
    protected Label description;

    public abstract void createContents(Composite var1);

    public abstract void initialize();

    public abstract void updateSelection(IConfigurationElement var1);

    public abstract Viewer getViewer();

    protected Label getDescription() {
        return this.description;
    }

    protected void setDescription(String str_p) {
        if (str_p != null) {
            this.description.setText(str_p);
            this.description.update();
        }
    }

    protected final Collection<Parameter> safeGetParameters(IConfigurationElement element) {
        if (element != null) {
            try {
                ParameterizedComposerElement parameterizedComposerElement = (ParameterizedComposerElement)element.createExecutableExtension("Class");
                Map params = parameterizedComposerElement.getParameters();
                if (params != null) {
                    for (Map.Entry entry : params.entrySet()) {
                        ((Parameter)entry.getValue()).setName((String)entry.getKey());
                    }
                    return params.values();
                }
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        return Collections.emptySet();
    }

    protected static class ComposerElementListener
    implements ISelectionChangedListener {
        private AbstractComposerWidget widget;

        public ComposerElementListener(AbstractComposerWidget widget) {
            this.widget = widget;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object object;
            ISelection newSelection = this.widget.getViewer().getSelection();
            if (newSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)newSelection).getFirstElement()) instanceof IConfigurationElement) {
                IConfigurationElement configElement = (IConfigurationElement)object;
                this.widget.updateSelection(configElement);
                this.widget.setDescription(configElement.getAttribute("Description"));
            }
        }

        public void specific() {
        }
    }
}

