/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.polarsys.kitalpha.cadence.ui.api.dialog.IParameterManager;
import org.polarsys.kitalpha.cadence.ui.api.dialog.ParametersDialog;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.extension.points.IGenerator;
import org.polarsys.kitalpha.composer.extension.points.ParameterizedComposerElement;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.ComposerHelper;
import org.polarsys.kitalpha.composer.ui.launch.tabs.ComposerTab;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.AtomicWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer.AbstractComposerWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.parameters.ParameterManager;
import org.polarsys.kitalpha.composer.ui.providers.ColumnParametersLabelProvider;
import org.polarsys.kitalpha.composer.ui.providers.ColumnValuesLabelProvider;
import org.polarsys.kitalpha.composer.ui.providers.ITableEditingListener;
import org.polarsys.kitalpha.composer.ui.providers.TableContentProvider;
import org.polarsys.kitalpha.composer.ui.providers.TableEditingSupport;

public class GeneratorWidget
extends AbstractComposerWidget {
    private ComposerTab tab;
    private AtomicWidget cw;
    private IConfigurationElement selectedGeneratorElement = null;
    private Collection<Parameter> parameters;
    private ParametersDialog dialog;
    private Viewer viewer;
    private Button edit;
    private Text text;
    private Button wkp_b;
    private Button fs_b;

    public GeneratorWidget(ComposerTab tab_p) {
        this.tab = tab_p;
    }

    public void createContents(Composite parent) {
        this.createWidget(parent, "Generator", "Select the generator", true);
        this.createGenerationPathWidget(parent, "Generation path");
        this.attachListeners();
        this.initialize();
    }

    public void initialize() {
        IConfigurationElement[] generators = CodeManagerExtensions.getAllGeneratorExtensions();
        this.viewer.setInput((Object)generators);
    }

    public void updateSelection(IConfigurationElement selectedElement) {
        if (this.selectedGeneratorElement != selectedElement) {
            this.selectedGeneratorElement = selectedElement;
            if (this.selectedGeneratorElement != null) {
                this.parameters = this.safeGetParameters(this.selectedGeneratorElement);
            }
            this.tab.updateLaunchConfigurationDialog();
        }
    }

    public Viewer createWidget(Composite parent_p, String name_p, String comboxText_p, boolean button) {
        Group group = new Group(parent_p, 0);
        group.setText(name_p);
        group.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        this.cw = new AtomicWidget((Composite)group);
        this.viewer = this.cw.createComboViewer(true);
        if (!button) {
            this.cw.createEmptyLabel(false);
        } else {
            this.edit = this.cw.createButton((Composite)group, "Edit Details...", "configure the parameters");
            GridData gd_button = new GridData();
            gd_button.horizontalAlignment = 131072;
            this.edit.setLayoutData((Object)gd_button);
        }
        this.description = this.cw.createEmptyLabel(true, 64);
        return this.viewer;
    }

    public void createGenerationPathWidget(Composite parent_p, String name_p) {
        Group group = new Group(parent_p, 0);
        group.setText(name_p);
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        AtomicWidget cw = new AtomicWidget((Composite)group);
        this.text = cw.createText((Composite)group);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.text.setLayoutData((Object)gd);
        this.wkp_b = cw.createButton((Composite)group, "Browse workspace...", null);
        this.fs_b = cw.createButton((Composite)group, "Browse file system...", null);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        Label label = cw.createLabel("Help with path variables");
        label.setLayoutData((Object)gd);
        this.createHelpControl((Composite)group);
        this.attachBrowseWorkspaceListener(this.wkp_b, this.text);
        this.attachBrowseFileSystem(this.fs_b, this.text);
        this.attachModifyListener(this.text);
    }

    private void attachListeners() {
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new AbstractComposerWidget.ComposerElementListener(this));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITableEditingListener listener = new ITableEditingListener(){

                    public void parameterValueChanged() {
                        GeneratorWidget.this.tab.update();
                    }
                };
                GeneratorWidget.this.dialog = new ParametersDialog(GeneratorWidget.this.tab.getShell(), (IStructuredContentProvider)new TableContentProvider(), (ColumnLabelProvider)new ColumnParametersLabelProvider(), (ColumnLabelProvider)new ColumnValuesLabelProvider(), (IParameterManager)new ParameterManager());
                GeneratorWidget.this.dialog.create();
                TableEditingSupport edit = new TableEditingSupport((ColumnViewer)GeneratorWidget.this.dialog.getViewer(), listener);
                GeneratorWidget.this.dialog.setEditingSupport((EditingSupport)edit);
                if (GeneratorWidget.this.parameters != null) {
                    GeneratorWidget.this.dialog.setContainer((Object)GeneratorWidget.this.selectedGeneratorElement);
                    GeneratorWidget.this.dialog.setInput((Object)GeneratorWidget.this.parameters);
                }
                GeneratorWidget.this.dialog.open();
            }
        });
    }

    private void attachModifyListener(Text text_p) {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratorWidget.this.tab.update();
            }
        });
    }

    private void attachBrowseWorkspaceListener(Button button_p, final Text text_p) {
        button_p.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorWidget.this.handleBrowseWorkspace(text_p);
                GeneratorWidget.this.tab.updateLaunchConfigurationDialog();
            }
        });
    }

    private void attachBrowseFileSystem(Button button_p, final Text text_p) {
        button_p.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorWidget.this.handleBrowseFileSystem(text_p);
                GeneratorWidget.this.tab.updateLaunchConfigurationDialog();
            }
        });
    }

    private void handleBrowseWorkspace(Text text_p) {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.tab.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            text_p.setText(((Path)result[0]).toString());
        }
    }

    private void handleBrowseFileSystem(Text text_p) {
        DirectoryDialog dialog = new DirectoryDialog(this.tab.getShell());
        String absolutePath = dialog.open();
        if (absolutePath != null) {
            text_p.setText(absolutePath);
        }
    }

    public void setNsUri(String nsUri_p) {
        this.cw.setNsUri(nsUri_p);
    }

    public final Viewer getViewer() {
        return this.viewer;
    }

    public final Button getEdit() {
        return this.edit;
    }

    public final Text getText() {
        return this.text;
    }

    public final Button getWkp_b() {
        return this.wkp_b;
    }

    public final Button getFs_b() {
        return this.fs_b;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.selectedGeneratorElement != null && this.tab.isDirty()) {
            configuration.setAttribute("generator_parameters", ComposerHelper.getMapFromTable(this.parameters));
            configuration.setAttribute("generator_name", this.selectedGeneratorElement.getAttribute("Name"));
            configuration.setAttribute("generator_id", this.selectedGeneratorElement.getAttribute("Id"));
            configuration.setAttribute("generation_folder", this.text.getText());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            IGenerator generator;
            Map<String, Parameter> parametersMap;
            String generatorId = configuration.getAttribute("generator_id", "");
            if (generatorId != null && generatorId.length() > 0) {
                this.selectedGeneratorElement = CodeManagerExtensions.getGeneratorConfigElementFromId((String)generatorId);
            }
            this.cw.setNsUri(configuration.getAttribute("allocation_uri", ""));
            int index = this.cw.initializeComboViewer(configuration.getAttribute("generator_name", ""));
            Map map = configuration.getAttribute("generator_parameters", new HashMap());
            if (this.selectedGeneratorElement != null && (parametersMap = ComposerHelper.buildMapFromString(map, (ParameterizedComposerElement)(generator = (IGenerator)this.selectedGeneratorElement.createExecutableExtension("Class")))) != null) {
                this.parameters = parametersMap.values();
            }
            this.text.setText(configuration.getAttribute("generation_folder", ""));
            this.cw.intializeDescription(this.description, index);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    protected Control createHelpControl(Composite parent) {
        Image helpImage = JFaceResources.getImage((String)"dialog_help_image");
        return this.createHelpImageButton(parent, helpImage);
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorWidget.this.helpPressed();
            }
        });
        return toolBar;
    }

    private void helpPressed() {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp("org.polarsys.kitalpha.composer.ui.help.run_configuration_path_variables");
    }
}

