/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.kitalpha.cadence.ui.api.dialog.IParameterManager;
import org.polarsys.kitalpha.cadence.ui.api.dialog.ParametersDialog;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.extension.points.ParameterizedComposerElement;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.ComposerHelper;
import org.polarsys.kitalpha.composer.ui.launch.tabs.ComposerTab;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.AtomicWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer.AbstractComposerWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.parameters.ParameterManager;
import org.polarsys.kitalpha.composer.ui.providers.ColumnParametersLabelProvider;
import org.polarsys.kitalpha.composer.ui.providers.ColumnValuesLabelProvider;
import org.polarsys.kitalpha.composer.ui.providers.ITableEditingListener;
import org.polarsys.kitalpha.composer.ui.providers.TableContentProvider;
import org.polarsys.kitalpha.composer.ui.providers.TableEditingSupport;

public class StrategyWidget
extends AbstractComposerWidget {
    private Viewer viewer;
    private Button edit;
    private final ComposerTab tab;
    private AtomicWidget cw;
    private IConfigurationElement selectedStrategyElement = null;
    private Collection<Parameter> parameters;
    private ParametersDialog dialog;

    public StrategyWidget(ComposerTab tab_p) {
        this.tab = tab_p;
    }

    public void createContents(Composite parent) {
        this.createWidget(parent, "Strategy", "Select the strategy", true);
        this.attachListeners();
        this.initialize();
    }

    public void initialize() {
        IConfigurationElement[] strategyType = CodeManagerExtensions.getAllStrategiesExtensions();
        this.viewer.setInput((Object)strategyType);
    }

    public void updateSelection(IConfigurationElement selectedElement) {
        if (this.selectedStrategyElement != selectedElement) {
            this.selectedStrategyElement = selectedElement;
            this.parameters = this.safeGetParameters(selectedElement);
            this.tab.updateLaunchConfigurationDialog();
        }
    }

    protected void setDescription(String str_p) {
        super.setDescription(str_p);
        this.tab.updateLaunchConfigurationDialog();
    }

    public Viewer createWidget(Composite parent_p, String name_p, String comboxText_p, boolean button) {
        Group group = new Group(parent_p, 0);
        group.setText(name_p);
        group.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        this.cw = new AtomicWidget((Composite)group);
        this.viewer = this.cw.createComboViewer(true);
        if (!button) {
            this.cw.createEmptyLabel(false);
        } else {
            this.edit = this.cw.createButton((Composite)group, "Edit Details...", "configure the parameters");
            GridData gd_button = new GridData();
            gd_button.horizontalAlignment = 131072;
            this.edit.setLayoutData((Object)gd_button);
        }
        this.description = this.cw.createEmptyLabel(true, 64);
        return this.viewer;
    }

    private void attachListeners() {
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new AbstractComposerWidget.ComposerElementListener(this));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITableEditingListener listener = new ITableEditingListener(){

                    public void parameterValueChanged() {
                        StrategyWidget.this.tab.update();
                    }
                };
                StrategyWidget.this.dialog = new ParametersDialog(StrategyWidget.this.tab.getShell(), (IStructuredContentProvider)new TableContentProvider(), (ColumnLabelProvider)new ColumnParametersLabelProvider(), (ColumnLabelProvider)new ColumnValuesLabelProvider(), (IParameterManager)new ParameterManager());
                StrategyWidget.this.dialog.create();
                TableEditingSupport edit = new TableEditingSupport((ColumnViewer)StrategyWidget.this.dialog.getViewer(), listener);
                StrategyWidget.this.dialog.setEditingSupport((EditingSupport)edit);
                if (StrategyWidget.this.parameters != null) {
                    StrategyWidget.this.dialog.setContainer((Object)StrategyWidget.this.selectedStrategyElement);
                    StrategyWidget.this.dialog.setInput((Object)StrategyWidget.this.parameters);
                }
                StrategyWidget.this.dialog.open();
            }
        });
    }

    public final Viewer getViewer() {
        return this.viewer;
    }

    public void setNsUri(String nsUri_p) {
        this.cw.setNsUri(nsUri_p);
    }

    public final Button getEdit() {
        return this.edit;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.selectedStrategyElement != null && this.tab.isDirty()) {
            configuration.setAttribute("strategie_parameters", ComposerHelper.getMapFromTable(this.parameters));
            configuration.setAttribute("strategie_name", this.selectedStrategyElement.getAttribute("Name"));
            configuration.setAttribute("strategie_id", this.selectedStrategyElement.getAttribute("Id"));
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            ParameterizedComposerElement strategy;
            Map<String, Parameter> parametersMap;
            String strategyId = configuration.getAttribute("strategie_id", "");
            if (strategyId != null && strategyId.length() > 0) {
                this.selectedStrategyElement = CodeManagerExtensions.getStrategyConfigElementFromId((String)strategyId);
            }
            this.cw.setNsUri(configuration.getAttribute("allocation_uri", ""));
            int index = this.cw.initializeComboViewer(configuration.getAttribute("strategie_name", ""));
            Map map = configuration.getAttribute("strategie_parameters", new HashMap());
            if (this.selectedStrategyElement != null && (parametersMap = ComposerHelper.buildMapFromString(map, strategy = (ParameterizedComposerElement)this.selectedStrategyElement.createExecutableExtension("Class"))) != null) {
                this.parameters = parametersMap.values();
            }
            this.cw.intializeDescription(this.description, index);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }
}

