/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.composer.api.library.LibraryReuseHelper;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.LibraryTab;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.AtomicWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.library.ConflictValidator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.library.providers.LibraryContentProvider;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.library.providers.LibraryItem;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.library.providers.LibraryValidityColumnLabelProvider;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryWidget {
    private Viewer viewer;
    private Text validation;
    private LibraryTab tab;
    AtomicWidget cw;
    private Text descriptionArea;
    private List<LibraryItem> checkedList;

    public LibraryWidget(LibraryTab tab_p) {
        this.tab = tab_p;
    }

    public void createContents(Composite parent) {
        this.createWidget(parent, "Select the wanted libraries");
        this.attachListeners();
        this.initialize();
    }

    private void attachListeners() {
        ((CheckboxTableViewer)this.viewer).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LibraryItem r = (LibraryItem)event.getElement();
                if (event.getChecked()) {
                    ConflictValidator.getInstance().isConflict(LibraryWidget.this.getCheckList(), r);
                    LibraryWidget.this.getCheckList().add(r);
                } else {
                    r.clearErrorsMsg();
                    LibraryWidget.this.getCheckList().remove(r);
                    ConflictValidator.getInstance().isConflictReverse(r, LibraryWidget.this.getCheckList());
                }
                if (LibraryWidget.this.updateMessages() == "OK") {
                    LibraryWidget.this.tab.update();
                } else {
                    LibraryWidget.this.tab.noUpdate();
                }
                LibraryWidget.this.viewer.refresh();
            }
        });
    }

    private String updateMessages() {
        String msg = "";
        this.validation.setText(msg);
        LibraryItem[] libraryItemArray = (LibraryItem[])this.viewer.getInput();
        int n = libraryItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryItem i = libraryItemArray[n2];
            for (String s : i.getErrorsMsg()) {
                msg = String.valueOf(msg) + s + "\n";
            }
            ++n2;
        }
        msg = msg == "" ? "OK" : msg;
        this.validation.setText(msg);
        return msg;
    }

    public void initialize() {
        this.checkedList = new ArrayList<LibraryItem>();
        Resource[] res = LibraryReuseHelper.INSTANCE.getLibraries();
        LibraryItem[] items = new LibraryItem[res.length];
        int i = 0;
        while (i < res.length) {
            items[i] = new LibraryItem(res[i], true);
            ++i;
        }
        this.viewer.setInput((Object)items);
    }

    public Viewer createWidget(Composite parent_p, String name_p) {
        Group groupL = new Group(parent_p, 0);
        groupL.setText(name_p);
        groupL.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupL.setLayoutData((Object)gd);
        this.viewer = this.createTable((Composite)groupL);
        this.validation = ConflictValidator.getInstance().getWidget(parent_p);
        return this.viewer;
    }

    private Viewer createTable(Composite container) {
        GridData gd = new GridData(1808);
        gd.heightHint = 80;
        CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2086);
        Table table = tableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        tableViewer.setContentProvider((IContentProvider)new LibraryContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new LibraryValidityColumnLabelProvider());
        tableViewer.setUseHashlookup(true);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = LibraryWidget.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    Object o = ((IStructuredSelection)selection).getFirstElement();
                    LibraryItem item = (LibraryItem)o;
                    Resource res = item.getItem();
                    String string = res.getDescription() == null ? "Library " + res.getName() : res.getDescription();
                    LibraryWidget.this.descriptionArea.setText(string);
                }
            }
        });
        Group internalGroup = new Group(container, 0);
        internalGroup.setText("Selected library");
        internalGroup.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        internalGroup.setLayoutData((Object)gd);
        Label label = new Label((Composite)internalGroup, 0);
        label.setText("Description");
        this.descriptionArea = new Text((Composite)internalGroup, 2634);
        this.descriptionArea.setEditable(false);
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 50;
        this.descriptionArea.setLayoutData((Object)gd);
        return tableViewer;
    }

    public final Viewer getViewer() {
        return this.viewer;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        List<String> selected = this.convertCheckedListToString();
        if (selected != null) {
            configuration.setAttribute("libraries_list", selected);
        }
    }

    private List<String> convertCheckedListToString() {
        ArrayList<String> selected = new ArrayList<String>();
        List<Resource> l = this.getModelResourceList(this.getCheckList());
        for (Resource r : l) {
            selected.add(r.getId());
        }
        return selected;
    }

    private List<Resource> getModelResourceList(List<LibraryItem> list_p) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (LibraryItem i : list_p) {
            result.add(i.getItem());
        }
        return result;
    }

    private List<Resource> getResourceList(List<String> list_p) {
        return LibraryReuseHelper.INSTANCE.getResourcesFromIds(list_p);
    }

    private void setCheckList(List<LibraryItem> resources) {
        this.checkedList = resources;
    }

    private List<LibraryItem> getCheckList() {
        return this.checkedList;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            List values = configuration.getAttribute("libraries_list", new ArrayList());
            if (values != null) {
                List<Resource> resources = this.getResourceList(values);
                this.setCheckList(this.getLibraryItemFromResource(resources));
                this.updateCheckList();
            }
            this.descriptionArea.setText("");
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    private List<LibraryItem> getLibraryItemFromResource(List<Resource> resources) {
        LibraryItem[] items;
        ArrayList<LibraryItem> list = new ArrayList<LibraryItem>();
        LibraryItem[] libraryItemArray = items = (LibraryItem[])this.viewer.getInput();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryItem i = libraryItemArray[n2];
            Resource r = i.getItem();
            for (Resource res : resources) {
                if (!r.getId().equals(res.getId())) continue;
                list.add(i);
            }
            ++n2;
        }
        return list;
    }

    private void updateCheckList() {
        Table table = (Table)this.viewer.getControl();
        List<LibraryItem> list = this.getCheckList();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LibraryItem libItem = (LibraryItem)item.getData();
            if (list.contains(libItem)) {
                item.setChecked(true);
            } else {
                item.setChecked(false);
            }
            this.viewer.refresh();
            ++n2;
        }
    }
}

