/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.composer.api.CodeManagerLauncher;
import org.polarsys.kitalpha.composer.api.ParameterError;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.ui.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerValidator {
    private String ERROR_VALID_FOLDER1 = "The models contained in ";
    private String ERROR_VALID_FOLDER2 = "/ aren't valid";
    private String ERROR_VALID_FILE = "The model ";
    private String ERROR_VALID_EOBJECT = "The EObject ";
    private String ERROR_VALID_MODEL = " isn't valid";
    private String ERROR_VALID_END = " for this launch configuration.";
    private ILaunchConfiguration configuration = null;

    public ManagerValidator(ILaunchConfiguration configuration) {
        this.configuration = configuration;
    }

    public ResourceSet isValidIFolder(IFolder folder) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            IResource[] members = folder.members();
            int index = 0;
            while (index < members.length) {
                IFile file;
                Resource resource;
                if (members[index] instanceof IFile && (resource = this.isValidIFile(file = (IFile)members[index])) != null) {
                    resourceSet.getResource(resource.getURI(), true);
                }
                ++index;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return resourceSet;
    }

    public Resource isValidIFile(IFile file) {
        ResourceSetImpl resourceSet;
        EObject root;
        boolean ok;
        Resource model = null;
        if (file != null && (ok = this.isOk(this.configuration, root = (EObject)(model = (resourceSet = new ResourceSetImpl()).getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true)).getContents().get(0)))) {
            return model;
        }
        return null;
    }

    public EObject isValidEObject(EObject eObject) {
        if (this.isOk(this.configuration, eObject)) {
            return eObject;
        }
        return null;
    }

    public static boolean openValidationDialog(Map<String, ParameterError> result) {
        boolean valid = false;
        if (result != null && !result.isEmpty()) {
            String parameterString = ManagerValidator.getParameterErrorsTrace(result);
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Code Manager", (String)("Problems encountered during validation :\n" + parameterString));
            valid = false;
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Code Manager", (String)"Validation completed successfully");
            valid = true;
        }
        return valid;
    }

    public static String getParameterErrorsTrace(Map<String, ParameterError> parametersMap) {
        String line = CodeManagerLauncher.getParameterErrorsTrace(parametersMap);
        line = line.replaceFirst(":", ":\n");
        line = line.replaceAll(",", "\n");
        return line;
    }

    private List<String> getChildrenBusinessUriExtensionList(ILaunchConfiguration configuration) {
        IConfigurationElement[] children = null;
        ArrayList<String> businessUri = new ArrayList<String>();
        try {
            String generationName = configuration.getAttribute("generation_name", "");
            IConfigurationElement element = CodeManagerExtensions.getBindingConfigElement((String)generationName);
            if (element != null) {
                children = element.getChildren();
                int index = 0;
                while (index < children.length) {
                    businessUri.add(children[index].getAttribute("NsUri"));
                    ++index;
                }
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return businessUri;
    }

    private boolean isOk(ILaunchConfiguration configuration, EObject eObject) {
        boolean ok = false;
        String modelUri = eObject.eClass().getEPackage().getNsURI();
        List<String> businessUriList = this.getChildrenBusinessUriExtensionList(configuration);
        for (String businessUri : businessUriList) {
            ok = businessUri.equals(modelUri);
            if (ok) break;
        }
        return ok;
    }

    public class ValidationException
    extends Exception {
        private static final long serialVersionUID = 3470254369248363780L;

        public ValidationException(IFile selection) {
            super(String.valueOf(ManagerValidator.this.ERROR_VALID_FILE) + selection.getName() + ManagerValidator.this.ERROR_VALID_MODEL + ManagerValidator.this.ERROR_VALID_END);
        }

        public ValidationException(IFolder selection) {
            super(String.valueOf(ManagerValidator.this.ERROR_VALID_FOLDER1) + selection.getName() + ManagerValidator.this.ERROR_VALID_FOLDER2 + ManagerValidator.this.ERROR_VALID_END);
        }

        public ValidationException(EObject selection) {
            super(String.valueOf(ManagerValidator.this.ERROR_VALID_EOBJECT) + selection.toString() + ManagerValidator.this.ERROR_VALID_MODEL + ManagerValidator.this.ERROR_VALID_END);
        }
    }
}

