/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.mdsofa.common.misc.ExtensionClassDescriptor;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryImpl;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.category.Messages;

public class CategoryRegistry {
    protected static CategoryRegistry _categoryRegistry = null;
    private static final String CONTENT_PROVIDER_CATEGORY = Messages.getString("CategoryRegistry.ContentProvider");
    protected List<ICategory> categoriesCache = new ArrayList<ICategory>(0);
    protected HashMap<String, ICategory> currentElementRegistry = null;
    protected HashMap<String, ICategory> diagramElementRegistry = null;
    protected HashMap<String, ICategory> referencedElementRegistry = null;
    protected HashMap<String, ICategory> referencingElementRegistry = null;
    private Collection<ExtensionClassDescriptor> availableForTypeClassDescriptors;

    private CategoryRegistry() {
        this.initRegister();
    }

    public Set<ICategory> gatherCategories(String viewerId, EObject currentElement) {
        Set<ICategory> result = this.gatherCategoriesInternal(currentElement, this.getRegistry(viewerId));
        return result;
    }

    private Set<ICategory> gatherCategoriesInternal(Object element, HashMap<String, ICategory> elementRegistry) {
        HashSet<ICategory> categories = new HashSet<ICategory>(0);
        Set<Map.Entry<String, ICategory>> entrySet = elementRegistry.entrySet();
        for (Map.Entry<String, ICategory> entry : entrySet) {
            ICategory category = entry.getValue();
            if (!category.isAvailableForType(element) || !category.isTopLevel()) continue;
            categories.add(category);
        }
        return categories;
    }

    public List<ICategory> gatherSubCategories(String viewerId, EObject currentElement, ICategory category) {
        List<ICategory> result = this.gatherSubCategoriesInternal(currentElement, category, this.getRegistry(viewerId));
        return result;
    }

    private List<ICategory> gatherSubCategoriesInternal(Object element, ICategory category, HashMap<String, ICategory> elementRegistry) {
        ArrayList<ICategory> subCategories = new ArrayList<ICategory>(0);
        for (String subCategoryId : category.getSubCategoryIds()) {
            ICategory subCategory = elementRegistry.get(subCategoryId);
            if (subCategory == null || !subCategory.isAvailableForType(element)) continue;
            subCategories.add(subCategory);
        }
        return subCategories;
    }

    protected HashMap<String, ICategory> getRegistry(String viewerId) {
        if (viewerId.equalsIgnoreCase("CurrentElementBrowser")) {
            return this.currentElementRegistry;
        }
        if (viewerId.equalsIgnoreCase("ReferencedElementBrowser")) {
            return this.referencedElementRegistry;
        }
        if (viewerId.equalsIgnoreCase("ReferencingElementBrowser")) {
            return this.referencingElementRegistry;
        }
        return this.diagramElementRegistry;
    }

    private void initRegister() {
        IConfigurationElement[] categories;
        this.currentElementRegistry = new HashMap(0);
        this.referencedElementRegistry = new HashMap(0);
        this.referencingElementRegistry = new HashMap(0);
        this.diagramElementRegistry = new HashMap(0);
        this.availableForTypeClassDescriptors = new HashSet<ExtensionClassDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = categories = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.common.ui.toolkit.browser", (String)CONTENT_PROVIDER_CATEGORY);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] targetBrowserIdNode;
            IConfigurationElement[] typeConfigurationElement;
            IConfigurationElement[] queryConfigurationElements;
            IConfigurationElement[] itemQueriesNode;
            IConfigurationElement categoryConfigurationElement = iConfigurationElementArray[n2];
            CategoryImpl category = new CategoryImpl();
            String categoryId = categoryConfigurationElement.getAttribute("id");
            category.setId(categoryId);
            String categoryName = categoryConfigurationElement.getAttribute("name");
            category.setName(categoryName);
            String isTopLevelCategory = categoryConfigurationElement.getAttribute(Messages.getString("CategoryRegistry.TopLevel"));
            if (isTopLevelCategory != null && isTopLevelCategory != "") {
                category.setIsTopLevel(Boolean.parseBoolean(isTopLevelCategory));
            } else {
                category.setIsTopLevel(false);
            }
            IConfigurationElement[] subCategoriesNodes = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.SubCategory"));
            if (subCategoriesNodes.length > 0) {
                IConfigurationElement[] subCategoryConfigurationElements;
                IConfigurationElement[] iConfigurationElementArray2 = subCategoryConfigurationElements = subCategoriesNodes[0].getChildren(Messages.getString("CategoryRegistry.Category"));
                int n3 = subCategoryConfigurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement subCategoryConfigurationElement = iConfigurationElementArray2[n4];
                    category.addSubCategoryId(subCategoryConfigurationElement.getAttribute("id"));
                    ++n4;
                }
            }
            if ((itemQueriesNode = categoryConfigurationElement.getChildren(Messages.getString("ItemQueries"))).length > 0) {
                IConfigurationElement[] itemQueries = itemQueriesNode[0].getChildren(Messages.getString("basicQuery"));
                List<IConfigurationElement> basicQueryCollection = Arrays.asList(itemQueries);
                List<IConfigurationElement> navigationQueryCollection = Arrays.asList(itemQueriesNode[0].getChildren(Messages.getString("CategoryRegistry.NavigationQuery")));
                basicQueryCollection.addAll(navigationQueryCollection);
                IConfigurationElement[] iConfigurationElementArray3 = itemQueries = (IConfigurationElement[])basicQueryCollection.toArray();
                int n5 = itemQueries.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement itemQueryConfigurationElement = iConfigurationElementArray3[n6];
                    Object queryInstance = ExtensionPointHelper.createInstance((IConfigurationElement)itemQueryConfigurationElement, (String)"class");
                    category.addItemQuery(queryInstance);
                    ++n6;
                }
            }
            if ((queryConfigurationElements = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.CategoryQuery"))).length > 0) {
                Object query = null;
                IConfigurationElement queryConfigurationElement = queryConfigurationElements[0];
                IConfigurationElement[] categoryQueries = queryConfigurationElement.getChildren(Messages.getString("basicQuery"));
                if (categoryQueries.length == 0) {
                    categoryQueries = queryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.NavigationQuery"));
                }
                if (categoryQueries.length > 0) {
                    query = ExtensionPointHelper.createInstance((IConfigurationElement)categoryQueries[0], (String)"class");
                }
                category.setQuery(query);
            }
            if ((typeConfigurationElement = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.AvailableForType"))).length > 0) {
                String qualifiedClassName = typeConfigurationElement[0].getAttribute("class");
                category.setTypeFullyQualifiedName(qualifiedClassName);
                this.availableForTypeClassDescriptors.add(new ExtensionClassDescriptor(typeConfigurationElement[0]));
            }
            if ((targetBrowserIdNode = categoryConfigurationElement.getChildren(Messages.getString("CategoryRegistry.TargetBrowserId"))).length > 0) {
                IConfigurationElement browserIdConfigurationElement = targetBrowserIdNode[0];
                String id = browserIdConfigurationElement.getAttribute("id");
                if (id.equalsIgnoreCase("CurrentElementBrowser")) {
                    this.currentElementRegistry.put(categoryId, category);
                } else if (id.equalsIgnoreCase("ReferencingElementBrowser")) {
                    this.referencingElementRegistry.put(categoryId, category);
                } else if (id.equalsIgnoreCase("ReferencedElementBrowser")) {
                    this.referencedElementRegistry.put(categoryId, category);
                } else {
                    this.diagramElementRegistry.put(categoryId, category);
                }
            }
            ++n2;
        }
    }

    public ICategory getCategory(String categoryId) {
        ICategory category = null;
        if (this.getRegistry("ReferencedElementBrowser").containsKey(categoryId)) {
            category = this.getRegistry("ReferencedElementBrowser").get(categoryId);
        } else if (this.getRegistry("ReferencingElementBrowser").containsKey(categoryId)) {
            category = this.getRegistry("ReferencingElementBrowser").get(categoryId);
        } else if (this.getRegistry("CurrentElementBrowser").containsKey(categoryId)) {
            category = this.getRegistry("CurrentElementBrowser").get(categoryId);
        }
        return category;
    }

    public Collection<ExtensionClassDescriptor> getAvailableForTypeClassDescriptors() {
        return this.availableForTypeClassDescriptors;
    }

    public static CategoryRegistry getInstance() {
        if (_categoryRegistry == null) {
            _categoryRegistry = new CategoryRegistry();
        }
        return _categoryRegistry;
    }
}

