/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.commands;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.projection.commands.ESToISCommand;
import org.polarsys.capella.core.projection.commands.Messages;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.scenario.ES2ESTransform;

public class EStoESCommand
extends ESToISCommand {
    public EStoESCommand(Collection<EObject> rootElements_p) {
        super(rootElements_p);
    }

    public EStoESCommand(Collection<EObject> rootElements_p, IProgressMonitor progressMonitor_p) {
        super(rootElements_p, progressMonitor_p);
    }

    @Override
    public String getName() {
        if (this._rootElements != null && this._rootElements.size() > 0) {
            EObject element = (EObject)this._rootElements.iterator().next();
            if (TransitionHelper.getService().isES2ESForOASATransitionAvailable(element)) {
                return Messages.transitionES2ES_OAtoSA_label;
            }
            if (TransitionHelper.getService().isES2ESForSALATransitionAvailable(element)) {
                return Messages.transitionES2ES_SAtoLA_label;
            }
            if (TransitionHelper.getService().isES2ESForLAPATransitionAvailable(element)) {
                return Messages.transitionES2ES_LAtoPA_label;
            }
        }
        return Messages.transitionES2ES_label;
    }

    @Override
    protected AbstractTransform getTransformation(EObject element_p) {
        return new ES2ESTransform();
    }

    @Override
    protected boolean isScenarioValid(Scenario scenario_p) {
        return TransitionHelper.getService().isES2ESTransitionAvailable((EObject)scenario_p);
    }
}

