/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.mdsofa.common.listener;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;

public abstract class AbstractProjectListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event_p) {
        IResourceDelta resourceDelta = event_p.getDelta();
        if (resourceDelta == null) {
            return;
        }
        IResource resource = resourceDelta.getResource();
        if (4 == resourceDelta.getKind() && resource instanceof IWorkspaceRoot) {
            IResourceDelta[] childrenResourceDeltas;
            IResourceDelta[] iResourceDeltaArray = childrenResourceDeltas = resourceDelta.getAffectedChildren();
            int n = childrenResourceDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta currentChildResourceDelta = iResourceDeltaArray[n2];
                int kind = currentChildResourceDelta.getKind();
                IResource childResource = currentChildResourceDelta.getResource();
                IProject project = this.getProject(childResource);
                if (project != null) {
                    switch (kind) {
                        case 1: {
                            this.handleProjectAdded(project, currentChildResourceDelta);
                            break;
                        }
                        case 4: {
                            int flags = currentChildResourceDelta.getFlags();
                            boolean isProjectOpened = project.isOpen();
                            if (16384 == flags) {
                                if (isProjectOpened) {
                                    this.handleProjectAdded(project, currentChildResourceDelta);
                                    break;
                                }
                                this.handleProjectClosed(project, currentChildResourceDelta);
                                break;
                            }
                            this.handleProjectChanged(project, currentChildResourceDelta);
                            break;
                        }
                        case 2: {
                            this.handleProjectRemoved(project, currentChildResourceDelta);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    protected abstract void handleProjectAdded(IProject var1, IResourceDelta var2);

    protected abstract void handleProjectChanged(IProject var1, IResourceDelta var2);

    protected abstract void handleProjectRemoved(IProject var1, IResourceDelta var2);

    protected abstract void handleProjectClosed(IProject var1, IResourceDelta var2);

    protected IProject getProject(IResource resource_p) {
        IProject result = null;
        if (resource_p != null && resource_p instanceof IProject) {
            result = (IProject)resource_p;
        }
        return result;
    }
}

