/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;
import org.polarsys.capella.core.ui.toolkit.AbstractCommandActionHandler;
import org.polarsys.kitalpha.emde.model.Element;

public class CapellaDeleteAction
extends AbstractCommandActionHandler
implements IPropertyChangeListener {
    public CapellaDeleteAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Delete_menu_item"));
        CapellaActionsActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Command createCommand(Collection<Object> selection) {
        return new CapellaDeleteCommand(TransactionHelper.getExecutionManager((Collection)this.filterSelection(selection)), selection);
    }

    public void dispose() {
        CapellaActionsActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.startsWith("Delete_Restriction_")) {
            this.setEnabled(this.updateSelection(this.getStructuredSelection()));
        } else if (property.equals("Confirm_Delete")) {
            this.setEnabled(this.updateSelection(this.getStructuredSelection()));
        }
    }

    public void run() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.CapellaDeleteCommand_Label, -1);
                CapellaDeleteAction.this.getCommand().execute();
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(false, false, runnable);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        List selectedElements = this.getStructuredSelection().toList();
        boolean result = CapellaDeleteAction.canDelete(selectedElements);
        if (result) {
            result = super.updateSelection(selection);
        }
        return result;
    }

    public static boolean canDelete(Collection<?> selectedElement) {
        if (selectedElement.isEmpty()) {
            return false;
        }
        Iterable selectedModelElements = Iterables.filter(selectedElement, Element.class);
        for (Element selectedModelElement : selectedModelElements) {
            if (!CapellaActionsActivator.getDefault().isMetaclassProtected(selectedModelElement.eClass()) && !CapellaDeleteAction.isElementProtected(selectedModelElement)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isElementProtected(Element elt) {
        if (elt instanceof AbstractFunction) {
            return EcoreUtil2.isContainedBy((EObject)elt, (EClass)OaPackage.Literals.OPERATIONAL_ACTIVITY_PKG) && !EcoreUtil2.isContainedBy((EObject)elt, (EClass)OaPackage.Literals.OPERATIONAL_ACTIVITY) || EcoreUtil2.isContainedBy((EObject)elt, (EClass)CtxPackage.Literals.SYSTEM_FUNCTION_PKG) && !EcoreUtil2.isContainedBy((EObject)elt, (EClass)CtxPackage.Literals.SYSTEM_FUNCTION) || EcoreUtil2.isContainedBy((EObject)elt, (EClass)LaPackage.Literals.LOGICAL_FUNCTION_PKG) && !EcoreUtil2.isContainedBy((EObject)elt, (EClass)LaPackage.Literals.LOGICAL_FUNCTION) || EcoreUtil2.isContainedBy((EObject)elt, (EClass)PaPackage.Literals.PHYSICAL_FUNCTION_PKG) && !EcoreUtil2.isContainedBy((EObject)elt, (EClass)PaPackage.Literals.PHYSICAL_FUNCTION);
        }
        if (elt instanceof LogicalComponent) {
            return !EcoreUtil2.isContainedBy((EObject)elt, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        }
        if (elt instanceof PhysicalComponent) {
            return !EcoreUtil2.isContainedBy((EObject)elt, (EClass)PaPackage.Literals.PHYSICAL_COMPONENT);
        }
        if (elt instanceof ConfigurationItem) {
            return !EcoreUtil2.isContainedBy((EObject)elt, (EClass)EpbsPackage.Literals.CONFIGURATION_ITEM);
        }
        if (elt instanceof Part) {
            AbstractType type = ((Part)elt).getAbstractType();
            if (type != null) {
                return CapellaActionsActivator.getDefault().isMetaclassProtected(type.eClass()) || CapellaDeleteAction.isElementProtected((Element)type);
            }
        } else {
            if (elt instanceof SequenceMessage) {
                SequenceMessage msg = (SequenceMessage)elt;
                return msg.getReceivingEnd() != null && msg.getKind() != MessageKind.CREATE && msg.getKind() != MessageKind.DELETE;
            }
            if (elt instanceof ModelInformation) {
                return true;
            }
        }
        return false;
    }
}

