/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.AbstractFunctionalStructure;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeCategory;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.platform.sirius.ui.actions.CreateCategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.WizardActionHelper;

public class CreateCECategoriesController
extends CreateCategoriesController {
    @Override
    public void createAndAttachCategory(List<EObject> selection) {
        super.createAndAttachCategory(selection);
        List<EClass> containerEClasses = Arrays.asList(FaPackage.eINSTANCE.getAbstractFunctionalBlock(), FaPackage.eINSTANCE.getAbstractFunctionalStructure());
        EObject categoryContainer = this.getBestContainerForCategory(selection, containerEClasses);
        if (this.isNullOrNotInstanceOf(categoryContainer, containerEClasses)) {
            return;
        }
        ComponentExchangeCategory exchangeCategory = (ComponentExchangeCategory)this.createCategory(categoryContainer);
        InputDialog inputDialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.CreateCategoriesController_create_cat, Messages.CreateCategoriesController_cat_name, exchangeCategory.getName(), null);
        if (inputDialog.open() == 0) {
            String categoryName = inputDialog.getValue();
            exchangeCategory.setName(categoryName);
            if (categoryContainer instanceof AbstractFunctionalBlock) {
                ((AbstractFunctionalBlock)categoryContainer).getOwnedComponentExchangeCategories().add((Object)exchangeCategory);
            }
            if (categoryContainer instanceof AbstractFunctionalStructure) {
                ((AbstractFunctionalStructure)categoryContainer).getOwnedComponentExchangeCategories().add((Object)exchangeCategory);
            }
            for (EObject ce : selection) {
                if (!(ce instanceof ComponentExchange)) continue;
                exchangeCategory.getExchanges().add((Object)((ComponentExchange)ce));
            }
            this.logResults(Messages.CreateCECategoriesController_creation_msg, (NamedElement)exchangeCategory);
        } else {
            WizardActionHelper.deleteCreatedCategory((CapellaElement)exchangeCategory);
        }
    }

    @Override
    protected EObject createCategory(EObject container) {
        EReference feature = null;
        if (container instanceof AbstractFunctionalBlock) {
            feature = FaPackage.eINSTANCE.getAbstractFunctionalBlock_OwnedComponentExchangeCategories();
        } else if (container instanceof AbstractFunctionalStructure) {
            feature = FaPackage.eINSTANCE.getAbstractFunctionalStructure_OwnedComponentExchangeCategories();
        }
        ComponentExchangeCategory exchangeCategory = FaFactory.eINSTANCE.createComponentExchangeCategory();
        String defaultName = EcoreUtil2.getUniqueName((EObject)exchangeCategory, (EObject)container, (EStructuralFeature)feature, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)Messages.CreateCECategoriesController_prefix);
        exchangeCategory.setName(defaultName);
        return exchangeCategory;
    }
}

