/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.platform.sirius.ui.actions.CreateCategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.WizardActionHelper;

public class CreateFECategoriesController
extends CreateCategoriesController {
    @Override
    public void createAndAttachCategory(List<EObject> selection) {
        List<EClass> funcPkgEClass = Collections.singletonList(FaPackage.eINSTANCE.getFunctionPkg());
        EObject categoryContainer = this.getBestContainerForCategory(selection, funcPkgEClass);
        if (this.isNullOrNotInstanceOf(categoryContainer, funcPkgEClass)) {
            return;
        }
        FunctionPkg pkgContainer = (FunctionPkg)categoryContainer;
        ExchangeCategory exchangeCategory = this.createCategory((EObject)pkgContainer);
        pkgContainer.getOwnedCategories().add((Object)exchangeCategory);
        InputDialog inputDialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.CreateCategoriesController_create_cat, Messages.CreateCategoriesController_cat_name, exchangeCategory.getName(), null);
        if (inputDialog.open() == 0) {
            String categoryName = inputDialog.getValue();
            exchangeCategory.setName(categoryName);
            for (EObject fe : selection) {
                if (!(fe instanceof FunctionalExchange)) continue;
                exchangeCategory.getExchanges().add((Object)((FunctionalExchange)fe));
            }
            this.logResults(Messages.CreateFECategoriesController_creation_msg, (NamedElement)exchangeCategory);
        } else {
            WizardActionHelper.deleteCreatedCategory((CapellaElement)exchangeCategory);
        }
    }

    protected ExchangeCategory createCategory(EObject container) {
        ExchangeCategory exchangeCategory = FaFactory.eINSTANCE.createExchangeCategory();
        EReference feature = FaPackage.eINSTANCE.getFunctionPkg_OwnedCategories();
        String defaultName = EcoreUtil2.getUniqueName((EObject)exchangeCategory, (EObject)container, (EStructuralFeature)feature, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)Messages.CreateFECategoriesController_prefix);
        exchangeCategory.setName(defaultName);
        return exchangeCategory;
    }
}

