/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.platform.sirius.ui.actions.CreateCategoriesController;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.WizardActionHelper;

public class CreatePLCategoriesController
extends CreateCategoriesController {
    @Override
    public void createAndAttachCategory(List<EObject> selection) {
        super.createAndAttachCategory(selection);
        Component categoryContainer = (Component)this.getBestContainerForCategory(selection, Collections.singletonList(CsPackage.eINSTANCE.getComponent()));
        if (this.isNullOrNotInstanceOf((EObject)categoryContainer, Collections.singletonList(CsPackage.eINSTANCE.getComponent()))) {
            return;
        }
        PhysicalLinkCategory category = (PhysicalLinkCategory)this.createCategory((EObject)categoryContainer);
        InputDialog inputDialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.CreateCategoriesController_create_cat, Messages.CreateCategoriesController_cat_name, category.getName(), null);
        if (inputDialog.open() == 0) {
            String categoryName = inputDialog.getValue();
            category.setName(categoryName);
            categoryContainer.getOwnedPhysicalLinkCategories().add((Object)category);
            for (EObject fe : selection) {
                if (!(fe instanceof PhysicalLink)) continue;
                category.getLinks().add((Object)((PhysicalLink)fe));
            }
            this.logResults(Messages.CreatePLCategoriesController_creation_msg, (NamedElement)category);
        } else {
            WizardActionHelper.deleteCreatedCategory((CapellaElement)category);
        }
    }

    @Override
    protected EObject createCategory(EObject container) {
        PhysicalLinkCategory category = CsFactory.eINSTANCE.createPhysicalLinkCategory();
        EReference feature = CsPackage.eINSTANCE.getComponent_OwnedPhysicalLinkCategories();
        String defaultName = EcoreUtil2.getUniqueName((EObject)category, (EObject)container, (EStructuralFeature)feature, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)Messages.CreatePLCategoriesController_prefix);
        category.setName(defaultName);
        return category;
    }
}

