/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.command.DeleteStructureCommand;
import org.polarsys.capella.core.model.handler.command.IDeleteHelper;
import org.polarsys.capella.core.model.handler.command.PreDeleteHandler;
import org.polarsys.capella.core.model.handler.command.PreDeleteStructureCommand;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.platform.sirius.ui.commands.AbstractCapellaDeleteHook;
import org.polarsys.capella.core.platform.sirius.ui.commands.DeleteRepresentationCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;
import org.polarsys.capella.core.platform.sirius.ui.preferences.IDeletePreferences;
import org.polarsys.capella.core.ui.toolkit.dialogs.ConfirmDeleteCapellaElementDialog;
import org.polarsys.capella.core.ui.toolkit.dialogs.ImpactAnalysisDialog;

public class CapellaDeleteCommand
extends AbstractCommand {
    private IDeleteHelper _deleteHelper = IDeleteHelper.DEFAULT;
    public static final String ID = "Delete";
    private static ArrayList<AbstractCapellaDeleteHook> __deleteCommandHooks;
    private Command _realCommand;
    private Collection<?> _selection;
    private Collection<?> _expandedSelection;
    private Set<Object> _allElementsToDelete;
    private Set<EObject> _controlledExpandedSelectionContents;
    private boolean _ensureTransaction;
    private ExecutionManager _executionManager;
    private EditingDomain _editingDomain;
    private boolean _sendLongRunningEvents;
    private boolean _confirmDelete;

    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection) {
        this(executionManager, selection, true);
    }

    public CapellaDeleteCommand(EditingDomain editingDomain, Collection<?> selection, boolean confirmDelete) {
        this(null, selection, false, confirmDelete, true);
        this._editingDomain = editingDomain;
    }

    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction) {
        this(executionManager, selection, ensureTransaction, IDeletePreferences.INSTANCE.isConfirmationRequired(), true);
    }

    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction, boolean confirmDelete, boolean longOperationEvents) {
        this._executionManager = executionManager;
        this._editingDomain = executionManager != null ? executionManager.getEditingDomain() : null;
        this._ensureTransaction = ensureTransaction;
        this._confirmDelete = confirmDelete;
        this._sendLongRunningEvents = longOperationEvents;
        this._selection = new ArrayList(selection);
    }

    public boolean canUndo() {
        if (this._realCommand != null) {
            return this._realCommand.canUndo();
        }
        return false;
    }

    public void execute() {
        Set<? extends EObject> allControlledElementsToDelete = this.getAllControlledElementsToDelete();
        if (allControlledElementsToDelete.size() > 0) {
            this.showAbortDialogForControlledElementsToDelete(allControlledElementsToDelete);
            return;
        }
        if (this._confirmDelete) {
            final int[] dialogResult = new int[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ConfirmDeleteCapellaElementDialog confirmDeletionDialog = new ConfirmDeleteCapellaElementDialog(new ArrayList(CapellaDeleteCommand.this.getAllElementsToDelete()), true, CapellaDeleteCommand.this.getExpandedSelection().toArray());
                    dialogResult[0] = confirmDeletionDialog.open();
                }
            });
            if (dialogResult[0] != 0) {
                return;
            }
        }
        if (this._ensureTransaction) {
            this._executionManager.execute((ICommand)new AbstractReadWriteCommand(){

                public void commandRolledBack() {
                    if (CapellaDeleteCommand.this._sendLongRunningEvents) {
                        LongRunningListenersRegistry.getInstance().operationAborted(CapellaDeleteCommand.class);
                    }
                }

                public Collection<?> getAffectedObjects() {
                    if (CapellaDeleteCommand.this._realCommand != null) {
                        return CapellaDeleteCommand.this._realCommand.getAffectedObjects();
                    }
                    return super.getAffectedObjects();
                }

                public String getName() {
                    return Messages.CapellaDeleteCommand_Label;
                }

                public void run() {
                    CapellaDeleteCommand.this.doExecute();
                }
            });
        } else {
            try {
                this.doExecute();
            }
            catch (Exception re) {
                CapellaActionsActivator.getDefault().getLog().log((IStatus)new Status(2, CapellaActionsActivator.getDefault().getPluginId(), re.getMessage(), (Throwable)re));
            }
        }
    }

    protected void doExecute() {
        if (this._sendLongRunningEvents) {
            LongRunningListenersRegistry.getInstance().operationStarting(CapellaDeleteCommand.class);
        }
        for (AbstractCapellaDeleteHook hook : this.getDeleteCommandHooks()) {
            if (hook.preDelete(this.getAllElementsToDelete()).isOK()) continue;
            if (this._sendLongRunningEvents) {
                LongRunningListenersRegistry.getInstance().operationAborted(CapellaDeleteCommand.class);
            }
            return;
        }
        try {
            this._realCommand = new DeleteStructureCommand(this._editingDomain, this.getExpandedSelection(), this.isDeletingPartTypesForMultiPartProjects()){

                protected void doPrepare() {
                    this.append((Command)new DeleteRepresentationCommand((TransactionalEditingDomain)this.getEditingDomain(), RepresentationHelper.getAllRepresentationsTargetedBy(CapellaDeleteCommand.this.getExpandedSelection())));
                    super.doPrepare();
                }
            };
            if (this._realCommand.canExecute()) {
                this._realCommand.execute();
            }
        }
        finally {
            if (this._sendLongRunningEvents) {
                LongRunningListenersRegistry.getInstance().operationEnded(CapellaDeleteCommand.class);
            }
        }
    }

    protected boolean isDeletingPartTypesForMultiPartProjects() {
        return IDeletePreferences.INSTANCE.isDeletingPartType();
    }

    public Collection<?> getAffectedObjects() {
        if (this._realCommand != null) {
            return this._realCommand.getAffectedObjects();
        }
        return super.getAffectedObjects();
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        if (this._realCommand != null) {
            this._realCommand.redo();
        }
    }

    public void undo() {
        if (this._realCommand != null) {
            this._realCommand.undo();
        }
    }

    private List<AbstractCapellaDeleteHook> getDeleteCommandHooks() {
        if (__deleteCommandHooks == null) {
            IConfigurationElement[] configurationElements;
            __deleteCommandHooks = new ArrayList();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = ExtensionPointHelper.getConfigurationElements((String)CapellaActionsActivator.getDefault().getPluginId(), (String)"deleteCommandDelegation");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                __deleteCommandHooks.add((AbstractCapellaDeleteHook)ExtensionPointHelper.createInstance((IConfigurationElement)elem, (String)"class"));
                ++n2;
            }
        }
        return __deleteCommandHooks;
    }

    protected void showAbortDialogForControlledElementsToDelete(final Set<? extends EObject> controlledElementsToDelete) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ImpactAnalysisDialog dialog = new ImpactAnalysisDialog(new ArrayList(controlledElementsToDelete), Messages.CapellaDeleteCommand_Label, Messages.CapellaDeleteCommand_ControlledElementsError_Message, 1, new String[]{org.polarsys.capella.common.ui.toolkit.dialogs.Messages.AbstractViewerDialog_OK_Title}, 3, false);
                dialog.open();
            }
        });
    }

    protected boolean confirmDeletion() {
        final int[] dialogResult = new int[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ImpactAnalysisDialog dialog = new ImpactAnalysisDialog(new ArrayList(CapellaDeleteCommand.this.getAllElementsToDelete()), Messages.CapellaDeleteCommand_Label, Messages.CapellaDeleteCommand_ConfirmDeletionQuestion, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 3, true){
                    private TreeViewer _referencingViewer;

                    protected void createReferencingElementViewer(Composite parent) {
                        Group referencingElementsGroup = new Group(parent, 0);
                        referencingElementsGroup.setText(Messages.CapellaDeleteCommand_ImpactAnalysis_ReferencingElements_Group_Title);
                        referencingElementsGroup.setToolTipText(Messages.CapellaDeleteCommand_ImpactAnalysis_ReferencingElements_Group_Tooltip);
                        referencingElementsGroup.setLayout((Layout)new GridLayout());
                        referencingElementsGroup.setLayoutData((Object)new GridData(1808));
                        this._referencingViewer = super.createViewer((Composite)referencingElementsGroup);
                        this._referencingViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ImpactAnalysisDialog.ImpactAnalysisLabelProvider((ImpactAnalysisDialog)this, this._referencingViewer, 9), (ILabelDecorator)PlatformUI.getWorkbench().getDecoratorManager()));
                        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                            public void selectionChanged(SelectionChangedEvent event) {
                                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                                List selectedElements = ssel.toList();
                                HashSet referencingElements = new HashSet(0);
                                for (Object currentSelectedElement : selectedElements) {
                                    if (!((TreeData)this.getViewer().getInput()).isValid(currentSelectedElement) || !(currentSelectedElement instanceof EObject)) continue;
                                    referencingElements.addAll(CrossReferencerHelper.getReferencingElements((EObject)((EObject)currentSelectedElement)));
                                }
                                _referencingViewer.setInput((Object)new TreeData(new ArrayList(referencingElements), null));
                            }
                        });
                    }

                    protected void createViewerArea(Composite parent) {
                        GridLayout layout = (GridLayout)parent.getLayout();
                        layout.numColumns = 2;
                        layout.makeColumnsEqualWidth = true;
                        layout.marginWidth = 0;
                        Group deletedElementsGroup = new Group(parent, 0);
                        deletedElementsGroup.setText(Messages.CapellaDeleteCommand_ImpactAnalysis_DeletedElements_Group_Title);
                        deletedElementsGroup.setToolTipText(Messages.CapellaDeleteCommand_ImpactAnalysis_DeletedElements_Group_Tooltip);
                        deletedElementsGroup.setLayout((Layout)new GridLayout());
                        deletedElementsGroup.setLayoutData((Object)new GridData(1808));
                        super.createViewerArea((Composite)deletedElementsGroup);
                        this.createReferencingElementViewer(parent);
                        TreeViewer treeViewer = this.getViewer();
                        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ImpactAnalysisDialog.ImpactAnalysisLabelProvider((ImpactAnalysisDialog)this, treeViewer, 3), (ILabelDecorator)PlatformUI.getWorkbench().getDecoratorManager()));
                        treeViewer.setSelection((ISelection)new StructuredSelection(CapellaDeleteCommand.this.getExpandedSelection().toArray()), true);
                        treeViewer.getControl().setFocus();
                    }

                    protected int getDialogWidth() {
                        return 800;
                    }
                };
                dialogResult[0] = dialog.open();
            }
        });
        return dialogResult[0] == 0;
    }

    public Collection<?> getExpandedSelection() {
        if (this._expandedSelection == null) {
            this._expandedSelection = Collections.unmodifiableCollection(this._deleteHelper.getExpandedSelection(this._selection));
        }
        return this._expandedSelection;
    }

    public IDeleteHelper getDeleteHelper() {
        return this._deleteHelper;
    }

    public void setDeleteHelper(IDeleteHelper helper) {
        this._deleteHelper = helper;
    }

    public Set<? extends EObject> getAllControlledElementsToDelete() {
        if (this._controlledExpandedSelectionContents == null) {
            HashSet<EObject> result = new HashSet<EObject>();
            for (Object deletedElement : this.getAllElementsToDelete()) {
                if (!AdapterFactoryEditingDomain.isControlled(deletedElement)) continue;
                result.add((EObject)deletedElement);
            }
            this._controlledExpandedSelectionContents = Collections.unmodifiableSet(result);
        }
        return this._controlledExpandedSelectionContents;
    }

    public Set<?> getAllElementsToDelete() {
        if (this._allElementsToDelete == null) {
            HashSet<EObject> result = new HashSet<EObject>();
            PreDeleteHandler handler = new PreDeleteHandler();
            PreDeleteStructureCommand preDeletion = new PreDeleteStructureCommand(this._editingDomain, this.getExpandedSelection(), this.isDeletingPartTypesForMultiPartProjects(), handler);
            if (preDeletion.canExecute()) {
                preDeletion.execute();
            }
            block6: for (Notification notification : handler._notifications) {
                Object notifier = notification.getNotifier();
                if (!(notifier instanceof EObject)) continue;
                Object oldValue = notification.getOldValue();
                int notificationType = notification.getEventType();
                switch (notificationType) {
                    case 1: {
                        if (notification.getNewValue() != null) continue block6;
                    }
                    case 4: {
                        if (!(oldValue instanceof EObject)) break;
                        boolean handleNotification = false;
                        try {
                            EReference feature = (EReference)EReference.class.cast(notification.getFeature());
                            handleNotification = feature != null ? feature.isContainment() : false;
                        }
                        catch (ClassCastException cce) {
                            handleNotification = true;
                        }
                        if (!handleNotification) break;
                        EObject deletedObject = (EObject)oldValue;
                        result.add(deletedObject);
                        if (!CapellaResourceHelper.isSemanticElement((Object)deletedObject)) break;
                        TreeIterator allChildrenOfDeletedObject = deletedObject.eAllContents();
                        while (allChildrenOfDeletedObject.hasNext()) {
                            EObject child = (EObject)allChildrenOfDeletedObject.next();
                            result.add(child);
                        }
                        continue block6;
                    }
                }
            }
            handler.dispose();
            this._allElementsToDelete = Collections.unmodifiableSet(result);
        }
        return this._allElementsToDelete;
    }

    protected void fillStructure(EObject parent, EObject removedElement, Map<EObject, Set<EObject>> parentsToChildren) {
        if (parent == null || removedElement == null || parentsToChildren == null) {
            return;
        }
        Set<EObject> children = parentsToChildren.get(parent);
        if (children == null) {
            children = new HashSet<EObject>(1);
            parentsToChildren.put(parent, children);
        }
        children.add(removedElement);
        for (EObject removed : removedElement.eContents()) {
            this.fillStructure(removedElement, removed, parentsToChildren);
        }
    }

    public static boolean confirmDeletion(ExecutionManager manager, Collection<?> selection) {
        DryRun dr = new DryRun(manager, selection);
        dr.execute();
        return dr.proceed();
    }

    static class DryRun
    extends CapellaDeleteCommand {
        boolean proceed = false;

        public DryRun(ExecutionManager executionManager, Collection<?> selection) {
            super(executionManager, selection);
        }

        public boolean proceed() {
            return this.proceed;
        }

        @Override
        public void doExecute() {
            this.proceed = true;
        }
    }
}

