/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.app;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchWindowAdvisor;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.polarsys.capella.common.bundle.FeatureHelper;
import org.polarsys.capella.core.preferences.Activator;

public class CapellaWorkbenchWindowAdvisor
extends IDEWorkbenchWindowAdvisor {
    public CapellaWorkbenchWindowAdvisor(IDEWorkbenchAdvisor wbAdvisor, IWorkbenchWindowConfigurer configurer) {
        super(wbAdvisor, configurer);
    }

    public void openIntro() {
        boolean showIntro = PrefUtil.getAPIPreferenceStore().getBoolean("showIntro");
        super.openIntro();
        IWorkbenchConfigurer workbenchConfig = this.getWindowConfigurer().getWorkbenchConfigurer();
        IIntroManager introManager = workbenchConfig.getWorkbench().getIntroManager();
        boolean hasIntro = introManager.hasIntro();
        if (showIntro && hasIntro) {
            this.showPage("firststeps");
        }
    }

    boolean showPage(String pageId) {
        CustomizableIntroPart currentIntroPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        currentIntroPart.getControl().setRedraw(false);
        IntroModelRoot modelRoot = IntroPlugin.getDefault().getIntroModelRoot();
        boolean success = modelRoot.setCurrentPageId(pageId);
        currentIntroPart.getControl().setRedraw(true);
        if (success) {
            modelRoot.getPresentation().updateHistory(modelRoot.getCurrentPage());
            return true;
        }
        return false;
    }

    public void postWindowRestore() throws WorkbenchException {
        super.postWindowRestore();
        this.initCapellaPerspective();
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        this.initCapellaPerspective();
    }

    private void initCapellaPerspective() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        final IWorkbenchPage activePage = window.getActivePage();
        window.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                activePage.hideActionSet("org.eclipse.ui.edit.text.actionSet.navigation");
                activePage.hideActionSet("org.eclipse.ui.externaltools.ExternalToolsSet");
                activePage.hideActionSet("org.eclipse.ui.edit.text.actionSet.annotationNavigation");
                activePage.hideActionSet("org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo");
                activePage.hideActionSet("org.eclipse.ui.actionSet.openFiles");
            }
        });
        boolean updated = false;
        if (updated && "capella.sirius.perspective".equals(activePage.getPerspective().getId())) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    activePage.resetPerspective();
                }
            });
        }
    }

    public boolean updateCapellaVersion() {
        boolean updated = false;
        String currentCapellaVersion = FeatureHelper.getCapellaVersion((boolean)true);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String capellaRegisteredVersion = store.getString("product.version");
        if ("".equals(capellaRegisteredVersion) || !capellaRegisteredVersion.equals(currentCapellaVersion)) {
            store.putValue("product.version", currentCapellaVersion);
            updated = true;
        }
        return updated;
    }
}

