/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.platform.sirius.ted.SemanticCrossReferencer;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.projection.exchanges.DefaultExchangesCreator;

public class NodePhysicalComponentExchangesCreator
extends DefaultExchangesCreator {
    private Part _part = null;

    public NodePhysicalComponentExchangesCreator(Component component_p, Part part_p) {
        super(component_p);
        if (part_p != null) {
            this._part = part_p;
        }
    }

    @Override
    public void createExchanges() {
        if (this._component instanceof AbstractPhysicalComponent) {
            AbstractPhysicalComponent node = (AbstractPhysicalComponent)this._component;
            this.createExchangesForDeployedPhysicalComponents(node);
            super.createExchanges();
        }
    }

    @Override
    protected boolean isValidBound(Component component_p) {
        if (component_p instanceof AbstractPhysicalComponent) {
            AbstractPhysicalComponent component = (AbstractPhysicalComponent)component_p;
            PhysicalComponentNature nature = component.getNature();
            if (component instanceof PhysicalComponent && nature == PhysicalComponentNature.NODE) {
                return true;
            }
            if (component instanceof PhysicalActor) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isValidCreation(AbstractEventOperation fe_p, Component component_p, Component allocating_p) {
        return this.isValidBound(component_p) && this.isValidBound(allocating_p);
    }

    protected void createExchangesForDeployedPhysicalComponents(AbstractPhysicalComponent node_p) {
        EList deployments = this._part.getDeploymentLinks();
        for (AbstractDeploymentLink deployment : deployments) {
            if (!(deployment instanceof PartDeploymentLink)) continue;
            PartDeploymentLink deploymentLink = (PartDeploymentLink)deployment;
            DeployableElement deployedElement = deploymentLink.getDeployedElement();
            if (deployedElement != null && deployedElement instanceof Part) {
                Part part = (Part)deployedElement;
                Type type = part.getType();
                if (type == null) continue;
                this.createExchangesFromDeployedElement(node_p, type);
                continue;
            }
            if (deployedElement == null || !(deployedElement instanceof AbstractPhysicalComponent)) continue;
            this.createExchangesFromDeployedElement(node_p, (Type)((AbstractPhysicalComponent)deployedElement));
        }
    }

    private void createExchangesFromDeployedElement(AbstractPhysicalComponent node_p, Type type) {
        if (type != null && type instanceof AbstractPhysicalComponent) {
            AbstractPhysicalComponent deployedPhysicalComponent = (AbstractPhysicalComponent)type;
            for (ComponentPort port : ComponentExt.getOwnedComponentPort((Component)deployedPhysicalComponent)) {
                for (ComponentExchange connection : port.getComponentExchanges()) {
                    EObject container;
                    InformationsExchanger target;
                    if (connection.getKind() == ComponentExchangeKind.DELEGATION || connection.getKind() == ComponentExchangeKind.UNSET || this.doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(node_p, connection) || (target = FunctionalExt.getOtherBound((ExchangeSpecification)connection, (InformationsExchanger)port)) == null || !(target instanceof ComponentPort) || !((container = target.eContainer()) instanceof AbstractPhysicalComponent)) continue;
                    for (Partition partition : ((AbstractPhysicalComponent)container).getRepresentingPartitions()) {
                        if (!(partition instanceof Part)) continue;
                        for (DeploymentTarget deploying : PartExt.getDeployingElements((Part)((Part)partition))) {
                            AbstractPhysicalComponent typeDeploying;
                            Part deployingPart;
                            if (!(deploying instanceof Part) || (deployingPart = (Part)deploying).getAbstractType() == null || !(deployingPart.getAbstractType() instanceof AbstractPhysicalComponent) || !this.isValidCreation((AbstractEventOperation)connection, (Component)node_p, (Component)(typeDeploying = (AbstractPhysicalComponent)deployingPart.getAbstractType())) || this.doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(node_p, connection)) continue;
                            if (connection.getSource().equals(port)) {
                                this.doCreateExchange(connection, (Component)node_p, (Component)typeDeploying);
                                continue;
                            }
                            this.doCreateExchange(connection, (Component)typeDeploying, (Component)node_p);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void doCreateExchange(FunctionalExchange functionalExchange_p, Component exchangeOutput_p, Component exchangeInput_p) {
        PhysicalLink physicalLink = CsFactory.eINSTANCE.createPhysicalLink(functionalExchange_p.getLabel());
        PhysicalPort outP = CsFactory.eINSTANCE.createPhysicalPort(functionalExchange_p.getSource().getName());
        PhysicalPort inP = CsFactory.eINSTANCE.createPhysicalPort(functionalExchange_p.getTarget().getName());
        physicalLink.getLinkEnds().add((Object)outP);
        physicalLink.getLinkEnds().add((Object)inP);
        exchangeInput_p.getOwnedFeatures().add((Object)inP);
        exchangeOutput_p.getOwnedFeatures().add((Object)outP);
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
        PortExt.attachPort((Port)outP, (ActivityNode)functionalExchange_p.getSource());
        PortExt.attachPort((Port)inP, (ActivityNode)functionalExchange_p.getTarget());
    }

    protected void doCreateExchange(ComponentExchange componentExchange_p, Component exchangeOutput_p, Component exchangeInput_p) {
        if (exchangeOutput_p == exchangeInput_p) {
            return;
        }
        PhysicalLink physicalLink = CsFactory.eINSTANCE.createPhysicalLink(componentExchange_p.getLabel());
        PhysicalPort outP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange_p.getSource().getLabel());
        PhysicalPort inP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange_p.getTarget().getLabel());
        physicalLink.getLinkEnds().add((Object)outP);
        physicalLink.getLinkEnds().add((Object)inP);
        exchangeInput_p.getOwnedFeatures().add((Object)inP);
        exchangeOutput_p.getOwnedFeatures().add((Object)outP);
        CapellaElementExt.creationService((EObject)inP);
        CapellaElementExt.creationService((EObject)outP);
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
        CapellaElementExt.creationService((EObject)physicalLink);
        ComponentExchangeAllocation cea = FaFactory.eINSTANCE.createComponentExchangeAllocation();
        cea.setSourceElement((TraceableElement)physicalLink);
        cea.setTargetElement((TraceableElement)componentExchange_p);
        physicalLink.getOwnedComponentExchangeAllocations().add((Object)cea);
        CapellaElementExt.creationService((EObject)cea);
        InformationsExchanger target = componentExchange_p.getTarget();
        this.createComponentPortAllocation(target, inP);
        InformationsExchanger source = componentExchange_p.getSource();
        this.createComponentPortAllocation(source, outP);
    }

    private ComponentPortAllocation createComponentPortAllocation(InformationsExchanger informationExchange_p, PhysicalPort physicalPort_p) {
        ComponentPortAllocation allocation = FaFactory.eINSTANCE.createComponentPortAllocation();
        allocation.setSourceElement((TraceableElement)physicalPort_p);
        allocation.setTargetElement((TraceableElement)informationExchange_p);
        physicalPort_p.getOwnedComponentPortAllocations().add((Object)allocation);
        CapellaElementExt.creationService((EObject)allocation);
        return allocation;
    }

    protected boolean doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(AbstractPhysicalComponent physicalComponent_p, ComponentExchange componentExchange_p) {
        boolean result = false;
        SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)componentExchange_p);
        SemanticCrossReferencer crossReferencer = editingDomain.getCrossReferencer();
        Collection inverseReferences = crossReferencer.getInverseReferences((EObject)componentExchange_p, true);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            if (!(setting.getEObject() instanceof ComponentExchangeAllocation)) continue;
            result = true;
            break;
        }
        return result;
    }
}

