/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public abstract class AbstractPreferencesInitializer
extends AbstractPreferenceInitializer {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    public static ScopedCapellaPreferencesStore preferencesManager;
    IProject project = PreferencesHelper.getSelectedEclipseProject() != null ? PreferencesHelper.getSelectedEclipseProject() : PreferencesHelper.getSelectedCapellaProject();

    public AbstractPreferencesInitializer(String pluginID) {
        preferencesManager = ScopedCapellaPreferencesStore.getInstance(pluginID);
        this.initializeDefaultPreferences();
        try {
            ModelValidationService.getInstance().loadXmlConstraintDeclarations();
            PreferencesHelper.initializeCapellaPreferencesFromEPFFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void initializeDefaultPreferences();

    public void putBoolean(String key, boolean value, Class scopeClass) {
        if (scopeClass.equals(ProjectScope.class)) {
            this.project = PreferencesHelper.getSelectedCapellaProject();
            ScopedCapellaPreferencesStore.getOptions().put(key, String.valueOf(value));
            if (this.project != null) {
                ScopedCapellaPreferencesStore.putBoolean(this.project, key, value);
            } else {
                ScopedCapellaPreferencesStore.putBoolean(null, key, value);
            }
        }
        this.initializeAllOpenedProjects(key, value);
    }

    public void putString(String key, String value, Class scopeClass) {
        if (scopeClass.equals(ProjectScope.class)) {
            this.project = PreferencesHelper.getSelectedCapellaProject();
            ScopedCapellaPreferencesStore.getOptions().put(key, String.valueOf(value));
            if (this.project != null) {
                ScopedCapellaPreferencesStore.putString(this.project, key, String.valueOf(value));
            }
        } else {
            ScopedCapellaPreferencesStore.putString(null, key, String.valueOf(value));
        }
        this.initializeAllOpenedProjects(key, value);
    }

    public void putInt(String key, int value, Class scopeClass) {
        if (scopeClass.equals(ProjectScope.class)) {
            this.project = PreferencesHelper.getSelectedCapellaProject();
            ScopedCapellaPreferencesStore.getOptions().put(key, String.valueOf(value));
            if (this.project != null) {
                ScopedCapellaPreferencesStore.putInt(this.project, key, value);
            }
        } else {
            ScopedCapellaPreferencesStore.putInt(null, key, value);
        }
        this.initializeAllOpenedProjects(key, value);
    }

    private void initializeAllOpenedProjects(String key, Object value) {
        IProject[] iProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (value instanceof Boolean) {
            ScopedCapellaPreferencesStore.putBoolean(null, key, (Boolean)value);
        } else if (value instanceof String) {
            ScopedCapellaPreferencesStore.putString(null, key, (String)value);
        }
        IProject[] iProjectArray = iProjects;
        int n = iProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isOpen() && iProject.isAccessible() && CapellaResourceHelper.isCapellaProject((IProject)iProject)) {
                if (value instanceof Boolean) {
                    ScopedCapellaPreferencesStore.putBoolean(iProject, key, (Boolean)value);
                } else if (value instanceof String) {
                    ScopedCapellaPreferencesStore.putString(iProject, key, (String)value);
                }
            }
            ++n2;
        }
    }

    public static String getString(String key, boolean inProject) {
        return ScopedCapellaPreferencesStore.getString(true, key);
    }

    public static boolean getBoolean(String key, boolean inProjectScope) {
        return ScopedCapellaPreferencesStore.getBoolean(true, key);
    }

    public static int getInt(String key, boolean inProjectScope) {
        return ScopedCapellaPreferencesStore.getInt(true, key);
    }

    public static boolean getBoolean(String preferenceShowCapellaProjectConcept_p, Object contentChild_p) {
        return ScopedCapellaPreferencesStore.getBoolean(preferenceShowCapellaProjectConcept_p, contentChild_p);
    }
}

