/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.CustomPreferencesStatusCodes;
import org.polarsys.capella.core.commands.preferences.util.XmlConfigurationElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ItemsContentHandler
extends DefaultHandler {
    static final String VERSION_PARAMETER = "version";
    static final String NL_PARAMETER = "nl";
    private static final ResourceBundleCache resourceBundleCache = new ResourceBundleCache();
    private final IExtension extension;
    private final URL baseUrl;
    private final Stack stack = new Stack();
    private IConfigurationElement resultElement;
    private ResourceBundle resourceBundle;

    public ItemsContentHandler(IExtension extension, URL baseUrl) {
        this.extension = extension;
        this.baseUrl = baseUrl;
    }

    public IConfigurationElement getResult() {
        return this.resultElement;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        int attCount = atts.getLength();
        HashMap<String, String> attMap = new HashMap<String, String>();
        int i = 0;
        while (i < attCount) {
            attMap.put(atts.getQName(i), this.localize(atts.getValue(i)));
            ++i;
        }
        this.stack.push(new XmlConfigurationElement(qName, attMap, this.extension, this.baseUrl));
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.resultElement = this.stack.pop();
        if (!this.stack.isEmpty()) {
            this.stack.peek().addChild(this.resultElement);
            this.resultElement = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.stack.getBody().append(ch, start, length);
    }

    public static void flushResourceBundleCache() {
        resourceBundleCache.flush();
    }

    protected String localize(String s) {
        if (s == null || !s.startsWith("%")) {
            return s;
        }
        if (this.resourceBundle == null) {
            return Platform.getResourceString((Bundle)Platform.getBundle((String)this.extension.getNamespaceIdentifier()), (String)s);
        }
        return this.localize(s, this.resourceBundle);
    }

    protected String localize(String s, ResourceBundle bundle) {
        try {
            return bundle.getString(s.substring(1));
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return s;
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.fatalError(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.error(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.warning(e);
    }

    private String getFileName() {
        return this.baseUrl.getFile();
    }

    private static final class ResourceBundleCache {
        private final Map<Bundle, Map<String, ResourceBundle>> map = new HashMap<Bundle, Map<String, ResourceBundle>>();

        private ResourceBundleCache() {
        }

        ResourceBundle get(Bundle osgiBundle, String baseName) {
            ResourceBundle result = null;
            Map<String, ResourceBundle> secondLevel = this.map.get(osgiBundle);
            if (secondLevel != null) {
                result = secondLevel.get(baseName);
            }
            return result;
        }

        void put(Bundle osgiBundle, String baseName, ResourceBundle rb) {
            Map<String, ResourceBundle> secondLevel = this.map.get(osgiBundle);
            if (secondLevel == null) {
                secondLevel = new HashMap<String, ResourceBundle>();
                this.map.put(osgiBundle, secondLevel);
            }
            secondLevel.put(baseName, rb);
        }

        void flush() {
            this.map.clear();
        }
    }

    private class Stack {
        private final List<XmlConfigurationElement> contents = new ArrayList<XmlConfigurationElement>();
        private final List<StringBuffer> bodies = new ArrayList<StringBuffer>();
        private int lastIndex = -1;

        private Stack() {
        }

        public boolean isEmpty() {
            return this.contents.isEmpty();
        }

        public void push(XmlConfigurationElement element) {
            assert (element != null);
            this.contents.add(element);
            this.bodies.add(new StringBuffer(32));
            ++this.lastIndex;
        }

        public XmlConfigurationElement pop() throws SAXException {
            if (this.isEmpty()) {
                SAXException se = new SAXException(CustomPreferencesStatusCodes.XML_CANNOT_POP_STACK_MSG);
                se.printStackTrace();
                throw se;
            }
            XmlConfigurationElement result = this.contents.get(this.lastIndex);
            result.setValue(ItemsContentHandler.this.localize(this.getBody().toString().trim()));
            this.contents.remove(this.lastIndex);
            this.bodies.remove(this.lastIndex);
            --this.lastIndex;
            return result;
        }

        public XmlConfigurationElement peek() throws SAXException {
            if (this.isEmpty()) {
                SAXException se = new SAXException(CustomPreferencesStatusCodes.XML_CANNOT_PEEK_STACK_MSG);
                se.printStackTrace();
                throw se;
            }
            return this.contents.get(this.lastIndex);
        }

        public StringBuffer getBody() throws SAXException {
            if (this.isEmpty()) {
                SAXException se = new SAXException(CustomPreferencesStatusCodes.XML_NO_STACK_BODY_MSG);
                se.printStackTrace();
                throw se;
            }
            return this.bodies.get(this.lastIndex);
        }
    }
}

