/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.formatdata.AbstractFormatData;
import org.eclipse.sirius.diagram.ui.tools.api.format.AbstractSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class CapellaDiagramFormatDataManager
extends AbstractSiriusFormatDataManager {
    private final Map<CapellaDiagramFormatKey, AbstractFormatData> keyToFormatData = new HashMap<CapellaDiagramFormatKey, AbstractFormatData>();
    private Map<? extends DSemanticDecorator, ? extends DSemanticDecorator> pastedToCopiedElement;

    public AbstractFormatData getFormatData(FormatDataKey key) {
        if (key instanceof CapellaDiagramFormatKey) {
            return this.keyToFormatData.get(key);
        }
        return null;
    }

    public void addFormatData(FormatDataKey key, AbstractFormatData formatData) {
        if (key instanceof CapellaDiagramFormatKey) {
            this.keyToFormatData.put((CapellaDiagramFormatKey)key, formatData);
        }
    }

    public FormatDataKey createKey(DSemanticDecorator semanticDecorator) {
        DSemanticDecorator copiedElement;
        if (this.pastedToCopiedElement != null && (copiedElement = this.pastedToCopiedElement.get(semanticDecorator)) != null) {
            return new CapellaDiagramFormatKey(copiedElement);
        }
        return new CapellaDiagramFormatKey(semanticDecorator);
    }

    public boolean containsData() {
        return !this.keyToFormatData.isEmpty();
    }

    public void clearFormatData() {
        this.keyToFormatData.clear();
        this.pastedToCopiedElement = null;
    }

    public void setPastedToCopiedElement(Map<? extends DSemanticDecorator, ? extends DSemanticDecorator> pastedToCopiedElement) {
        this.pastedToCopiedElement = pastedToCopiedElement;
    }

    public static class CapellaDiagramFormatKey
    implements FormatDataKey {
        private final String keyId;

        public CapellaDiagramFormatKey(DSemanticDecorator originalDSemanticDecorator) {
            this.keyId = EcoreUtil.getURI((EObject)originalDSemanticDecorator).fragment();
        }

        public String getId() {
            return this.keyId;
        }

        public int hashCode() {
            return Objects.hashCode(this.keyId);
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof CapellaDiagramFormatKey) {
                CapellaDiagramFormatKey anotherKey = (CapellaDiagramFormatKey)anObject;
                return Objects.equals(this.keyId, anotherKey.keyId);
            }
            return false;
        }
    }
}

