/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.mapper;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.helpers.interaction.services.MessageEndExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.MapperException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IMapper;

public class BroadcastPatternMapper
implements IMapper {
    public Object getName() {
        return "Broadcast Pattern Mapper";
    }

    public List<AbstractInstance> candidateComponents(AbstractInstance abstractInstance, boolean isIntraLayer, Component decomposedComponent, NamedElement target, Scenario srcScenario, AbstractEnd srcAbstractEnd) throws MapperException {
        ArrayList<AbstractInstance> componentSet = new ArrayList<AbstractInstance>();
        if (abstractInstance instanceof ExchangeItemInstance) {
            componentSet.add(abstractInstance);
        }
        return componentSet;
    }

    public List<AbstractInstance> componentMapping(MessageEndExt.COMPONENT_TYPE componentType, AbstractEventOperation invokedOperation, List<AbstractInstance> candidateAbstractInstances, AbstractEnd abstractEnd) throws MapperException {
        ArrayList<AbstractInstance> abstractInstanceSet = new ArrayList<AbstractInstance>();
        if (invokedOperation instanceof ExchangeItemAllocation) {
            for (AbstractInstance abstractInstance : candidateAbstractInstances) {
                AbstractType type = abstractInstance.getAbstractType();
                if (type instanceof Component) {
                    Component cpnt = (Component)type;
                    if (componentType == MessageEndExt.COMPONENT_TYPE.SENDER) {
                        if (!this.hasCallCommunicationLink(cpnt, (ExchangeItemAllocation)invokedOperation) && !this.hasSendCommunicationLink(cpnt, (ExchangeItemAllocation)invokedOperation) && !this.hasWriteCommunicationLink(cpnt, (ExchangeItemAllocation)invokedOperation) && !this.hasProduceCommunicationLink(cpnt, (ExchangeItemAllocation)invokedOperation)) continue;
                        abstractInstanceSet.add(abstractInstance);
                        continue;
                    }
                    if (componentType != MessageEndExt.COMPONENT_TYPE.RECEIVER || !this.hasAccessCommunicationLink(cpnt, (ExchangeItemAllocation)invokedOperation) && !this.hasExecuteCommunicationLink(cpnt, (ExchangeItemAllocation)invokedOperation) && !this.hasReceiveCommunicationLink(cpnt, (ExchangeItemAllocation)invokedOperation) && !this.hasConsumeCommunicationLink(cpnt, (ExchangeItemAllocation)invokedOperation)) continue;
                    abstractInstanceSet.add(abstractInstance);
                    continue;
                }
                if (!(type instanceof ExchangeItem)) continue;
                abstractInstanceSet.add(abstractInstance);
            }
        }
        return abstractInstanceSet;
    }

    private boolean hasWriteCommunicationLink(Component cpnt, ExchangeItemAllocation allocation) {
        return this.hasCommunicationLink(cpnt, allocation, CommunicationLinkKind.WRITE);
    }

    private boolean hasAccessCommunicationLink(Component cpnt, ExchangeItemAllocation allocation) {
        return this.hasCommunicationLink(cpnt, allocation, CommunicationLinkKind.ACCESS);
    }

    private boolean hasSendCommunicationLink(Component cpnt, ExchangeItemAllocation allocation) {
        return this.hasCommunicationLink(cpnt, allocation, CommunicationLinkKind.SEND);
    }

    private boolean hasReceiveCommunicationLink(Component cpnt, ExchangeItemAllocation allocation) {
        return this.hasCommunicationLink(cpnt, allocation, CommunicationLinkKind.RECEIVE);
    }

    private boolean hasProduceCommunicationLink(Component cpnt, ExchangeItemAllocation allocation) {
        return this.hasCommunicationLink(cpnt, allocation, CommunicationLinkKind.PRODUCE);
    }

    private boolean hasConsumeCommunicationLink(Component cpnt, ExchangeItemAllocation allocation) {
        return this.hasCommunicationLink(cpnt, allocation, CommunicationLinkKind.CONSUME);
    }

    private boolean hasCallCommunicationLink(Component cpnt, ExchangeItemAllocation allocation) {
        return this.hasCommunicationLink(cpnt, allocation, CommunicationLinkKind.CALL);
    }

    private boolean hasExecuteCommunicationLink(Component cpnt, ExchangeItemAllocation allocation) {
        return this.hasCommunicationLink(cpnt, allocation, CommunicationLinkKind.EXECUTE);
    }

    private boolean hasCommunicationLink(Component cpnt, ExchangeItemAllocation allocation, CommunicationLinkKind kind) {
        for (CommunicationLink communicationlink : cpnt.getOwnedCommunicationLinks()) {
            if (communicationlink.getExchangeItem() != allocation.getAllocatedItem() || !communicationlink.getKind().equals((Object)kind)) continue;
            return true;
        }
        return false;
    }
}

