/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.xpand.EPackageRegistryBasedURIResourceMap;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.build.MetaModelSource;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator anInstance;
    private final Map<IProject, RootManager> rootManagers = new HashMap<IProject, RootManager>();
    private final IResourceChangeListener myRootsTracker = new IResourceChangeListener(){

        public synchronized void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta projectDelta;
            if (event == null || event.getDelta() == null) {
                return;
            }
            HashSet<RootManager> affectedRootManagers = new HashSet<RootManager>();
            IResourceDelta rootDelta = event.getDelta();
            IResourceDelta[] iResourceDeltaArray = rootDelta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                projectDelta = iResourceDeltaArray[n2];
                IProject affectedProject = (IProject)projectDelta.getResource();
                if (this.isRemovedOrClosed(projectDelta)) {
                    Activator.this.rootManagers.remove(affectedProject);
                } else {
                    IResourceDelta configFileDelta = projectDelta.findMember(RootManager.PROJECT_RELATIVE_PATH_TO_CONFIG_FILE);
                    if (configFileDelta != null && Activator.this.rootManagers.containsKey(affectedProject) && this.affectsConfigFile(configFileDelta)) {
                        affectedRootManagers.add(Activator.getRootManager(affectedProject));
                    }
                }
                ++n2;
            }
            iResourceDeltaArray = rootDelta.getAffectedChildren();
            n = iResourceDeltaArray.length;
            n2 = 0;
            while (n2 < n) {
                projectDelta = iResourceDeltaArray[n2];
                if (this.mayAffectOtherResourceManagers(projectDelta)) {
                    IPath projectPath = projectDelta.getFullPath();
                    for (RootManager nextManager : Activator.this.rootManagers.values()) {
                        if (!nextManager.containsProject(projectPath)) continue;
                        affectedRootManagers.add(nextManager);
                    }
                }
                ++n2;
            }
            for (RootManager nextManager : affectedRootManagers) {
                nextManager.rootsChanged();
            }
        }

        private boolean affectsConfigFile(IResourceDelta configFileDelta) {
            if ((configFileDelta.getKind() & 3) > 0) {
                return true;
            }
            return (configFileDelta.getFlags() & 0x158100) > 0;
        }

        private boolean isRemovedOrClosed(IResourceDelta projectDelta) {
            if (projectDelta.getKind() == 2) {
                return true;
            }
            if ((projectDelta.getFlags() & 0x4000) > 0) {
                return !projectDelta.getResource().isAccessible();
            }
            return false;
        }

        private boolean mayAffectOtherResourceManagers(IResourceDelta projectDelta) {
            if ((projectDelta.getKind() & 3) > 0) {
                return true;
            }
            if ((projectDelta.getFlags() & 0x4000) > 0) {
                return !projectDelta.getResource().isAccessible();
            }
            return false;
        }
    };
    private final Set<MetaModelSource> modelSources = new LinkedHashSet<MetaModelSource>();
    private ResourceSet workspaceMetamodelRS;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        anInstance = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.myRootsTracker);
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.myRootsTracker);
        anInstance = null;
        super.stop(context);
    }

    public static String getId() {
        return anInstance == null ? String.valueOf((Object)anInstance) : anInstance.getBundle().getSymbolicName();
    }

    public static void logWarn(String message) {
        Activator.log((IStatus)new Status(2, Activator.getId(), 0, message, null));
    }

    public static void logError(Exception e) {
        if (e instanceof CoreException) {
            Activator.log(((CoreException)e).getStatus());
        } else {
            Activator.log((IStatus)new Status(4, Activator.getId(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        if (anInstance != null) {
            anInstance.getLog().log(status);
        } else {
            System.err.println(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RootManager getRootManager(IProject project) {
        IResourceChangeListener iResourceChangeListener = Activator.anInstance.myRootsTracker;
        synchronized (iResourceChangeListener) {
            RootManager result = Activator.anInstance.rootManagers.get(project);
            if (result == null) {
                result = new RootManager(project);
                Activator.anInstance.rootManagers.put(project, result);
            }
            return result;
        }
    }

    public static WorkspaceResourceManager createWorkspaceResourceManager(IProject project, RootManager.RootDescription rootDescription) {
        return rootDescription != null ? new WorkspaceResourceManager(project, rootDescription.getRoots().toArray(new IPath[rootDescription.getRoots().size()])) : new WorkspaceResourceManager(project);
    }

    public static void registerModelSource(MetaModelSource modelSource) {
        assert (modelSource != null);
        Activator.anInstance.modelSources.add(modelSource);
    }

    public static EPackage findMetaModel(String nsURI) {
        if (anInstance == null) {
            return null;
        }
        for (MetaModelSource s : Activator.anInstance.modelSources) {
            EPackage p = s.find(nsURI);
            if (p == null) continue;
            return p;
        }
        return EPackage.Registry.INSTANCE.getEPackage(nsURI);
    }

    public static EPackage.Registry fillWorkspaceMetaModelsMap(EPackage.Registry registry) {
        if (anInstance == null) {
            return registry;
        }
        for (MetaModelSource s : Activator.anInstance.modelSources) {
            EPackage[] ePackageArray = s.all();
            int n = ePackageArray.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage p = ePackageArray[n2];
                if (p.eResource() != null && p.eResource().getURI() != null && p.eResource().getURI().isPlatformResource()) {
                    registry.put((Object)p.getNsURI(), (Object)p);
                    registry.put((Object)p.eResource().getURI().toString(), (Object)p);
                }
                ++n2;
            }
        }
        return registry;
    }

    public static ResourceSet getWorkspaceMetamodelsResourceSet() {
        if (anInstance != null && Activator.anInstance.workspaceMetamodelRS != null) {
            return Activator.anInstance.workspaceMetamodelRS;
        }
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        resourceSetImpl.setURIResourceMap((Map)new EPackageRegistryBasedURIResourceMap(resourceSetImpl.getURIConverter()));
        resourceSetImpl.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        if (anInstance != null) {
            Activator.anInstance.workspaceMetamodelRS = resourceSetImpl;
        }
        return resourceSetImpl;
    }
}

