/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.helpers.ctx.services.CapabilityPkgExt;
import org.polarsys.capella.core.data.helpers.ctx.services.MissionPkgExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActor;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;
import org.polarsys.capella.core.sirius.analysis.OAServices;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;

public class ContextServices {
    private static ContextServices singleton = null;

    public static ContextServices getServices() {
        if (singleton == null) {
            singleton = new ContextServices();
        }
        return singleton;
    }

    public List<EObject> getCCCapabilities(DSemanticDecorator current) {
        return this.getMBCapabilities(current);
    }

    public List<EObject> getCMCapabilities(DSemanticDecorator current) {
        return this.getMBCapabilities(current);
    }

    public List<EObject> getCRBCapabilities(DSemanticDecorator diagram) {
        return this.getMBCapabilities(diagram);
    }

    public List<EObject> getMBCapabilities(DSemanticDecorator current) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = current.getTarget();
        AbstractCapabilityPkg abstractCapabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)target));
        result.addAll(CapabilityPkgExt.getAllAbstractCapabilities((AbstractCapabilityPkg)abstractCapabilityPkg));
        return result;
    }

    public List<EObject> getOCBCapabilities(DSemanticDecorator diagram) {
        return this.getMBCapabilities(diagram);
    }

    public List<EObject> getMCBCapabilities(DSemanticDecorator current) {
        return this.getMBCapabilities(current);
    }

    @Deprecated
    public List<EObject> getAvailableActorsToInsertInMCB2(DSemanticDecorator current) {
        return this.getMCBActors(current);
    }

    @Deprecated
    public List<Actor> getAvailableActorsToInsertInMCB(DSemanticDecorator current) {
        return this.getMCBActors(current);
    }

    @Deprecated
    public EObject showHideMCBActors2(DSemanticDecorator view, List<EObject> selectedElements, List<EObject> visibleElements, List<DDiagramElement> visibleElementViews, AbstractShowHide showHideHandler) {
        AbstractShowHide.DiagramContext diagramContext = new AbstractShowHide.DiagramContext(showHideHandler);
        for (EObject actor : selectedElements) {
            showHideHandler.show(actor, diagramContext);
        }
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        for (DDiagramElement node : visibleElementViews) {
            if (selectedElements.contains(node.getTarget())) continue;
            toBeRemoved.add(node.getTarget());
        }
        for (EObject aView : toBeRemoved) {
            showHideHandler.hide(aView, diagramContext);
        }
        return view;
    }

    @Deprecated
    public Actor createCtxActor(EObject container) {
        Actor actor = CtxFactory.eINSTANCE.createActor();
        if (actor != null) {
            if (container instanceof ActorPkg) {
                ActorPkg actorPkg = (ActorPkg)container;
                actorPkg.getOwnedActors().add((Object)actor);
            }
            CapellaServices.getService().creationService((EObject)actor);
        }
        return actor;
    }

    public List<EObject> getCCMissions(DSemanticDecorator current) {
        return this.getMCBMissions(current);
    }

    public List<EObject> getMCBMissions(DSemanticDecorator current) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = current.getTarget();
        SystemEngineering sysEng = SystemEngineeringExt.getSystemEngineering((CapellaElement)((CapellaElement)target));
        SystemAnalysis sysAnalysis = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)sysEng);
        result.addAll(MissionPkgExt.getAllMissions((MissionPkg)sysAnalysis.getOwnedMissionPkg()));
        return result;
    }

    public List<EObject> getMBMissions(DSemanticDecorator diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = diagram.getTarget();
        if (diagram instanceof DDiagram && target instanceof MissionPkg) {
            result.addAll(MissionPkgExt.getAllMissions((MissionPkg)((MissionPkg)target)));
        }
        return result;
    }

    public List<EObject> getCMActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getCCActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getMCBActors(DSemanticDecorator current) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = current.getTarget();
        Structure structure = BlockArchitectureExt.getActorPkg((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)target));
        result.addAll(ActorPkgExt.getAllActors((Structure)structure));
        return result;
    }

    public List<EObject> getCRBActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getMBActors(DSemanticDecorator diagram) {
        return this.getMCBActors(diagram);
    }

    public List<EObject> getCOCActors(DSemanticDecorator view) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Collection<? extends Component> availableEntitiesToInsert = OAServices.getService().getOEBEntities(view);
        for (Component component : availableEntitiesToInsert) {
            if (!(component instanceof OperationalActor)) continue;
            result.add((EObject)component);
        }
        return result;
    }

    public List<EObject> getCOCEntities(DSemanticDecorator view) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Collection<? extends Component> allComponents = OAServices.getService().getAvailableEntitiesToInsert(view);
        for (Component component : allComponents) {
            if (!(component instanceof Entity) || component instanceof OperationalActor) continue;
            result.add((EObject)component);
        }
        return result;
    }

    public List<EObject> getCOCCapabilities(DSemanticDecorator diagram) {
        return this.getOCBCapabilities(diagram);
    }

    public List<EObject> getOCBActors(DSemanticDecorator view) {
        return this.getCOCActors(view);
    }

    public List<EObject> getOCBEntities(DSemanticDecorator view) {
        return this.getCOCEntities(view);
    }

    public List<EObject> getCRBComponents(DSemanticDecorator decorator) {
        Component firstComponent;
        ArrayList<EObject> components = new ArrayList<EObject>();
        if (decorator.getTarget() instanceof Component) {
            components.addAll(CsServices.getService().getCCIIShowHideComponent(decorator));
            return components;
        }
        EObject parentContainer = CsServices.getService().getParentContainer(decorator.getTarget());
        if (parentContainer == null) {
            return components;
        }
        if (parentContainer instanceof Component) {
            components.addAll(CsServices.getService().getSubComponents(parentContainer));
            return components;
        }
        if (parentContainer instanceof BlockArchitecture && (firstComponent = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)((ModellingArchitecture)parentContainer))) != null) {
            components.addAll(CsServices.getService().getSubComponents((EObject)firstComponent));
            return components;
        }
        return components;
    }

    public Collection<EObject> getMBCapabilityInvolvementSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractCapability)) continue;
            result.addAll((Collection<EObject>)((AbstractCapability)target).getInvolvedInvolvements());
        }
        return result;
    }

    public Collection<EObject> getMBMissionInvolvementSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Mission)) continue;
            result.addAll((Collection<EObject>)((Mission)target).getInvolvedActors());
        }
        return result;
    }

    public Collection<EObject> getMBCapabilityIncludeSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractCapability)) continue;
            result.addAll((Collection<EObject>)((AbstractCapability)target).getIncludes());
        }
        return result;
    }

    public Collection<EObject> getMBCapabilityExtendSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractCapability)) continue;
            result.addAll((Collection<EObject>)((AbstractCapability)target).getExtends());
        }
        return result;
    }

    public Collection<EObject> getMBActorGeneralizationSemanticCandidates(DDiagram diagram) {
        return InformationServices.getService().getCDBGeneralizationSemanticCandidates(diagram);
    }

    public Collection<EObject> getMBCapabilityGeneralizationSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof AbstractCapability)) continue;
            result.addAll((Collection<EObject>)((AbstractCapability)target).getSuperGeneralizations());
        }
        return result;
    }

    public Collection<EObject> getMBCapabilityExploitationSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Mission)) continue;
            result.addAll((Collection<EObject>)((Mission)target).getOwnedCapabilityExploitations());
        }
        return result;
    }
}

