/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.style.BorderedStyleDescription;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.graphics.RGB;
import org.polarsys.capella.common.helpers.SimpleOrientedGraph;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalChainContainer;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.FunctionalChainAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.ShapeUtil;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class FunctionalChainServices {
    private static final Integer THICK_BORDER_SOURCE_FUNCTION = 4;
    private static final Integer THICK_BORDER_TARGET_FUNCTION = 4;
    private static final Integer THICK_EDGE_FUNCTIONAL_CHAIN = 4;
    private static final String INCOMPLETE_FUNCTIONAL_CHAIN_LABEL = "incomplete";
    private static final String INVALID_FUNCTIONAL_CHAIN_LABEL = "invalid";
    private static FunctionalChainServices singleton = null;

    public static FunctionalChainServices getFunctionalChainServices() {
        if (singleton == null) {
            singleton = new FunctionalChainServices();
        }
        return singleton;
    }

    public Collection<EObject> getFunctionalChainSources(FunctionalChain chain) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (FunctionalExchange exchange : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)chain)) {
            result.add((EObject)exchange.getTarget());
        }
        return result;
    }

    public Collection<EObject> getFunctionalChainTargets(FunctionalChain chain) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (FunctionalExchange exchange : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)chain)) {
            result.add((EObject)exchange.getSource());
        }
        return result;
    }

    public AbstractFunction getBestFunction(AbstractFunction element, Collection<? extends EObject> elements) {
        AbstractFunction current = element;
        while (current != null) {
            if (current instanceof AbstractFunction && elements.contains(current)) {
                return current;
            }
            current = current.eContainer();
        }
        return null;
    }

    public List<FunctionalChain> getFunctionalChainsToInsert(EObject context, DDiagram currentDiagram, List<FunctionalChain> allFunctionalChains) {
        ArrayList<FunctionalChain> returnedList = new ArrayList<FunctionalChain>();
        for (DDiagramElement anObject : DiagramServices.getDiagramServices().getDiagramElements((EObject)currentDiagram)) {
            if (!(anObject.getTarget() instanceof AbstractFunction)) continue;
            AbstractFunction aFunction = (AbstractFunction)anObject.getTarget();
            for (FunctionalChain aFunctionalChain : allFunctionalChains) {
                Set involvedFunctions = FunctionalChainExt.getFlatInvolvedElements((FunctionalChain)aFunctionalChain, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
                if (returnedList.contains(aFunctionalChain)) continue;
                if (involvedFunctions.contains(aFunction)) {
                    returnedList.add(aFunctionalChain);
                    continue;
                }
                for (AbstractFunction aSubFunction : FunctionExt.getAllAbstractFunctions((AbstractFunction)aFunction)) {
                    if (!involvedFunctions.contains(aSubFunction)) continue;
                    returnedList.add(aFunctionalChain);
                }
            }
        }
        return returnedList;
    }

    public void updateFunctionalChainStyles(DDiagram diagram) {
        Set<DDiagramElement> set;
        EObject target;
        HashMap<FunctionalChain, DNode> displayedFC = new HashMap<FunctionalChain, DNode>();
        HashMap<FunctionalExchange, Set<DEdge>> displayedFE = new HashMap<FunctionalExchange, Set<DEdge>>();
        HashMap<FunctionalChain, Set<DEdge>> displayedIL = new HashMap<FunctionalChain, Set<DEdge>>();
        HashMap<AbstractFunction, Set<DDiagramElement>> displayedFunctions = new HashMap<AbstractFunction, Set<DDiagramElement>>();
        HashMap coloredFunctionNodes = new HashMap();
        HashSet<FunctionalChain> incompleteFC = new HashSet<FunctionalChain>();
        HashMap coloredFE = new HashMap();
        HashSet updatedInternalLinks = new HashSet();
        for (DDiagramElement aNode : diagram.getOwnedDiagramElements()) {
            if (!(aNode instanceof DNode) || aNode.getTarget() == null || !(aNode.getTarget() instanceof FunctionalChain)) continue;
            displayedFC.put((FunctionalChain)aNode.getTarget(), (DNode)aNode);
        }
        for (DDiagramElement aNode : diagram.getNodes()) {
            target = aNode.getTarget();
            if (!(target instanceof AbstractFunction)) continue;
            set = (HashSet<DDiagramElement>)displayedFunctions.get(target);
            if (set == null) {
                set = new HashSet<DDiagramElement>();
                displayedFunctions.put((AbstractFunction)target, set);
            }
            set.add(aNode);
        }
        for (DDiagramElement aContainer : diagram.getContainers()) {
            target = aContainer.getTarget();
            if (!(target instanceof AbstractFunction)) continue;
            set = (Set)displayedFunctions.get(target);
            if (set == null) {
                set = new HashSet();
                displayedFunctions.put((AbstractFunction)target, set);
            }
            set.add(aContainer);
        }
        for (DEdge anEdge : diagram.getEdges()) {
            EObject edgeTarget = anEdge.getTarget();
            if (edgeTarget instanceof FunctionalExchange) {
                FunctionalExchange fe = (FunctionalExchange)edgeTarget;
                HashSet<DEdge> edges = (HashSet<DEdge>)displayedFE.get(fe);
                if (edges == null) {
                    edges = new HashSet<DEdge>();
                    displayedFE.put(fe, edges);
                }
                edges.add(anEdge);
            }
            if (!(edgeTarget instanceof FunctionalChain)) continue;
            if (!displayedIL.containsKey(edgeTarget)) {
                Iterator<DEdge> newSet = new HashSet();
                newSet.add(anEdge);
                displayedIL.put((FunctionalChain)edgeTarget, (Set<DEdge>)((Object)newSet));
                continue;
            }
            ((Set)displayedIL.get(edgeTarget)).add(anEdge);
        }
        for (Map.Entry me : displayedFC.entrySet()) {
            Object newSet;
            for (AbstractFunction aSourceFunction : FunctionalChainExt.getFlatFunctionalChainFirstFunctions((FunctionalChain)((FunctionalChain)me.getKey()))) {
                Set<DDiagramElement> sourceFunctionNodes = this.getBestDisplayedFunctionNode(aSourceFunction, displayedFunctions);
                if (sourceFunctionNodes == null) continue;
                for (DDiagramElement sourceFunctionNode : sourceFunctionNodes) {
                    if (!coloredFunctionNodes.containsKey(sourceFunctionNode)) {
                        newSet = new HashSet<FunctionalChain>();
                        newSet.add((FunctionalChain)me.getKey());
                        coloredFunctionNodes.put(sourceFunctionNode, newSet);
                        continue;
                    }
                    ((Set)coloredFunctionNodes.get(sourceFunctionNode)).add((FunctionalChain)me.getKey());
                }
            }
            for (AbstractFunction aTargetFunction : FunctionalChainExt.getFlatFunctionalChainLastFunctions((FunctionalChain)((FunctionalChain)me.getKey()))) {
                Set<DDiagramElement> targetFunctionNodes = this.getBestDisplayedFunctionNode(aTargetFunction, displayedFunctions);
                if (targetFunctionNodes == null) continue;
                for (DDiagramElement targetFunctionNode : targetFunctionNodes) {
                    if (!coloredFunctionNodes.containsKey(targetFunctionNode)) {
                        newSet = new HashSet();
                        newSet.add((FunctionalChain)me.getKey());
                        coloredFunctionNodes.put(targetFunctionNode, newSet);
                        continue;
                    }
                    ((Set)coloredFunctionNodes.get(targetFunctionNode)).add((FunctionalChain)me.getKey());
                }
            }
            for (FunctionalExchange anExchange : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)((FunctionalChain)me.getKey()))) {
                if (!displayedFE.containsKey(anExchange)) continue;
                Iterator exchangeEdges = (Set)displayedFE.get(anExchange);
                Iterator<Object> iterator = exchangeEdges.iterator();
                while (iterator.hasNext()) {
                    DEdge exchangeEdge = (DEdge)iterator.next();
                    if (!coloredFE.containsKey(exchangeEdge)) {
                        newSet = new HashSet<FunctionalChain>();
                        newSet.add((FunctionalChain)me.getKey());
                        coloredFE.put(exchangeEdge, newSet);
                        continue;
                    }
                    ((Set)coloredFE.get(exchangeEdge)).add((FunctionalChain)me.getKey());
                }
            }
        }
        for (Map.Entry me : displayedIL.entrySet()) {
            if (displayedFC.containsKey(me.getKey())) continue;
            for (DEdge anEdge : (Set)me.getValue()) {
                DiagramServices.getDiagramServices().removeEdgeView(anEdge);
            }
        }
        for (Map.Entry me : displayedFunctions.entrySet()) {
            Set functionNodes = (Set)me.getValue();
            for (DDiagramElement functionNode : functionNodes) {
                if (coloredFunctionNodes.containsKey(functionNode)) continue;
                this.resetFunctionStyle(functionNode);
            }
        }
        for (Map.Entry me : displayedFC.entrySet()) {
            this.updateFunctionalChainNodeColor((DNode)me.getValue(), displayedFC.values());
            RGBValues color = ShapeUtil.getNodeColorStyle((DNode)me.getValue());
            if (color == null) continue;
            for (AbstractFunction aSourceFunction : FunctionalChainExt.getFlatFunctionalChainFirstFunctions((FunctionalChain)((FunctionalChain)me.getKey()))) {
                Set<DDiagramElement> sourceFunctionNodes = this.getBestDisplayedFunctionNode(aSourceFunction, displayedFunctions);
                if (sourceFunctionNodes == null) continue;
                for (DDiagramElement sourceFunctionNode : sourceFunctionNodes) {
                    if (((Set)coloredFunctionNodes.get(sourceFunctionNode)).size() == 1) {
                        this.customizeSourceFunctionStyle(sourceFunctionNode, color);
                        continue;
                    }
                    this.customizeSourceFunctionStyle(sourceFunctionNode, ShapeUtil.getBlackColor());
                }
            }
            for (AbstractFunction aTargetFunction : FunctionalChainExt.getFlatFunctionalChainLastFunctions((FunctionalChain)((FunctionalChain)me.getKey()))) {
                Set<DDiagramElement> targetFunctionNodes = this.getBestDisplayedFunctionNode(aTargetFunction, displayedFunctions);
                if (targetFunctionNodes == null) continue;
                for (DDiagramElement targetFunctionNode : targetFunctionNodes) {
                    if (((Set)coloredFunctionNodes.get(targetFunctionNode)).size() == 1) {
                        this.customizeTargetFunctionStyle(targetFunctionNode, color);
                        continue;
                    }
                    this.customizeTargetFunctionStyle(targetFunctionNode, ShapeUtil.getBlackColor());
                }
            }
            boolean isInOperationalAnalysis = BlockArchitectureExt.getRootBlockArchitecture((EObject)((DSemanticDiagram)diagram).getTarget()) instanceof OperationalAnalysis;
            Set<Object> internalLinks = new HashSet();
            if (!isInOperationalAnalysis) {
                internalLinks = this.updateInternalLinks((FunctionalChain)me.getKey(), displayedFE, displayedIL, color);
                updatedInternalLinks.addAll(internalLinks);
            }
            for (FunctionalExchange anExchange : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)((FunctionalChain)me.getKey()))) {
                if (displayedFE.containsKey(anExchange)) {
                    Set<DEdge> currentEdges = displayedFE.get(anExchange);
                    for (DEdge currentEdge : currentEdges) {
                        if (((Set)coloredFE.get(currentEdge)).size() == 1) {
                            this.customizeFunctionalExchangeEdgeStyle(currentEdge, color);
                            continue;
                        }
                        this.customizeFunctionalExchangeEdgeStyle(currentEdge, ShapeUtil.getBlackColor());
                    }
                    continue;
                }
                incompleteFC.add((FunctionalChain)me.getKey());
            }
            ((DNode)me.getValue()).refresh();
        }
        for (Set anInternalLinkSet : displayedIL.values()) {
            for (DEdge anInternalLink : anInternalLinkSet) {
                if (updatedInternalLinks.contains(anInternalLink)) continue;
                DiagramServices.getDiagramServices().removeEdgeView(anInternalLink);
            }
        }
        for (Set aFEs : displayedFE.values()) {
            for (DEdge aFE : aFEs) {
                if (coloredFE.containsKey(aFE)) continue;
                this.resetFunctionalExchangeStyle(aFE);
            }
        }
    }

    private boolean isValidNodeForInternalLink(EdgeTarget currentNode) {
        if (!(currentNode instanceof DNode)) {
            return false;
        }
        return DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)((DNode)currentNode));
    }

    protected Set<DEdge> updateInternalLinks(FunctionalChain fc, Map<FunctionalExchange, Set<DEdge>> displayedFunctionalExchanges, Map<FunctionalChain, Set<DEdge>> displayedIL, RGBValues color) {
        HashSet<DEdge> internalLinks = new HashSet<DEdge>();
        for (FunctionalChainInvolvement anInvolvement : FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)fc, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
            FunctionalExchange currentExchange = (FunctionalExchange)anInvolvement.getInvolved();
            if (!displayedFunctionalExchanges.containsKey(currentExchange)) continue;
            Set<DEdge> currentEdges = displayedFunctionalExchanges.get(currentExchange);
            for (DEdge currentEdge : currentEdges) {
                Set<DEdge> edges;
                if (currentEdge == null) continue;
                EdgeTarget currentSourceNode = currentEdge.getSourceNode();
                EdgeTarget currentTargetNode = currentEdge.getTargetNode();
                if (!this.isValidNodeForInternalLink(currentSourceNode)) continue;
                Collection<FunctionalExchange> previousExchanges = this.getFlatPreviousFunctionalExchanges(fc, anInvolvement);
                Collection<FunctionalExchange> nextExchanges = this.getFlatNextFunctionalExchanges(fc, anInvolvement);
                for (FunctionalExchange elt : previousExchanges) {
                    if (!displayedFunctionalExchanges.containsKey(elt)) continue;
                    edges = displayedFunctionalExchanges.get(elt);
                    for (DEdge edge : edges) {
                        if (edge == null || !this.isValidNodeForInternalLink(edge.getTargetNode()) || !this.isValidInternalLinkEdge(fc, edge.getTargetNode(), currentSourceNode)) continue;
                        internalLinks.add(this.retrieveInternalLink(edge.getTargetNode(), currentSourceNode, fc, color));
                    }
                }
                for (FunctionalExchange elt : nextExchanges) {
                    if (!displayedFunctionalExchanges.containsKey(elt)) continue;
                    edges = displayedFunctionalExchanges.get(elt);
                    for (DEdge edge : edges) {
                        if (edge == null || !this.isValidNodeForInternalLink(edge.getSourceNode()) || !this.isValidInternalLinkEdge(fc, currentTargetNode, edge.getSourceNode())) continue;
                        internalLinks.add(this.retrieveInternalLink(currentTargetNode, edge.getSourceNode(), fc, color));
                    }
                }
            }
        }
        if (internalLinks.contains(null)) {
            internalLinks.remove(null);
        }
        return internalLinks;
    }

    public boolean isValidInternalLinkEdge(FunctionalChain chain, EdgeTarget currentSourceNode, EdgeTarget currentTargetNode) {
        if (currentSourceNode == null) {
            return false;
        }
        if (currentTargetNode == null) {
            return false;
        }
        EObject sourceParent = currentSourceNode.eContainer();
        EObject targetParent = currentTargetNode.eContainer();
        if (sourceParent != null && targetParent != null) {
            return sourceParent.equals(targetParent);
        }
        return false;
    }

    protected DEdge retrieveInternalLink(EdgeTarget sourceNode, EdgeTarget targetNode, FunctionalChain fc, RGBValues color) {
        HashMap<EdgeTarget, DEdge> outgoingEdges = new HashMap<EdgeTarget, DEdge>();
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges(sourceNode)) {
            if (anEdge.getTarget() == null || !(anEdge.getTarget() instanceof FunctionalChain) || !anEdge.getTarget().equals(fc)) continue;
            outgoingEdges.put(anEdge.getTargetNode(), anEdge);
        }
        DEdge internalLink = (DEdge)outgoingEdges.get(targetNode);
        if (internalLink == null) {
            internalLink = this.createInternalLink(sourceNode, targetNode, fc, color);
        }
        if (internalLink != null) {
            this.customizeInternalLinksEdgeStyle(internalLink, color);
        }
        return internalLink;
    }

    protected Collection<FunctionalExchange> getFlatPreviousFunctionalExchanges(FunctionalChain fc, FunctionalChainInvolvement fci) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvment : FunctionalChainExt.getFlatPreviousExchangeInvolvements((FunctionalChainInvolvement)fci)) {
            if (involvment.getInvolved() == null || !(involvment.getInvolved() instanceof FunctionalExchange)) continue;
            result.add((FunctionalExchange)involvment.getInvolved());
        }
        return result;
    }

    protected Collection<FunctionalExchange> getFlatNextFunctionalExchanges(FunctionalChain fc, FunctionalChainInvolvement fci) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvment : FunctionalChainExt.getFlatNextExchangeInvolvements((FunctionalChainInvolvement)fci)) {
            if (involvment.getInvolved() == null || !(involvment.getInvolved() instanceof FunctionalExchange)) continue;
            result.add((FunctionalExchange)involvment.getInvolved());
        }
        return result;
    }

    public DEdge createInternalLink(EdgeTarget sourceNode, EdgeTarget targetNode, FunctionalChain fc, RGBValues color) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceNode);
        EdgeMapping mapping = this.getInternLinkEdgeMapping(diagram);
        DEdge newEdge = DiagramServices.getDiagramServices().findDEdgeElement(diagram, sourceNode, targetNode, (EObject)fc, mapping);
        if (newEdge == null) {
            DiagramServices.getDiagramServices().createEdge(mapping, sourceNode, targetNode, (EObject)fc);
            newEdge = DiagramServices.getDiagramServices().findDEdgeElement(diagram, sourceNode, targetNode, (EObject)fc, mapping);
        }
        return newEdge;
    }

    public EdgeMapping getInternLinkEdgeMapping(DDiagram diagram) {
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, MappingConstantsHelper.getInternLinkEdgeMapping(diagram));
    }

    public void resetFunctionalExchangeStyle(DEdge aEdge) {
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(aEdge);
        if (mapping != null) {
            EdgeStyleDescription desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)aEdge).getBestStyleDescription(mapping, aEdge.getTarget(), (EObject)aEdge, aEdge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)aEdge));
            String defaultStyleSize = desc.getSizeComputationExpression();
            EdgeStyle edgeStyle = aEdge.getOwnedStyle();
            Integer currentSize = edgeStyle.getSize();
            if (currentSize != null && defaultStyleSize != null && (currentSize.equals(THICK_EDGE_FUNCTIONAL_CHAIN) || currentSize.equals(defaultStyleSize)) && ShapeUtil.resetEdgeThickStyle(aEdge, Integer.valueOf(defaultStyleSize))) {
                ShapeUtil.resetEdgeColorStyle(aEdge, ShapeUtil.getDefaultColor((DSemanticDecorator)aEdge, (EObject)desc, desc.getStrokeColor()));
            }
        }
    }

    public boolean resetFunctionStyle(DDiagramElement functionNode) {
        boolean result = false;
        String defaultStyleSize = null;
        Integer currentSize = null;
        BorderedStyle style = null;
        if (functionNode instanceof AbstractDNode) {
            AbstractDNode node = (AbstractDNode)functionNode;
            BorderedStyleDescription desc = (BorderedStyleDescription)this.getMappingHelper((DSemanticDecorator)functionNode).getBestStyleDescription(functionNode.getDiagramElementMapping(), functionNode.getTarget(), (EObject)functionNode, functionNode.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)functionNode));
            if (desc != null) {
                defaultStyleSize = desc.getBorderSizeComputationExpression();
                style = (BorderedStyle)ShapeUtil.getCurrentStyle((DDiagramElement)node);
                if (style != null) {
                    currentSize = style.getBorderSize();
                }
                if (currentSize != null && defaultStyleSize != null && (currentSize.equals(THICK_BORDER_SOURCE_FUNCTION) || currentSize.equals(THICK_BORDER_TARGET_FUNCTION) || currentSize.equals(defaultStyleSize)) && ShapeUtil.resetBorderStyle(node, Integer.valueOf(desc.getBorderSizeComputationExpression())) && ShapeUtil.resetBorderColorStyle(node, ShapeUtil.getDefaultColor((DSemanticDecorator)node, (EObject)desc, desc.getBorderColor()))) {
                    result = true;
                }
            }
        }
        return result;
    }

    public void customizeFunctionalExchangeEdgeStyle(DEdge edge, RGBValues color) {
        String defaultSize;
        EdgeStyleDescription desc;
        EdgeStyle edgeStyle = edge.getOwnedStyle();
        Integer currentSize = edgeStyle.getSize();
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(edge);
        if (mapping != null && (desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)edge).getBestStyleDescription(mapping, edge.getTarget(), (EObject)edge, edge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)edge))) != null && (defaultSize = desc.getSizeComputationExpression()) != null && currentSize != null && (currentSize.equals(Integer.valueOf(defaultSize)) || currentSize.equals(THICK_EDGE_FUNCTIONAL_CHAIN))) {
            this.customizeEdgeStyle(edge, color);
        }
    }

    public void customizeInternalLinksEdgeStyle(DEdge edge, RGBValues color) {
        this.customizeEdgeStyle(edge, color);
    }

    public void customizeEdgeStyle(DEdge edge, RGBValues color) {
        RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        ShapeUtil.setEdgeColorStyle(edge, rgbColor);
        ShapeUtil.setEdgeThickStyle(edge, THICK_EDGE_FUNCTIONAL_CHAIN);
    }

    public void customizeFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderColorStyle((AbstractDNode)functionNode, rgbColor);
        }
    }

    public void customizeSourceFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        this.customizeFunctionStyle(functionNode, color);
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderStyle((AbstractDNode)functionNode, THICK_BORDER_SOURCE_FUNCTION);
        }
    }

    public void customizeTargetFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        this.customizeFunctionStyle(functionNode, color);
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderStyle((AbstractDNode)functionNode, THICK_BORDER_TARGET_FUNCTION);
        }
    }

    public Set<DDiagramElement> getBestDisplayedFunctionNode(AbstractFunction function, Map<AbstractFunction, Set<DDiagramElement>> displayedFunctions) {
        if (displayedFunctions.containsKey(function)) {
            return displayedFunctions.get(function);
        }
        EObject ancestor = function.eContainer();
        while (ancestor != null && ancestor instanceof AbstractFunction) {
            if (displayedFunctions.containsKey(ancestor)) {
                return displayedFunctions.get(ancestor);
            }
            ancestor = ancestor.eContainer();
        }
        return null;
    }

    public boolean isCompleteFunctionalChain(FunctionalChain fc, DDiagram diagram) {
        HashSet<FunctionalExchange> visibleFE = new HashSet<FunctionalExchange>();
        for (DEdge anEdge : diagram.getEdges()) {
            if (anEdge.getTarget() == null || !(anEdge.getTarget() instanceof FunctionalExchange)) continue;
            visibleFE.add((FunctionalExchange)anEdge.getTarget());
        }
        for (FunctionalExchange anElement : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)fc)) {
            if (visibleFE.contains(anElement)) continue;
            return false;
        }
        return true;
    }

    public String getFunctionalChainLabel(FunctionalChain fc, DDiagram diagram) {
        String label = fc.getName();
        boolean isComplete = this.isCompleteFunctionalChain(fc, diagram);
        boolean isValid = FunctionalChainExt.isFunctionalChainValid((FunctionalChain)fc);
        if (!isComplete || !isValid) {
            label = String.valueOf(label) + " (";
        }
        if (!isComplete) {
            label = String.valueOf(label) + INCOMPLETE_FUNCTIONAL_CHAIN_LABEL;
        }
        if (!isComplete && !isValid) {
            label = String.valueOf(label) + ", ";
        }
        if (!isValid) {
            label = String.valueOf(label) + INVALID_FUNCTIONAL_CHAIN_LABEL;
        }
        if (!isComplete || !isValid) {
            label = String.valueOf(label) + ")";
        }
        return label;
    }

    public void updateFunctionalChainNodeColor(DNode fcNode, Collection<DNode> visibleFunctionalChains) {
        RGBValues color = ShapeUtil.getNodeColorStyle(fcNode);
        LinkedList<RGB> colorList = new LinkedList<RGB>();
        RGB blue = new RGB(24, 114, 248);
        RGB yellow = new RGB(249, 252, 103);
        RGB purple = new RGB(160, 32, 240);
        RGB gray = new RGB(136, 136, 136);
        RGB orange = new RGB(255, 165, 0);
        RGB green = new RGB(34, 139, 34);
        RGB brown = new RGB(165, 42, 42);
        colorList.addLast(blue);
        colorList.addLast(brown);
        colorList.addLast(orange);
        colorList.addLast(green);
        colorList.addLast(purple);
        colorList.addLast(yellow);
        colorList.addLast(gray);
        boolean changeColor = false;
        if (ShapeUtil.isSameColor(color, gray)) {
            changeColor = true;
        }
        for (DNode aFc : visibleFunctionalChains) {
            if (aFc.equals(fcNode)) continue;
            RGBValues nodeColor = ShapeUtil.getNodeColorStyle(aFc);
            if (ShapeUtil.isSameColor(nodeColor, color)) {
                changeColor = true;
            }
            ShapeUtil.removeColorFromList(nodeColor, colorList);
        }
        if (!changeColor) {
            return;
        }
        if (!colorList.isEmpty()) {
            ShapeUtil.setColorStyle(fcNode, (RGB)colorList.get(0));
        }
    }

    public List<FunctionalExchange> getAvailableExchanges(EObject context, AbstractFunction source, AbstractFunction target) {
        ArrayList<FunctionalExchange> returnedFunctionalExchanges = new ArrayList<FunctionalExchange>();
        List incoming = FunctionExt.getIncomingExchange((AbstractFunction)target);
        List outgoing = FunctionExt.getOutGoingExchange((AbstractFunction)source);
        for (FunctionalExchange aFunctionalExchange : incoming) {
            if (!outgoing.contains(aFunctionalExchange)) continue;
            returnedFunctionalExchanges.add(aFunctionalExchange);
        }
        return returnedFunctionalExchanges;
    }

    public List<FunctionalChainInvolvement> getPreviousInvolvements(FunctionalChainInvolvement involvement) {
        return involvement.getPreviousFunctionalChainInvolvements();
    }

    public EObject createFunctionalChain(EObject context, List<EObject> views) {
        if (!views.isEmpty()) {
            ArrayList<EObject> newList = new ArrayList<EObject>();
            AbstractFunction aFunction = null;
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DDiagramElement) || ((DDiagramElement)aSelectedElement).getTarget() == null) continue;
                newList.add(((DDiagramElement)aSelectedElement).getTarget());
                if (aFunction != null || !(((DDiagramElement)aSelectedElement).getTarget() instanceof FunctionalExchange)) continue;
                AbstractFunction aSourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)((DDiagramElement)aSelectedElement).getTarget()));
                aFunction = FunctionExt.getRootFunction((AbstractFunction)aSourceFunction);
            }
            if (aFunction != null) {
                EObject diagramContainer = ((DSemanticDiagram)CapellaServices.getService().getDiagramContainer(views.get(0))).getTarget();
                FunctionalChain newFC = diagramContainer instanceof AbstractFunctionalChainContainer ? FunctionalChainExt.createFunctionalChain((AbstractFunctionalChainContainer)((AbstractFunctionalChainContainer)diagramContainer), newList) : FunctionalChainExt.createFunctionalChain(aFunction, newList);
                return newFC;
            }
        }
        return context;
    }

    public void removeFunctionalChainAbstractCapabilityInvolvement(AbstractCapability capability, EObject target) {
        HashSet<FunctionalChainAbstractCapabilityInvolvement> toRemove = new HashSet<FunctionalChainAbstractCapabilityInvolvement>();
        for (FunctionalChainAbstractCapabilityInvolvement inv : capability.getOwnedFunctionalChainAbstractCapabilityInvolvements()) {
            if (!inv.getInvolved().equals(target)) continue;
            toRemove.add(inv);
        }
        for (FunctionalChainAbstractCapabilityInvolvement involvement : toRemove) {
            involvement.destroy();
        }
    }

    public FunctionalChainAbstractCapabilityInvolvement createFunctionalChainAbstractCapabilityInvolvement(AbstractCapability capability, FunctionalChain target) {
        return FunctionalChainExt.createFunctionalChainAbstractCapabilityInvolvement((AbstractCapability)capability, (FunctionalChain)target);
    }

    public boolean isValidFunctionalChainSelection(EObject context, List<EObject> views) {
        SimpleOrientedGraph graph = new SimpleOrientedGraph();
        if (!views.isEmpty()) {
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DEdge) || ((DEdge)aSelectedElement).getTarget() == null || !(((DEdge)aSelectedElement).getTarget() instanceof FunctionalExchange)) continue;
                FunctionalExchange aSelectedExchange = (FunctionalExchange)((DEdge)aSelectedElement).getTarget();
                AbstractFunction sourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)aSelectedExchange);
                AbstractFunction targetFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)aSelectedExchange);
                graph.addNode((Object)sourceFunction, (Object)targetFunction);
            }
            if (!graph.isEmpty()) {
                return graph.isValid();
            }
            return false;
        }
        return false;
    }

    public List<AbstractFunction> getFCDInvolveFunctionScope(EObject container) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)container);
        return FunctionExt.getAllAbstractFunctions((BlockArchitecture)architecture);
    }

    protected List<FunctionalExchange> getOutgoingEdgeFunctionalExchanges(DNode node) {
        ArrayList<FunctionalExchange> existingInvolvedFE = new ArrayList<FunctionalExchange>();
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)node)) {
            FunctionalChainInvolvement currentInv;
            if (anEdge.getTarget() == null || !(anEdge.getTarget() instanceof FunctionalChainInvolvement) || (currentInv = (FunctionalChainInvolvement)anEdge.getTarget()).getInvolved() == null || !(currentInv.getInvolved() instanceof FunctionalExchange)) continue;
            existingInvolvedFE.add((FunctionalExchange)currentInv.getInvolved());
        }
        return existingInvolvedFE;
    }

    public List<FunctionalExchange> getFCDInvolveFunctionalExchangeAndFunctionScope(DNode node) {
        ArrayList<FunctionalExchange> returnedList = new ArrayList<FunctionalExchange>();
        List<FunctionalExchange> existingInvolvedFE = this.getOutgoingEdgeFunctionalExchanges(node);
        FunctionalChainInvolvement selectedInvolvement = (FunctionalChainInvolvement)node.getTarget();
        for (FunctionalExchange aFE : FunctionalChainExt.getFlatOutgoingExchanges((FunctionalChainInvolvement)selectedInvolvement)) {
            if (existingInvolvedFE.contains(aFE)) continue;
            returnedList.add(aFE);
        }
        return returnedList;
    }

    public HashMapSet<FunctionalExchange, FunctionalChain> getFCDInvolveFunctionalExchangeAndFunctionalChainScope(DNode node) {
        HashMapSet<FunctionalExchange, FunctionalChain> set = new HashMapSet<FunctionalExchange, FunctionalChain>();
        if (node == null || node.getTarget() == null || node.getTarget().eIsProxy()) {
            return set;
        }
        EObject target = node.getTarget();
        if (!(target instanceof FunctionalChainInvolvement)) {
            return set;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)node);
        if (!(diagram instanceof DSemanticDecorator)) {
            return set;
        }
        List<FunctionalExchange> existingInvolvedFE = this.getOutgoingEdgeFunctionalExchanges(node);
        FunctionalChainInvolvement involvement = (FunctionalChainInvolvement)target;
        Collection outgoing = FunctionalChainExt.getFlatOutgoingExchanges((FunctionalChainInvolvement)involvement);
        Collection<FunctionalChain> chains = this.getFCDInvolveFunctionalChainScope((DSemanticDecorator)diagram);
        for (FunctionalChain chain : chains) {
            Collection incoming = FunctionalChainExt.getFlatIncomingExchanges((FunctionalChain)chain);
            incoming.retainAll(outgoing);
            for (FunctionalExchange exchange : incoming) {
                if (existingInvolvedFE.contains(exchange)) continue;
                set.put(exchange, chain);
            }
        }
        return set;
    }

    public HashMapSet<FunctionalExchange, FunctionalChain> getFCDInvolveFunctionalExchangeAndFunctionalChainInitialSelection(AbstractDNode context) {
        return new HashMapSet<FunctionalExchange, FunctionalChain>();
    }

    public void involvedFCDFunctionalExchangeFunctionalChain(AbstractDNode context, HashMapSet<FunctionalExchange, FunctionalChain> scope, HashMapSet<FunctionalExchange, FunctionalChain> initialSelection, HashMapSet<FunctionalExchange, FunctionalChain> selection) {
        if (context == null) {
            return;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        if (diagram == null || !(diagram instanceof DSemanticDecorator)) {
            return;
        }
        FunctionalChain sourceFC = (FunctionalChain)((DSemanticDecorator)diagram).getTarget();
        EObject target = context.getTarget();
        if (target == null || target.eIsProxy() || !(target instanceof FunctionalChainInvolvement)) {
            return;
        }
        FunctionalChainInvolvement iSource = (FunctionalChainInvolvement)context.getTarget();
        for (FunctionalExchange exchange : selection.keySet()) {
            Iterator iterator = selection.get(exchange).iterator();
            while (iterator.hasNext()) {
                FunctionalChain chain = (FunctionalChain)iterator.next();
                FunctionalChainInvolvement iExchange = FaFactory.eINSTANCE.createFunctionalChainInvolvement();
                iExchange.setInvolved((InvolvedElement)exchange);
                iExchange.setInvolver((InvolverElement)sourceFC);
                sourceFC.getOwnedFunctionalChainInvolvements().add((Object)iExchange);
                iSource.getNextFunctionalChainInvolvements().add((Object)iExchange);
                FunctionalChainReference iChain = FaFactory.eINSTANCE.createFunctionalChainReference();
                iChain.setInvolved((InvolvedElement)chain);
                iChain.setInvolver((InvolverElement)sourceFC);
                sourceFC.getOwnedFunctionalChainInvolvements().add((Object)iChain);
                iExchange.getNextFunctionalChainInvolvements().add((Object)iChain);
                AbstractNodeMapping nodeMapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, "FC_FunctionalChain");
                if (nodeMapping == null) {
                    return;
                }
                AbstractDNode node = DiagramServices.getDiagramServices().createAbstractDNode(nodeMapping, (EObject)iChain, (DragAndDropTarget)diagram, diagram);
                if (node == null) {
                    return;
                }
                EdgeMapping edgeMapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, "FC_Exchange");
                if (edgeMapping == null) {
                    return;
                }
                DiagramServices.getDiagramServices().createEdge(edgeMapping, (EdgeTarget)context, (EdgeTarget)node, (EObject)iExchange);
            }
        }
    }

    @Deprecated
    public List<FunctionalExchange> getAvailableFunctionalExchangeToInsertInFCD(DNode node) {
        return this.getFCDInvolveFunctionalExchangeAndFunctionScope(node);
    }

    public boolean isValidFCDInvolveFunctionalExchange(EObject context, FunctionalChainInvolvement source, FunctionalChainInvolvement target) {
        boolean result;
        Collection<FunctionalExchange> commonExchanges = this.getFCDCommonFunctionalExchanges(source, target);
        boolean bl = result = !commonExchanges.isEmpty();
        return result && !this.findInvolvementInNext(target, source, new HashSet<FunctionalChainInvolvement>());
    }

    public boolean isValidFCDInvolveFunctionalChain(DSemanticDecorator context) {
        return true;
    }

    public boolean isValidFCDInvolveFunction(DSemanticDecorator context) {
        return true;
    }

    public boolean isValidFCDInvolveFunctionalExchangeAndFunctionalChain(DSemanticDecorator context) {
        return context != null && !(context instanceof DDiagram);
    }

    public boolean isValidFCDInvolveFunctionalExchangeAndFunction(DSemanticDecorator context) {
        return context != null && !(context instanceof DDiagram);
    }

    @Deprecated
    public boolean isAnEdgeInvolvementAvailableInFCD(EObject context, FunctionalChainInvolvement source, FunctionalChainInvolvement target) {
        return this.isValidFCDInvolveFunctionalExchange(context, source, target);
    }

    private Collection<FunctionalExchange> getFCDCommonFunctionalExchanges(FunctionalChainInvolvement source, FunctionalChainInvolvement target) {
        return FunctionalChainExt.getFlatCommonFunctionalExchanges((FunctionalChainInvolvement)source, (FunctionalChainInvolvement)target);
    }

    public Collection<FunctionalExchange> getFCDInvolveFunctionalExchangeScope(EObject context, EObject source, EObject target) {
        Collection<FunctionalExchange> commonExchanges = this.getFCDCommonFunctionalExchanges((FunctionalChainInvolvement)source, (FunctionalChainInvolvement)target);
        return commonExchanges;
    }

    public Collection<FunctionalChain> getFCDInvolveFunctionalChainScope(DSemanticDecorator diagram) {
        EObject chain = diagram.getTarget();
        if (!(chain instanceof FunctionalChain)) {
            return Collections.emptyList();
        }
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)chain);
        List chains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture);
        LinkedList<FunctionalChain> result = new LinkedList<FunctionalChain>();
        for (FunctionalChain definedChain : chains) {
            boolean toAdd = true;
            if (definedChain.equals(chain)) {
                toAdd = false;
            }
            if (toAdd) {
                for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)definedChain, (EClass)FaPackage.Literals.FUNCTIONAL_CHAIN)) {
                    if (!chain.equals(involvement.getInvolved())) continue;
                    toAdd = false;
                    break;
                }
            }
            if (!toAdd) continue;
            result.add(definedChain);
        }
        return result;
    }

    public boolean findInvolvementInNext(FunctionalChainInvolvement currentInvolvement, FunctionalChainInvolvement involvementToFind, Set<FunctionalChainInvolvement> visitedInvolvements) {
        if (visitedInvolvements.contains(currentInvolvement)) {
            return false;
        }
        if (currentInvolvement.equals(involvementToFind)) {
            return true;
        }
        HashSet<FunctionalChainInvolvement> involvements = new HashSet<FunctionalChainInvolvement>(visitedInvolvements);
        involvements.add(currentInvolvement);
        for (FunctionalChainInvolvement aNext : currentInvolvement.getNextFunctionalChainInvolvements()) {
            if (!this.findInvolvementInNext(aNext, involvementToFind, involvements)) continue;
            return true;
        }
        return false;
    }

    public MappingHelper getMappingHelper(DSemanticDecorator semanticDecorator) {
        return new MappingHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticDecorator.getTarget()));
    }
}

