/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.TransferTreeListDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.AbstractExchangeItemPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.ActorCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.SystemComponentCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemContext;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EPBSContext;
import org.polarsys.capella.core.data.fa.AbstractFunctionalStructure;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.AssociationPkg;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ElementKind;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.MultiplicityElement;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.Unit;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.data.information.communication.Exception;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.util.PropertyNamingHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityExtend;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityGeneralization;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityInclude;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.la.LogicalContext;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalContext;
import org.polarsys.capella.core.data.pa.PhysicalActorPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalContext;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.model.helpers.AbstractExchangeItemPkgExt;
import org.polarsys.capella.core.model.helpers.AssociationExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.DataTypeExt;
import org.polarsys.capella.core.model.helpers.ExchangeItemExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.IBServices;
import org.polarsys.capella.core.sirius.analysis.Messages;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.providers.DependencyLabelProvider;

public class InformationServices {
    private static final String THROWS_WITH_WHITE_SPACE_CHAR = " throws ";
    private static final String RETURN_WITH_WHITE_SPACE_CHAR = " returns ";
    private static InformationServices service = null;
    public String COMMA_WITH_SPACE = ", ";

    public static InformationServices getService() {
        if (service == null) {
            service = new InformationServices();
        }
        return service;
    }

    public List<EObject> getExchangeItemElementTypes(ExchangeItemElement parameter) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(InformationPackage.Literals.EXCHANGE_ITEM_ELEMENT, (EStructuralFeature)CapellacorePackage.Literals.TYPED_ELEMENT__TYPE);
        if (query != null) {
            return query.getAvailableElements((EObject)parameter);
        }
        return Collections.emptyList();
    }

    public List<EObject> getParameterTypes(Parameter parameter) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(InformationPackage.Literals.PARAMETER, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
        if (query != null) {
            return query.getAvailableElements((EObject)parameter);
        }
        return Collections.emptyList();
    }

    public List<EObject> getPropertyTypes(Property property) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(InformationPackage.Literals.PROPERTY, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
        if (query != null) {
            return query.getAvailableElements((EObject)property);
        }
        return Collections.emptyList();
    }

    private String parametersToString(AbstractEventOperation eventOperation) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbReturns = new StringBuffer();
        StringBuffer sbExceptions = new StringBuffer();
        StringBuffer sbExceptionsOfOperation = new StringBuffer();
        boolean first = true;
        boolean displayParenthesisIfEmpty = false;
        List parameters = null;
        ArrayList<MultiplicityElement> parameterReturns = new ArrayList<MultiplicityElement>();
        ArrayList<MultiplicityElement> parameterExceptions = new ArrayList<MultiplicityElement>();
        EAttribute directionFeature = null;
        EReference typeFeature = null;
        EAttribute nameFeature = ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME;
        if (eventOperation instanceof ExchangeItemAllocation) {
            ExchangeItemAllocation itemAllocation = (ExchangeItemAllocation)eventOperation;
            ExchangeItem allocatedItem = itemAllocation.getAllocatedItem();
            if (allocatedItem instanceof ExchangeItem) {
                parameters = allocatedItem.getOwnedElements();
                directionFeature = InformationPackage.Literals.EXCHANGE_ITEM_ELEMENT__DIRECTION;
                typeFeature = CapellacorePackage.Literals.TYPED_ELEMENT__TYPE;
            }
        } else if (eventOperation instanceof Operation) {
            displayParenthesisIfEmpty = true;
            Operation operation = (Operation)eventOperation;
            parameters = operation.getOwnedParameters();
            directionFeature = InformationPackage.Literals.PARAMETER__DIRECTION;
            typeFeature = CapellacorePackage.Literals.TYPED_ELEMENT__TYPE;
        }
        if (parameters != null) {
            if (parameters.size() > 0 || parameters.size() == 0 && displayParenthesisIfEmpty) {
                sb.append('(');
            }
            for (MultiplicityElement currentParameter : parameters) {
                Object directionObj = currentParameter.eGet((EStructuralFeature)directionFeature);
                if (!(directionObj instanceof ParameterDirection)) continue;
                ParameterDirection direction = (ParameterDirection)directionObj;
                if (direction == ParameterDirection.IN || direction == ParameterDirection.OUT || direction == ParameterDirection.INOUT || direction == ParameterDirection.UNSET) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(this.COMMA_WITH_SPACE);
                    }
                    sb.append(this.parameterToString(currentParameter, (AbstractType)currentParameter.eGet((EStructuralFeature)typeFeature), (String)currentParameter.eGet((EStructuralFeature)nameFeature), direction, true, true, true));
                    continue;
                }
                if (direction == ParameterDirection.RETURN) {
                    parameterReturns.add(currentParameter);
                    continue;
                }
                if (direction != ParameterDirection.EXCEPTION) continue;
                parameterExceptions.add(currentParameter);
            }
            if (parameters.size() > 0 || parameters.size() == 0 && displayParenthesisIfEmpty) {
                sb.append(')');
            }
        }
        if (!parameterReturns.isEmpty()) {
            this.parametersToStringReturnAndException(sbReturns, (EStructuralFeature)typeFeature, (EStructuralFeature)nameFeature, parameterReturns, RETURN_WITH_WHITE_SPACE_CHAR);
        }
        if (!parameterExceptions.isEmpty()) {
            this.parametersToStringReturnAndException(sbExceptions, (EStructuralFeature)typeFeature, (EStructuralFeature)nameFeature, parameterExceptions, THROWS_WITH_WHITE_SPACE_CHAR);
        }
        boolean firstServiceExeption = true;
        boolean atLeastOneExcepIsNamed = false;
        if (eventOperation instanceof Service) {
            Service serviceOp = (Service)eventOperation;
            EList thrownExceptions = serviceOp.getThrownExceptions();
            for (Exception exceptionOp : thrownExceptions) {
                String excEleName = (String)exceptionOp.eGet((EStructuralFeature)nameFeature);
                if (!excEleName.equals("")) {
                    atLeastOneExcepIsNamed = true;
                }
                if (!atLeastOneExcepIsNamed || excEleName.equals("")) continue;
                if (parameterExceptions.isEmpty() && firstServiceExeption) {
                    sbExceptionsOfOperation.append(THROWS_WITH_WHITE_SPACE_CHAR);
                    firstServiceExeption = false;
                } else {
                    sbExceptionsOfOperation.append(this.COMMA_WITH_SPACE);
                }
                this.parameterToStringReturnAndException(sbExceptionsOfOperation, null, exceptionOp.eClass().getName(), exceptionOp.getName(), false, true, true, false);
            }
            if (!thrownExceptions.isEmpty() && !atLeastOneExcepIsNamed) {
                if (parameterExceptions.isEmpty() && firstServiceExeption) {
                    sbExceptionsOfOperation.append(THROWS_WITH_WHITE_SPACE_CHAR);
                    firstServiceExeption = false;
                } else {
                    sbExceptionsOfOperation.append(this.COMMA_WITH_SPACE);
                }
                this.parameterToStringReturnAndException(sbExceptionsOfOperation, null, CommunicationPackage.Literals.EXCEPTION.getName(), "", false, true, true, false);
            }
        }
        if (sbReturns.length() > 0) {
            sb.append(' ');
            sb.append(':');
            sb.append(' ');
            sb.append(sbReturns);
        }
        if (sbExceptions.length() > 0) {
            sb.append(sbExceptions);
            sb.append(sbExceptionsOfOperation);
        } else if (sbExceptionsOfOperation.length() > 0) {
            sb.append(sbExceptionsOfOperation);
        }
        return sb.toString();
    }

    private String parameterToString(MultiplicityElement parameter, AbstractType type, String name, ParameterDirection direction, boolean showDirection, boolean showName, boolean showCardinality) {
        StringBuffer sb = new StringBuffer();
        if (showName && parameter != null) {
            if (parameter instanceof ExchangeItemElement) {
                ExchangeItemElement exchangeItemElement = (ExchangeItemElement)parameter;
                if (ElementKind.MEMBER.equals((Object)exchangeItemElement.getKind())) {
                    this.parameterToStringAppendDirection(direction, showDirection, sb);
                }
            } else if (parameter instanceof Parameter) {
                this.parameterToStringAppendDirection(direction, showDirection, sb);
            }
            sb.append(name);
            sb.append(':');
        }
        if (type != null) {
            sb.append(type.getName());
        } else {
            sb.append(Messages.InformationServices_Undefined);
        }
        if (showCardinality) {
            this.getCardinalityAsString(parameter, sb);
        }
        return sb.toString();
    }

    private void parameterToStringAppendDirection(ParameterDirection direction, boolean showDirection, StringBuffer sb) {
        if (direction != null && showDirection) {
            sb.append(direction.getName());
            sb.append(' ');
        }
    }

    private void parametersToStringReturnAndException(StringBuffer sb, EStructuralFeature typeFeature, EStructuralFeature nameFeature, List<MultiplicityElement> parameters, String qualifier) {
        HashMap typeToMulElesMap = new HashMap();
        for (MultiplicityElement currentParameter : parameters) {
            AbstractType type = (AbstractType)currentParameter.eGet(typeFeature);
            if (type == null) continue;
            String typeName = type.getName();
            if (typeToMulElesMap.containsKey(typeName)) {
                List existingMulEles = (List)typeToMulElesMap.get(typeName);
                existingMulEles.add(currentParameter);
                continue;
            }
            ArrayList<MultiplicityElement> newMulEles = new ArrayList<MultiplicityElement>();
            newMulEles.add(currentParameter);
            typeToMulElesMap.put(typeName, newMulEles);
        }
        boolean first = true;
        for (Map.Entry typeToMulEles : typeToMulElesMap.entrySet()) {
            boolean atLeastOneMulEleIsNamed = false;
            List retrievedMulEles = (List)typeToMulEles.getValue();
            for (MultiplicityElement retrievedMulEle : retrievedMulEles) {
                String mulEleName = (String)retrievedMulEle.eGet(nameFeature);
                if (!mulEleName.equals("")) {
                    atLeastOneMulEleIsNamed = true;
                }
                if (!atLeastOneMulEleIsNamed || mulEleName.equals("")) continue;
                first = this.setQualifier(sb, qualifier, first);
                this.parameterToStringReturnAndException(sb, retrievedMulEle, (String)typeToMulEles.getKey(), mulEleName, false, true, true, false);
            }
            if (atLeastOneMulEleIsNamed) continue;
            first = this.setQualifier(sb, qualifier, first);
            this.parameterToStringReturnAndException(sb, null, (String)typeToMulEles.getKey(), "", false, true, true, false);
        }
    }

    private boolean setQualifier(StringBuffer sb, String qualifier, boolean first) {
        boolean flag = first;
        if (flag) {
            sb.append(qualifier);
            flag = false;
        } else {
            sb.append(this.COMMA_WITH_SPACE);
        }
        return flag;
    }

    private String parameterToStringReturnAndException(StringBuffer sb, MultiplicityElement parameter, String type, String name, boolean showDirection, boolean showName, boolean showType, boolean showCardinality) {
        if (showName) {
            if (showDirection && parameter instanceof ExchangeItemElement) {
                ExchangeItemElement exchangeItemElement = (ExchangeItemElement)parameter;
                ParameterDirection direction = exchangeItemElement.getDirection();
                if (ElementKind.MEMBER.equals((Object)exchangeItemElement.getKind()) && direction != null) {
                    sb.append(direction.getName());
                    sb.append(' ');
                }
            }
            sb.append(name);
            sb.append(':');
        }
        if (!type.equals("")) {
            sb.append(type);
        } else {
            sb.append(Messages.InformationServices_Undefined);
        }
        if (showCardinality) {
            this.getCardinalityAsString(parameter, sb);
        }
        return sb.toString();
    }

    private void getCardinalityAsString(MultiplicityElement parameter, StringBuffer sb) {
        if (parameter == null) {
            return;
        }
        String resultMin = PropertyNamingHelper.getCardValue((NumericValue)parameter.getOwnedMinCard());
        String resultMax = PropertyNamingHelper.getCardValue((NumericValue)parameter.getOwnedMaxCard());
        if (!(parameter.getOwnedMaxCard() instanceof LiteralNumericValue && parameter.getOwnedMinCard() instanceof LiteralNumericValue && "1".equals(resultMin) && "1".equals(resultMax))) {
            sb.append("[");
            sb.append(resultMin);
            sb.append("..");
            sb.append(resultMax);
            sb.append("]");
        }
    }

    public EObject reconnectAssociation(EObject element, EObject source, EObject target, EObject property) {
        Association association = (Association)element;
        Classifier sourceClassifier = (Classifier)source;
        Classifier targetClassifier = (Classifier)target;
        Property sourceProperty = (Property)property;
        Property targetProperty = this.getOthers(sourceProperty, this.getAssociationProperties(association));
        sourceProperty.setAbstractType((AbstractType)targetClassifier);
        Property createdProperty = null;
        if (targetClassifier instanceof Union && !(targetProperty instanceof UnionProperty) && association.getNavigableMembers().contains((Object)targetProperty)) {
            createdProperty = InformationFactory.eINSTANCE.createUnionProperty();
        } else if (!(targetClassifier instanceof Union) && targetProperty instanceof UnionProperty) {
            createdProperty = InformationFactory.eINSTANCE.createProperty();
        }
        if (createdProperty != null) {
            createdProperty.setName(targetProperty.getName());
            createdProperty.setAbstractType(targetProperty.getAbstractType());
            createdProperty.setAggregationKind(targetProperty.getAggregationKind());
            createdProperty.setOwnedMaxCard(targetProperty.getOwnedMaxCard());
            createdProperty.setOwnedMinCard(targetProperty.getOwnedMinCard());
            association.getOwnedMembers().add((Object)createdProperty);
            if (association.getNavigableMembers().contains((Object)targetProperty)) {
                targetClassifier.getOwnedFeatures().add((Object)createdProperty);
                association.getNavigableMembers().add((Object)createdProperty);
                association.getNavigableMembers().remove((Object)targetProperty);
                CapellaServices.getService().removeElement((CapellaElement)targetProperty);
            } else {
                CapellaServices.getService().removeElement((CapellaElement)targetProperty);
            }
        }
        for (Property prop : this.getAssociationProperties(association)) {
            if (!prop.eContainer().equals(sourceClassifier)) continue;
            targetClassifier.getOwnedFeatures().add((Object)prop);
        }
        AssociationExt.moveToCorrectContainer((Association)association);
        return association;
    }

    public String multiplicityToString(MultiplicityElement element) {
        return PropertyNamingHelper.multiplicityToStringDisplay((MultiplicityElement)element);
    }

    public String computeLabel(Operation operation) {
        String result = operation.getName();
        result = String.valueOf(result) + this.parametersToString((AbstractEventOperation)operation);
        return result;
    }

    public String computeLabel(ExchangeCategory category) {
        String result = category.getName();
        return result;
    }

    public String computeLabel(Port port) {
        String result = port.getName();
        return result;
    }

    public String computeLabel(ExchangeItemAllocation item) {
        if (item == null) {
            return "";
        }
        String result = this.getAllocatedElementName(item);
        result = String.valueOf(result) + this.parametersToString((AbstractEventOperation)item);
        return result;
    }

    public String computeLabel(Property property) {
        if (property instanceof Port) {
            return this.computeLabel((Port)property);
        }
        return EObjectLabelProviderHelper.getText((EObject)property);
    }

    public String computeLabel(CommunicationLink link) {
        return String.valueOf(Messages.InformationServices_to) + link.getExchangeItem().getName();
    }

    public String computeLabel(ExchangeItemElement element) {
        String result = this.computeLabelWithoutType(element);
        if (element.getType() != null) {
            result = String.valueOf(result) + " : " + element.getType().getName();
        }
        return result;
    }

    public String computeLabelWithoutType(ExchangeItemElement element) {
        StringBuilder result = new StringBuilder(String.valueOf(PropertyNamingHelper.multiplicityToStringDisplay((MultiplicityElement)element)) + " " + element.getName());
        EList referencedProperties = element.getReferencedProperties();
        if (!referencedProperties.isEmpty()) {
            result.append(" {");
            Iterator iterator = referencedProperties.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                result.append(property.getName());
                if (!iterator.hasNext()) continue;
                result.append(this.COMMA_WITH_SPACE);
            }
            result.append("}");
        }
        return result.toString();
    }

    private Property getOthers(Property property, Collection<Property> properties) {
        for (Property other : properties) {
            if (other == property) continue;
            return other;
        }
        return null;
    }

    public Property getAssociationSource(Association association) {
        int navigableMembersSize = association.getNavigableMembers().size();
        if (1 == navigableMembersSize) {
            return this.getOthers((Property)association.getNavigableMembers().get(0), (Collection<Property>)association.getOwnedMembers());
        }
        if (2 == navigableMembersSize) {
            return (Property)association.getNavigableMembers().get(1);
        }
        if (association.getOwnedMembers().size() > 0) {
            return (Property)association.getOwnedMembers().get(0);
        }
        return null;
    }

    public Collection<Property> getAssociationProperties(Association association) {
        HashSet<Property> properties = new HashSet<Property>();
        properties.addAll((Collection<Property>)association.getOwnedMembers());
        properties.addAll((Collection<Property>)association.getNavigableMembers());
        return properties;
    }

    public Property getAssociationTarget(Association association) {
        int navigableMembersSize = association.getNavigableMembers().size();
        if (1 == navigableMembersSize || 2 == navigableMembersSize) {
            return (Property)association.getNavigableMembers().get(0);
        }
        if (association.getOwnedMembers().size() > 1) {
            return (Property)association.getOwnedMembers().get(1);
        }
        return null;
    }

    public AssociationPkg getSourceClassPkg(Class sourceClass) {
        EObject sourceClassPkg = sourceClass.eContainer();
        if (sourceClassPkg != null && sourceClassPkg instanceof AssociationPkg) {
            return (AssociationPkg)sourceClassPkg;
        }
        return null;
    }

    public AssociationPkg getAssociationPkgCandidate(Class sourceClass, Association association, Class targeClass) {
        EObject associationPkgCandidate = null;
        if (AssociationExt.isUnidirectional((EObject)association)) {
            associationPkgCandidate = sourceClass.eContainer();
        } else {
            EObject commonAncestor = CapellaServices.getService().getCommonAncestor((EObject)sourceClass, (EObject)targeClass);
            associationPkgCandidate = EcoreUtil2.getFirstContainer((EObject)commonAncestor, (EClass)InformationPackage.Literals.ASSOCIATION_PKG);
        }
        if (associationPkgCandidate instanceof AssociationPkg) {
            return (AssociationPkg)associationPkgCandidate;
        }
        return null;
    }

    public String computeLabel(UnionProperty property) {
        Union union;
        String result = this.computeLabel((Property)property);
        EObject container = property.eContainer();
        if (container != null && container instanceof Union && (union = (Union)container).getDiscriminant() != null) {
            result = String.valueOf(result) + this.computeUnionPropertyLabelWithQualifier(property);
        }
        return result;
    }

    private String computeUnionPropertyLabelWithQualifier(UnionProperty property) {
        StringBuilder result = new StringBuilder();
        EList qualifier = property.getQualifier();
        if (qualifier != null && qualifier.size() > 0) {
            result.append(" { ");
            int i = 0;
            while (i < qualifier.size() - 1) {
                result.append(String.valueOf(EObjectLabelProviderHelper.getText((EObject)((EObject)qualifier.get(i)))) + this.COMMA_WITH_SPACE);
                ++i;
            }
            result.append(EObjectLabelProviderHelper.getText((EObject)((EObject)qualifier.get(qualifier.size() - 1))));
            result.append(" }");
        }
        return result.toString();
    }

    public EObject showHideProperties(EObject context, List<Property> selectedProperties, DDiagram diagram) {
        HashMap<Property, AbstractDNode> visibleElements = new HashMap<Property, AbstractDNode>();
        for (AbstractDNode aNode : ((DNodeList)context).getOwnedElements()) {
            if (aNode.getTarget() == null || !(aNode.getTarget() instanceof Property)) continue;
            visibleElements.put((Property)aNode.getTarget(), aNode);
        }
        for (Map.Entry me : visibleElements.entrySet()) {
            if (selectedProperties.contains(me.getKey())) continue;
            DiagramServices.getDiagramServices().removeNodeListElementView((AbstractDNode)me.getValue());
        }
        for (Property aProperty : selectedProperties) {
            if (visibleElements.containsKey(aProperty)) continue;
            this.createPropertyView(context, aProperty, diagram);
        }
        return context;
    }

    private AbstractDNode createPropertyView(EObject context, Property property, DDiagram diagram) {
        String mappingName = "DT_Property";
        NodeMapping mapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
        return DiagramServices.getDiagramServices().createDNodeListElement(mapping, (EObject)property, (DragAndDropTarget)context, diagram);
    }

    @Deprecated
    public EObject showHideExchangeItems(EObject context, List<CapellaElement> selectedOperations, DDiagram diagram) {
        return IBServices.getService().showHideIDExchangeItems(context, selectedOperations, diagram);
    }

    public ExchangeItem createExchangeItem(InterfacePkg pkg, Interface context, String variableName) {
        ExchangeItem item = InformationFactory.eINSTANCE.createExchangeItem();
        pkg.getOwnedExchangeItems().add((Object)item);
        CapellaServices.getService().creationService((EObject)item);
        CsServices.getService().setInterpreterVariable((EObject)context, variableName, (EObject)item);
        return item;
    }

    public CommunicationLink changeExchangeItem(CommunicationLink link, ExchangeItem item) {
        CommunicationLinkExt.changeExchangeItem((CommunicationLink)link, (ExchangeItem)item);
        return link;
    }

    public EObject showHideOperations(EObject context, List<CapellaElement> selectedOperations, DDiagram diagram) {
        HashMap<CapellaElement, AbstractDNode> visibleElements = new HashMap<CapellaElement, AbstractDNode>();
        for (AbstractDNode aNode : ((DNodeList)context).getOwnedElements()) {
            if (aNode.getTarget() == null || !(aNode.getTarget() instanceof Operation) && !(aNode.getTarget() instanceof ExchangeItemElement) && !(aNode.getTarget() instanceof ExchangeItemAllocation)) continue;
            visibleElements.put((CapellaElement)aNode.getTarget(), aNode);
        }
        for (Map.Entry me : visibleElements.entrySet()) {
            if (selectedOperations.contains(me.getKey())) continue;
            DiagramServices.getDiagramServices().removeNodeListElementView((AbstractDNode)me.getValue());
        }
        for (CapellaElement aOperation : selectedOperations) {
            if (visibleElements.containsKey(aOperation)) continue;
            this.createOperationView(context, aOperation, diagram);
        }
        return context;
    }

    @Deprecated
    public EObject showHideDataValues(EObject context, List<CapellaElement> selectedDataValues, DDiagram diagram) {
        return this.showHideCDBDataValues(context, selectedDataValues, diagram);
    }

    public EObject showHideCDBDataValues(EObject context, List<CapellaElement> selectedDataValues, DDiagram diagram) {
        EList eList;
        HashMap<CapellaElement, AbstractDNode> visibleElements = new HashMap<CapellaElement, AbstractDNode>();
        ArrayList<DNode> allNodes = new ArrayList<DNode>();
        if (context != null && (context instanceof DDiagram || context instanceof DNodeContainer)) {
            allNodes.addAll(DiagramServices.getDiagramServices().getAllNodes(context));
        } else if (context instanceof DNodeList && (eList = ((DNodeList)context).getElements()) != null) {
            allNodes.addAll((Collection<DNode>)eList);
        }
        for (EObject eObject : allNodes) {
            DDiagramElement aNode;
            EObject nodeTarget;
            if (!(eObject instanceof DDiagramElement) || (nodeTarget = (aNode = (DDiagramElement)eObject).getTarget()) == null || !(nodeTarget instanceof DataValue) || !(aNode instanceof AbstractDNode)) continue;
            visibleElements.put((CapellaElement)nodeTarget, (AbstractDNode)aNode);
        }
        for (Map.Entry entry : visibleElements.entrySet()) {
            if (selectedDataValues.contains(entry.getKey())) continue;
            EObject container = ((AbstractDNode)entry.getValue()).eContainer();
            if (container instanceof DNodeList) {
                DiagramServices.getDiagramServices().removeNodeListElementView((AbstractDNode)entry.getValue());
                continue;
            }
            if (!(container instanceof DSemanticDiagram) && !(container instanceof DNodeContainer)) continue;
            DiagramServices.getDiagramServices().removeNodeView((DNode)entry.getValue());
        }
        for (CapellaElement capellaElement : selectedDataValues) {
            if (visibleElements.containsKey(capellaElement)) continue;
            this.createDataValueView(context, capellaElement, diagram);
        }
        return context;
    }

    private AbstractDNode createDataValueView(EObject context, CapellaElement dataValue, DDiagram diagram) {
        String mappingName = null;
        String dataTypeContentMappingName = "Contents";
        String dataTypeUnitMappingName = "Units";
        String booleanTypeContentsMappingName = "BooleanTypeContents";
        String booleanTypeLiteralsMappingName = "DT_BooleanLiteral";
        String enumerationContentsMappingName = "EnumerationContents";
        String enumerationLiteralsMappingName = "DT_EnumerationLiteral";
        String dataDataValueMappingName = "DT_DataValue";
        String dataSubDataValueMappingName = "DT_SubDataValue";
        if ("Class Diagram Blank".equals(diagram.getDescription().getName())) {
            BooleanType type;
            if (((DSemanticDecorator)context).getTarget() instanceof NumericType || ((DSemanticDecorator)context).getTarget() instanceof StringType || ((DSemanticDecorator)context).getTarget() instanceof PhysicalQuantity) {
                if (dataValue instanceof DataValue) {
                    mappingName = dataTypeContentMappingName;
                } else if (dataValue instanceof Unit) {
                    mappingName = dataTypeUnitMappingName;
                }
            } else if (((DSemanticDecorator)context).getTarget() instanceof BooleanType) {
                type = (BooleanType)((DSemanticDecorator)context).getTarget();
                EList ownedLiterals = type.getOwnedLiterals();
                mappingName = !ownedLiterals.isEmpty() && ownedLiterals.contains((Object)dataValue) ? booleanTypeLiteralsMappingName : booleanTypeContentsMappingName;
            } else if (((DSemanticDecorator)context).getTarget() instanceof Enumeration) {
                type = (Enumeration)((DSemanticDecorator)context).getTarget();
                EList ownedLiterals = type.getOwnedLiterals();
                mappingName = !ownedLiterals.isEmpty() && ownedLiterals.contains((Object)dataValue) ? enumerationLiteralsMappingName : enumerationContentsMappingName;
            } else if (((DSemanticDecorator)context).getTarget() instanceof Class) {
                mappingName = dataSubDataValueMappingName;
            } else if (((DSemanticDecorator)context).getTarget() instanceof DataPkg) {
                mappingName = dataDataValueMappingName;
            } else if (((DSemanticDecorator)context).getTarget() instanceof org.polarsys.capella.core.data.information.Collection) {
                mappingName = dataSubDataValueMappingName;
            }
        }
        NodeMapping mapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
        if (context instanceof DNodeList) {
            return DiagramServices.getDiagramServices().createDNodeListElement(mapping, (EObject)dataValue, (DragAndDropTarget)context, diagram);
        }
        return DiagramServices.getDiagramServices().createNode(mapping, (EObject)dataValue, (DragAndDropTarget)context, diagram);
    }

    AbstractDNode createOperationView(EObject context, CapellaElement Operation2, DDiagram diagram) {
        NodeMapping mapping;
        String mappingName = "DT_Operation";
        if ("Class Diagram Blank".equals(diagram.getDescription().getName())) {
            if (((DSemanticDecorator)context).getTarget() instanceof Interface) {
                mappingName = "DT_Operation1";
            }
        } else if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            if (((DSemanticDecorator)context).getTarget() instanceof Interface) {
                mappingName = "IDB_Operation";
            } else if (((DSemanticDecorator)context).getTarget() instanceof ExchangeItem) {
                mappingName = "IDB_ExchangeItemElement";
            }
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            if (((DSemanticDecorator)context).getTarget() instanceof Interface) {
                mappingName = "DT_Operation1";
            } else if (((DSemanticDecorator)context).getTarget() instanceof ExchangeItem) {
                mappingName = "CCDI_ExchangeItemElement";
            }
        } else if ("Interface Diagram".equals(diagram.getDescription().getName()) && ((DSemanticDecorator)context).getTarget() instanceof Interface) {
            mappingName = "ID_Operation";
        }
        if ((mapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName)) != null) {
            return DiagramServices.getDiagramServices().createDNodeListElement(mapping, (EObject)Operation2, (DragAndDropTarget)context, diagram);
        }
        return null;
    }

    public void showCDBRelationship(EObject semantic, DDiagramContents content) {
        Collection<DDiagramElement> views;
        GeneralizableElement source = null;
        GeneralizableElement target = null;
        EObject sourceView = null;
        EObject targetView = null;
        Property associationSource = null;
        Property associationTarget = null;
        EdgeMapping mapping = null;
        if (semantic instanceof Association) {
            mapping = this.getMappingCDBAssociation((CapellaElement)semantic, content.getDDiagram());
            associationSource = this.getAssociationSource((Association)semantic);
            if (associationSource != null) {
                source = associationSource.getAbstractType();
            }
            if ((associationTarget = this.getAssociationTarget((Association)semantic)) != null) {
                target = associationTarget.getAbstractType();
            }
        } else if (semantic instanceof Generalization) {
            mapping = this.getMappingCDBGeneralization((CapellaElement)semantic, content.getDDiagram());
            source = ((Generalization)semantic).getSub();
            target = ((Generalization)semantic).getSuper();
        } else if (semantic instanceof ExchangeItemElement) {
            mapping = this.getMappingCDBExchangeItemElement((CapellaElement)semantic, content.getDDiagram());
            source = (AbstractType)((ExchangeItemElement)semantic).eContainer();
            target = ((ExchangeItemElement)semantic).getType();
        }
        if (mapping == null || content.getDiagramElements(semantic, (DiagramElementMapping)mapping).size() > 0) {
            return;
        }
        if (source != null) {
            AbstractNodeMapping sourceMapping = this.getMappingCDBCapellaElement((CapellaElement)source, content.getDDiagram());
            views = content.getDiagramElements((EObject)source, (DiagramElementMapping)sourceMapping);
            if (views.size() > 0) {
                sourceView = (EObject)views.iterator().next();
            } else {
                sourceView = DiagramServices.getDiagramServices().createAbstractDNodeContainer(sourceMapping, (EObject)source, content.getBestContainer((EObject)source), content.getDDiagram());
                content.addView((DDiagramElement)((AbstractDNode)sourceView));
            }
        }
        if (target != null) {
            AbstractNodeMapping targetMapping = this.getMappingCDBCapellaElement((CapellaElement)target, content.getDDiagram());
            views = content.getDiagramElements((EObject)target, (DiagramElementMapping)targetMapping);
            if (views.size() > 0) {
                targetView = (EObject)views.iterator().next();
            } else {
                targetView = DiagramServices.getDiagramServices().createAbstractDNodeContainer(targetMapping, (EObject)target, content.getBestContainer((EObject)target), content.getDDiagram());
                content.addView((DDiagramElement)((AbstractDNode)targetView));
            }
        }
        if (sourceView != null && targetView != null) {
            content.addView((DDiagramElement)DiagramServices.getDiagramServices().createEdge(mapping, (EdgeTarget)sourceView, (EdgeTarget)targetView, semantic));
        }
    }

    @Deprecated
    public EObject showHideRelationshipInClassDiagramBlank(CapellaElement context, EObject context_view, List<CapellaElement> allSelectedLinksFromWizard) {
        return this.showHideCDBRelationships(context, context_view, allSelectedLinksFromWizard);
    }

    public EObject showHideCDBRelationships(CapellaElement context, EObject context_view, List<CapellaElement> allSelectedLinksFromWizard) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(context_view);
        DDiagramContents content = new DDiagramContents(diagram);
        for (DEdge existingRelationship : diagram.getEdges()) {
            EObject target = existingRelationship.getTarget();
            if (target == null || !context_view.equals(existingRelationship.getSourceNode()) && !context_view.equals(existingRelationship.getTargetNode()) || diagram.isSynchronized() && !(target instanceof Generalization) || allSelectedLinksFromWizard.contains(target) || !this.isValideRelationShip(target, (EObject)context, content)) continue;
            DiagramServices.getDiagramServices().removeEdgeView(existingRelationship);
            content.removeView((DDiagramElement)existingRelationship);
        }
        for (CapellaElement selectedRelationship : allSelectedLinksFromWizard) {
            this.showCDBRelationship((EObject)selectedRelationship, content);
        }
        return context_view;
    }

    private boolean isValideRelationShip(EObject target, EObject context, DDiagramContents content) {
        boolean isValide = true;
        Collection<DDiagramElement> diagramElements = content.getDiagramElements(target);
        if (diagramElements != null && !diagramElements.isEmpty() && context instanceof ExchangeItem && !(target instanceof Constraint)) {
            return true;
        }
        if (target instanceof org.polarsys.capella.core.data.information.Collection) {
            isValide = false;
        } else if (target instanceof ExchangeItemElement) {
            isValide = false;
        } else if (target instanceof Constraint) {
            isValide = false;
        }
        return isValide;
    }

    private EdgeMapping getMappingCDBExchangeItemElement(CapellaElement source, DDiagram diagram) {
        String mappingName = null;
        if (diagram.getDescription().getName().equalsIgnoreCase("Class Diagram Blank")) {
            mappingName = "DT_ExchangeItemElement";
        }
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    private AbstractNodeMapping getMappingCDBCapellaElement(CapellaElement element, DDiagram diagram) {
        String mappingName = null;
        if (diagram.getDescription().getName().equalsIgnoreCase("Class Diagram Blank")) {
            if (element instanceof Class) {
                mappingName = "DT_Class";
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            }
            if (element instanceof org.polarsys.capella.core.data.information.Collection) {
                mappingName = "DT_Collection";
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            }
            if (element instanceof Interface) {
                mappingName = "FullInterface1";
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            }
            if (element instanceof DataType && !(element instanceof Enumeration) && !(element instanceof BooleanType)) {
                mappingName = "DT_DataType";
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            }
            if (element instanceof Enumeration) {
                mappingName = "DT_Enumeration";
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            }
            if (element instanceof BooleanType) {
                mappingName = "DT_BooleanType";
                return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            }
            if (element instanceof ExchangeItem) {
                mappingName = "DT_ExchangeItem";
                return DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, mappingName);
            }
        }
        return null;
    }

    private ContainerMapping getMappingCDBType(EObject element, DDiagram diagram) {
        ContainerMapping mapping = null;
        mapping = element instanceof Class ? DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_Class") : (element instanceof org.polarsys.capella.core.data.information.Collection ? DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_Collection") : (element instanceof Enumeration ? DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_Enumeration") : (element instanceof BooleanType ? DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_BooleanType") : DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_DataType"))));
        return mapping;
    }

    private EdgeMapping getMappingCDBAssociation(CapellaElement element, DDiagram diagram) {
        String mappingName = null;
        if (diagram.getDescription().getName().equalsIgnoreCase("Class Diagram Blank")) {
            mappingName = "DT_Association";
        }
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    private EdgeMapping getMappingCDBGeneralization(CapellaElement element, DDiagram diagram) {
        String mappingName = null;
        if (diagram.getDescription().getName().equalsIgnoreCase("Class Diagram Blank")) {
            mappingName = "DT_Generalization";
        }
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    public List<DataPkg> getCDBShowHideDataPkgsScope(EObject elementView) {
        List returnedPackages = null;
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer(elementView);
        if (elementView.equals(diagram)) {
            returnedPackages = QueryInterpretor.executeQuery((String)"GetAllDataPkgsForLib", (Object)diagram.getTarget());
        } else if (elementView instanceof DNodeContainer) {
            DataPkg currentPkg = (DataPkg)((DNodeContainer)elementView).getTarget();
            returnedPackages = DataPkgExt.getRecursiveSubDataPkgs((DataPkg)currentPkg);
        }
        for (AbstractDNode aContainer : diagram.getContainers()) {
            if (!(aContainer.getTarget() instanceof DataPkg)) continue;
            returnedPackages.remove(aContainer.getTarget());
        }
        return returnedPackages;
    }

    @Deprecated
    public List<DataPkg> getAvailableDataPkgsToInsert(EObject elementView) {
        return this.getCDBShowHideDataPkgsScope(elementView);
    }

    public List<InterfacePkg> getAvailableInterfacePkgsToInsert(EObject elementView) {
        List returnedPackages = null;
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer(elementView);
        if (elementView.equals(diagram)) {
            returnedPackages = QueryInterpretor.executeQuery((String)"GetAllInterfacePcksForLib", (Object)diagram.getTarget());
        } else if (elementView instanceof DNodeContainer) {
            InterfacePkg currentPkg = (InterfacePkg)((DNodeContainer)elementView).getTarget();
            returnedPackages = InterfacePkgExt.getRecursiveSubInterfacePkgs((InterfacePkg)currentPkg);
        }
        for (AbstractDNode aContainer : diagram.getContainers()) {
            if (!(aContainer.getTarget() instanceof InterfacePkg)) continue;
            returnedPackages.remove(aContainer.getTarget());
        }
        return returnedPackages;
    }

    public AbstractDNode showCDBDataPkg(EObject semantic, DDiagramContents context) {
        DragAndDropTarget container;
        ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(context.getDDiagram(), "DT_DataPkg");
        Collection<DDiagramElement> views = context.getDiagramElements(semantic, (DiagramElementMapping)mapping, (DSemanticDecorator)(container = context.getBestContainer(semantic)));
        if (views.size() > 0) {
            return (AbstractDNode)views.iterator().next();
        }
        DNodeContainer result = DiagramServices.getDiagramServices().createContainer(mapping, semantic, container, context.getDDiagram());
        context.addView((DDiagramElement)result);
        return result;
    }

    public EObject showHideCDBDataPkgs(EObject elementView, List<DataPkg> selectedPkgs) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(elementView);
        DDiagramContents content = new DDiagramContents(diagram);
        ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_DataPkg");
        HashMap<DataPkg, DNodeContainer> existingPkgs = new HashMap<DataPkg, DNodeContainer>();
        for (DDiagramElement aContainer : content.getDiagramElements((DSemanticDecorator)elementView, (DiagramElementMapping)mapping)) {
            if (!(aContainer instanceof DNodeContainer) || !(aContainer.getTarget() instanceof DataPkg)) continue;
            existingPkgs.put((DataPkg)aContainer.getTarget(), (DNodeContainer)aContainer);
        }
        HashSet<DNodeContainer> toBeRemoved = new HashSet<DNodeContainer>();
        for (Map.Entry me : existingPkgs.entrySet()) {
            if (selectedPkgs.contains(me.getKey())) continue;
            toBeRemoved.add((DNodeContainer)me.getValue());
        }
        for (DNodeContainer aContainer : existingPkgs.values()) {
            if (toBeRemoved.contains(aContainer) || !toBeRemoved.contains(aContainer.eContainer())) continue;
            diagram.getOwnedDiagramElements().add((Object)aContainer);
        }
        for (DNodeContainer aContainer : toBeRemoved) {
            DiagramServices.getDiagramServices().removeContainerView((EObject)aContainer);
        }
        for (DataPkg aPkg : selectedPkgs) {
            if (existingPkgs.containsKey(aPkg)) continue;
            this.showCDBDataPkg((EObject)aPkg, content);
        }
        return elementView;
    }

    @Deprecated
    public EObject showHideDataPkgs(EObject elementView, List<DataPkg> selectedPkgs) {
        return this.showHideCDBDataPkgs(elementView, selectedPkgs);
    }

    public AbstractDNode showCDBInterfacePkg(EObject semantic, DDiagramContents context) {
        DragAndDropTarget container;
        ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(context.getDDiagram(), "DT_InterfacePkg");
        Collection<DDiagramElement> views = context.getDiagramElements(semantic, (DiagramElementMapping)mapping, (DSemanticDecorator)(container = context.getBestContainer(semantic)));
        if (views.size() > 0) {
            return (AbstractDNode)views.iterator().next();
        }
        DNodeContainer result = DiagramServices.getDiagramServices().createContainer(mapping, semantic, container, context.getDDiagram());
        context.addView((DDiagramElement)result);
        return result;
    }

    public EObject showHideCDBInterfacePkgs(EObject elementView, List<InterfacePkg> selectedPkgs) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(elementView);
        DDiagramContents content = new DDiagramContents(diagram);
        ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_InterfacePkg");
        HashMap<InterfacePkg, DNodeContainer> existingPkgs = new HashMap<InterfacePkg, DNodeContainer>();
        for (DDiagramElement aContainer : content.getDiagramElements((DSemanticDecorator)elementView, (DiagramElementMapping)mapping)) {
            if (!(aContainer instanceof DNodeContainer) || !(aContainer.getTarget() instanceof InterfacePkg)) continue;
            existingPkgs.put((InterfacePkg)aContainer.getTarget(), (DNodeContainer)aContainer);
        }
        HashSet<DNodeContainer> toBeRemoved = new HashSet<DNodeContainer>();
        for (Map.Entry me : existingPkgs.entrySet()) {
            if (selectedPkgs.contains(me.getKey())) continue;
            toBeRemoved.add((DNodeContainer)me.getValue());
        }
        for (DNodeContainer aContainer : existingPkgs.values()) {
            if (toBeRemoved.contains(aContainer) || !toBeRemoved.contains(aContainer.eContainer())) continue;
            diagram.getOwnedDiagramElements().add((Object)aContainer);
        }
        for (DNodeContainer aContainer : toBeRemoved) {
            DiagramServices.getDiagramServices().removeContainerView((EObject)aContainer);
        }
        for (InterfacePkg aPkg : selectedPkgs) {
            if (existingPkgs.containsKey(aPkg)) continue;
            this.showCDBInterfacePkg((EObject)aPkg, content);
        }
        return elementView;
    }

    @Deprecated
    public EObject showHideInterfacePkgs(EObject elementView, List<InterfacePkg> selectedPkgs) {
        HashMap<InterfacePkg, DDiagramElement> existingPkgs = new HashMap<InterfacePkg, DDiagramElement>();
        for (DDiagramElement dDiagramElement : DiagramServices.getDiagramServices().getAllNodeContainers(elementView)) {
            if (!(dDiagramElement.getTarget() instanceof InterfacePkg)) continue;
            existingPkgs.put((InterfacePkg)dDiagramElement.getTarget(), dDiagramElement);
        }
        DDiagram dDiagram = CapellaServices.getService().getDiagramContainer(elementView);
        HashSet<DDiagramElement> toBeRemoved = new HashSet<DDiagramElement>();
        for (Map.Entry me : existingPkgs.entrySet()) {
            if (selectedPkgs.contains(me.getKey())) continue;
            toBeRemoved.add((DDiagramElement)me.getValue());
        }
        for (DDiagramElement aContainer : existingPkgs.values()) {
            if (toBeRemoved.contains(aContainer) || !toBeRemoved.contains(aContainer.eContainer())) continue;
            dDiagram.getOwnedDiagramElements().add((Object)aContainer);
        }
        for (DDiagramElement aContainer : toBeRemoved) {
            DiagramServices.getDiagramServices().removeContainerView((EObject)aContainer);
        }
        for (InterfacePkg aPkg : selectedPkgs) {
            if (existingPkgs.containsKey(aPkg)) continue;
            ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(dDiagram, "DT_InterfacePkg");
            DiagramServices.getDiagramServices().createContainer(mapping, (EObject)aPkg, (DragAndDropTarget)dDiagram, dDiagram);
        }
        return elementView;
    }

    @Deprecated
    public EObject showHideDependentPkgs(EObject elementView, List<AbstractDependenciesPkg> selectedPkgs, List<AbstractDependenciesPkg> existingPackages) {
        return this.showHidePDDependentPkgs(elementView, selectedPkgs, existingPackages);
    }

    public EObject showHidePDDependentPkgs(EObject elementView, List<AbstractDependenciesPkg> selectedPkgs, List<AbstractDependenciesPkg> existingPackages) {
        HashMap<AbstractDependenciesPkg, DDiagramElement> existingPkgs = new HashMap<AbstractDependenciesPkg, DDiagramElement>();
        for (DDiagramElement dDiagramElement : DiagramServices.getDiagramServices().getAllNodeContainers(elementView)) {
            if (!existingPackages.contains(dDiagramElement.getTarget())) continue;
            existingPkgs.put((AbstractDependenciesPkg)dDiagramElement.getTarget(), dDiagramElement);
        }
        DDiagram dDiagram = CapellaServices.getService().getDiagramContainer(elementView);
        HashSet<DDiagramElement> toBeRemoved = new HashSet<DDiagramElement>();
        for (Map.Entry entry : existingPkgs.entrySet()) {
            if (selectedPkgs.contains(entry.getKey())) continue;
            toBeRemoved.add((DDiagramElement)entry.getValue());
        }
        for (DDiagramElement dDiagramElement : DiagramServices.getDiagramServices().getAllNodeContainers((EObject)dDiagram)) {
            if (toBeRemoved.contains(dDiagramElement) || !toBeRemoved.contains(dDiagramElement.eContainer())) continue;
            dDiagram.getOwnedDiagramElements().add((Object)dDiagramElement);
        }
        for (DDiagramElement dDiagramElement : toBeRemoved) {
            DiagramServices.getDiagramServices().removeContainerView((EObject)dDiagramElement);
        }
        for (AbstractDependenciesPkg abstractDependenciesPkg : selectedPkgs) {
            if (existingPkgs.containsKey(abstractDependenciesPkg)) continue;
            String mappingName = null;
            mappingName = abstractDependenciesPkg instanceof DataPkg ? "DT_DataPkg" : "DT_InterfacePkg";
            ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(dDiagram, mappingName);
            DiagramServices.getDiagramServices().createContainer(mapping, (EObject)abstractDependenciesPkg, (DragAndDropTarget)dDiagram, dDiagram);
        }
        return elementView;
    }

    @Deprecated
    public EObject showHidePackageDependencies(AbstractDependenciesPkg subject, DDiagram diagram) {
        return this.showHidePDPackageDependencies(subject, diagram);
    }

    public EObject showHidePDPackageDependencies(AbstractDependenciesPkg subject, DDiagram diagram) {
        Collection deps = AbstractDependenciesPkgExt.getDependencies((AbstractDependenciesPkg)subject);
        Collection inverseDeps = AbstractDependenciesPkgExt.getInverseDependencies((AbstractDependenciesPkg)subject);
        ArrayList<AbstractDependenciesPkg> all = new ArrayList<AbstractDependenciesPkg>(deps);
        all.addAll(inverseDeps);
        boolean expandLeftViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandLeftViewerContent();
        boolean expandRightViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandRightViewerContent();
        int leftViewerExpandLevel = expandLeftViewer ? -1 : 0;
        int rightViewerExpandLevel = expandRightViewer ? -1 : 0;
        TransferTreeListDialog dialog = new TransferTreeListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.InformationServices_PackageDependency_Title, NLS.bind((String)Messages.InformationServices_PackageDependency_Message, (Object)subject.getName()), (DataLabelProvider)new DependencyLabelProvider(deps, inverseDeps, (Object)subject), (DataLabelProvider)new DependencyLabelProvider(deps, inverseDeps, (Object)subject), leftViewerExpandLevel, rightViewerExpandLevel);
        ArrayList<AbstractDependenciesPkg> left = new ArrayList<AbstractDependenciesPkg>();
        ArrayList<AbstractDependenciesPkg> right = new ArrayList<AbstractDependenciesPkg>();
        for (AbstractDependenciesPkg pkg : all) {
            if (DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)pkg) != null) {
                right.add(pkg);
                continue;
            }
            left.add(pkg);
        }
        dialog.setLeftInput(left, (Object)subject);
        dialog.setRightInput(right, (Object)subject);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            right.clear();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof AbstractDependenciesPkg) {
                    right.add((AbstractDependenciesPkg)o);
                }
                ++n2;
            }
            this.showHidePDDependentPkgs((EObject)diagram, right, all);
        }
        return subject;
    }

    public Collection<AbstractDependenciesPkg> getDependentPackages(AbstractDependenciesPkg pkg) {
        return AbstractDependenciesPkgExt.getDependencies((AbstractDependenciesPkg)pkg);
    }

    public Collection<AbstractDependenciesPkg> getDependenciesAndInverseDependencies(AbstractDependenciesPkg pkg) {
        HashSet<AbstractDependenciesPkg> result = new HashSet<AbstractDependenciesPkg>();
        result.addAll(AbstractDependenciesPkgExt.getDependencies((AbstractDependenciesPkg)pkg));
        result.addAll(AbstractDependenciesPkgExt.getInverseDependencies((AbstractDependenciesPkg)pkg));
        return result;
    }

    public boolean isADependencyAvailable(EObject context, AbstractDependenciesPkg sourcePackage, AbstractDependenciesPkg targetPackage) {
        return AbstractDependenciesPkgExt.isADependencyAvailable((AbstractDependenciesPkg)sourcePackage, (AbstractDependenciesPkg)targetPackage);
    }

    public boolean isADependencyAvailable2(EObject context, EObject sourceObj, EObject targetObj) {
        EObject ancestor1 = CapellaServices.getService().getAncestor(sourceObj, CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG);
        EObject ancestor2 = CapellaServices.getService().getAncestor(targetObj, CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG);
        return AbstractDependenciesPkgExt.isADependencyAvailable((AbstractDependenciesPkg)((AbstractDependenciesPkg)ancestor1), (AbstractDependenciesPkg)((AbstractDependenciesPkg)ancestor2));
    }

    public Collection<DataType> getAvailableDataTypesToInsert(EObject elementView) {
        DNodeContainer currentContainer;
        if (elementView instanceof DDiagram) {
            return QueryInterpretor.executeQuery((String)"GetAllDataTypesForLib", (Object)((DSemanticDiagram)elementView).getTarget());
        }
        if (elementView instanceof DNodeContainer && (currentContainer = (DNodeContainer)elementView).getTarget() instanceof DataPkg) {
            return DataPkgExt.getAllDataTypes((DataPkg)((DataPkg)currentContainer.getTarget()));
        }
        return Collections.emptyList();
    }

    public Collection<Class> getAvailableClassesToInsert(EObject elementView) {
        DNodeContainer currentContainer;
        if (elementView instanceof DDiagram) {
            return QueryInterpretor.executeQuery((String)"GetAllClassesForLib", (Object)((DSemanticDiagram)elementView).getTarget());
        }
        if (elementView instanceof DNodeContainer && (currentContainer = (DNodeContainer)elementView).getTarget() instanceof DataPkg) {
            return DataPkgExt.getAllClasses((DataPkg)((DataPkg)currentContainer.getTarget()));
        }
        return Collections.emptyList();
    }

    public Collection<Interface> getAvailableInterfacesToInsert(EObject elementView) {
        DNodeContainer currentContainer;
        if (elementView instanceof DDiagram) {
            return QueryInterpretor.executeQuery((String)"GetAllInterfacesForLib", (Object)((DSemanticDiagram)elementView).getTarget());
        }
        if (elementView instanceof DNodeContainer && (currentContainer = (DNodeContainer)elementView).getTarget() instanceof InterfacePkg) {
            return InterfacePkgExt.getAllInterfaces((InterfacePkg)((InterfacePkg)currentContainer.getTarget()));
        }
        return Collections.emptyList();
    }

    public Collection<Interface> getAvailableInterfacesToInsert(EObject context, EObject containerView) {
        if (containerView instanceof DDiagram) {
            return InterfaceExt.getAllInterfaces((EObject)context);
        }
        if (context instanceof InterfacePkg) {
            return InterfacePkgExt.getAllInterfaces((InterfacePkg)((InterfacePkg)context));
        }
        return Collections.emptyList();
    }

    public Collection<AbstractExchangeItem> getAvailableExchangeItemsToInsert(EObject elementView) {
        DNodeContainer currentContainer;
        if (elementView instanceof DDiagram) {
            return QueryInterpretor.executeQuery((String)"GetAllExchangeItemsForLib", (Object)((DSemanticDiagram)elementView).getTarget());
        }
        if (elementView instanceof DNodeContainer && (currentContainer = (DNodeContainer)elementView).getTarget() instanceof AbstractExchangeItemPkg) {
            return AbstractExchangeItemPkgExt.getAllAbstractExchangeItems((AbstractExchangeItemPkg)((DataPkg)currentContainer.getTarget()));
        }
        return Collections.emptyList();
    }

    public Collection<org.polarsys.capella.core.data.information.Collection> getAvailableCollectionsToInsert(EObject elementView) {
        DNodeContainer currentContainer;
        if (elementView instanceof DDiagram) {
            return QueryInterpretor.executeQuery((String)"GetAllCollectionsForLib", (Object)((DSemanticDiagram)elementView).getTarget());
        }
        if (elementView instanceof DNodeContainer && (currentContainer = (DNodeContainer)elementView).getTarget() instanceof DataPkg) {
            return DataPkgExt.getAllCollections((DataPkg)((DataPkg)currentContainer.getTarget()));
        }
        return Collections.emptyList();
    }

    @Deprecated
    public EObject showHideTypes(EObject elementView, List<EObject> selectedTypes) {
        return this.showHideCDBTypes(elementView, selectedTypes);
    }

    public EObject showHideCDBTypes(EObject elementView, List<EObject> selectedTypes) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(elementView);
        DDiagramContents content = new DDiagramContents(diagram);
        HashMap<EObject, AbstractDNode> existingTypes = new HashMap<EObject, AbstractDNode>();
        for (EObject eObject : DiagramServices.getDiagramServices().getAllContainersAndNodeLists(elementView)) {
            AbstractDNode aContainer = (AbstractDNode)eObject;
            if (!(aContainer.getTarget() instanceof Class) && !(aContainer.getTarget() instanceof org.polarsys.capella.core.data.information.Collection) && !(aContainer.getTarget() instanceof DataType)) continue;
            existingTypes.put(aContainer.getTarget(), aContainer);
        }
        for (Map.Entry entry : existingTypes.entrySet()) {
            if (selectedTypes.contains(entry.getKey())) continue;
            DiagramServices.getDiagramServices().removeContainerView((EObject)entry.getValue());
        }
        for (EObject eObject : selectedTypes) {
            if (existingTypes.containsKey(eObject)) continue;
            this.showCDBType(eObject, content);
        }
        return elementView;
    }

    public AbstractDNode showCDBType(EObject semantic, DDiagramContents context) {
        DragAndDropTarget container;
        ContainerMapping mapping = this.getMappingCDBType(semantic, context.getDDiagram());
        Collection<DDiagramElement> views = context.getDiagramElements(semantic, (DiagramElementMapping)mapping, (DSemanticDecorator)(container = context.getBestContainer(semantic)));
        if (views.size() > 0) {
            return (AbstractDNode)views.iterator().next();
        }
        AbstractDNode result = DiagramServices.getDiagramServices().createAbstractDNodeContainer((AbstractNodeMapping)mapping, semantic, container, context.getDDiagram());
        context.addView((DDiagramElement)result);
        return result;
    }

    public AbstractDNode showCDBInterface(EObject semantic, DDiagramContents context) {
        DragAndDropTarget container;
        ContainerMapping mapping = this.getMappingCDBInterface(semantic, context.getDDiagram());
        Collection<DDiagramElement> views = context.getDiagramElements(semantic, (DiagramElementMapping)mapping, (DSemanticDecorator)(container = context.getBestContainer(semantic)));
        if (views.size() > 0) {
            return (AbstractDNode)views.iterator().next();
        }
        AbstractDNode result = DiagramServices.getDiagramServices().createAbstractDNodeContainer((AbstractNodeMapping)mapping, semantic, container, context.getDDiagram());
        context.addView((DDiagramElement)result);
        return result;
    }

    private ContainerMapping getMappingCDBInterface(EObject semantic, DDiagram dDiagram) {
        return DiagramServices.getDiagramServices().getContainerMapping(dDiagram, "FullInterface1");
    }

    public AbstractDNode showCDBExchangeItem(EObject semantic, DDiagramContents context) {
        DragAndDropTarget container;
        NodeMapping mapping = this.getMappingCDBExchangeItem(semantic, context.getDDiagram());
        Collection<DDiagramElement> views = context.getDiagramElements(semantic, (DiagramElementMapping)mapping, (DSemanticDecorator)(container = context.getBestContainer(semantic)));
        if (views.size() > 0) {
            return (AbstractDNode)views.iterator().next();
        }
        DNode result = DiagramServices.getDiagramServices().createNode(mapping, semantic, container, context.getDDiagram());
        context.addView((DDiagramElement)result);
        return result;
    }

    private NodeMapping getMappingCDBExchangeItem(EObject semantic, DDiagram dDiagram) {
        return DiagramServices.getDiagramServices().getNodeMapping(dDiagram, "FullInterface1");
    }

    public EObject showHideCDBInterfaces(EObject elementView, List<EObject> selectedInterfaces) {
        HashMap<EObject, AbstractDNode> existingInterfaces = new HashMap<EObject, AbstractDNode>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(elementView);
        DDiagramContents content = new DDiagramContents(diagram);
        for (EObject eObject : DiagramServices.getDiagramServices().getAllContainersAndNodeLists(elementView)) {
            AbstractDNode aContainer = (AbstractDNode)eObject;
            if (!(aContainer.getTarget() instanceof Interface)) continue;
            existingInterfaces.put(aContainer.getTarget(), aContainer);
        }
        for (Map.Entry entry : existingInterfaces.entrySet()) {
            if (selectedInterfaces.contains(entry.getKey())) continue;
            DiagramServices.getDiagramServices().removeContainerView((EObject)entry.getValue());
        }
        for (EObject eObject : selectedInterfaces) {
            if (existingInterfaces.containsKey(eObject)) continue;
            this.showCDBInterface(eObject, content);
        }
        return elementView;
    }

    public Collection<EObject> getCDBAssociationSemanticCandidates(DDiagram diagram) {
        HashSet<EObject> candidateAssociations = new HashSet<EObject>();
        for (DDiagramElement dNode : diagram.getDiagramElements()) {
            EObject target;
            if (!(dNode instanceof AbstractDNode) || !((target = dNode.getTarget()) instanceof AbstractType)) continue;
            List properties = EObjectExt.getReferencers((EObject)target, (EClass)InformationPackage.Literals.PROPERTY, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
            for (EObject property : properties) {
                candidateAssociations.addAll(EObjectExt.getReferencers((EObject)property, (EClass)InformationPackage.Literals.ASSOCIATION, (EReference)InformationPackage.Literals.ASSOCIATION__NAVIGABLE_MEMBERS));
                candidateAssociations.addAll(EObjectExt.getReferencers((EObject)property, (EClass)InformationPackage.Literals.ASSOCIATION, (EReference)InformationPackage.Literals.ASSOCIATION__OWNED_MEMBERS));
            }
        }
        return candidateAssociations;
    }

    public Collection<EObject> getCDBGeneralizationSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> candidateGeneralizations = new ArrayList<EObject>();
        for (DDiagramElement dNode : diagram.getDiagramElements()) {
            EObject target;
            if (!(dNode instanceof AbstractDNode) || !((target = dNode.getTarget()) instanceof GeneralizableElement)) continue;
            candidateGeneralizations.addAll((Collection<EObject>)((GeneralizableElement)target).getOwnedGeneralizations());
        }
        return candidateGeneralizations;
    }

    public Collection<EObject> getCDBExchangeItemElementSemanticCandidates(DDiagram diagram) {
        ArrayList<EObject> candidateExchangeItemElements = new ArrayList<EObject>();
        for (DDiagramElement dNode : diagram.getDiagramElements()) {
            EObject target;
            if (!(dNode instanceof AbstractDNode) || !((target = dNode.getTarget()) instanceof ExchangeItem)) continue;
            candidateExchangeItemElements.addAll((Collection<EObject>)((ExchangeItem)target).getOwnedElements());
        }
        return candidateExchangeItemElements;
    }

    public EObject showHideCDBExchangeItems(EObject elementView, List<EObject> selectedExchangeItems) {
        HashMap<ExchangeItem, AbstractDNode> existingExchangeItems = new HashMap<ExchangeItem, AbstractDNode>();
        for (AbstractDNode aNode : DiagramServices.getDiagramServices().getAllNodesAndNodeListElements(elementView)) {
            if (!(aNode.getTarget() instanceof ExchangeItem)) continue;
            existingExchangeItems.put((ExchangeItem)aNode.getTarget(), aNode);
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(elementView);
        for (Map.Entry me : existingExchangeItems.entrySet()) {
            if (selectedExchangeItems.contains(me.getKey())) continue;
            DiagramServices.getDiagramServices().removeAbstractDNodeView((AbstractDNode)me.getValue());
        }
        for (EObject aType : selectedExchangeItems) {
            if (existingExchangeItems.containsKey(aType)) continue;
            NodeMapping mapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "DT_ExchangeItem");
            DiagramServices.getDiagramServices().createNode(mapping, aType, (DragAndDropTarget)diagram, diagram);
        }
        return elementView;
    }

    public String getCommunicationLinkLabel(EObject context) {
        String result = "";
        if (context != null && context instanceof CommunicationLink) {
            CommunicationLink cl = (CommunicationLink)context;
            CommunicationLinkKind kind = cl.getKind();
            CommunicationLinkProtocol protocol = cl.getProtocol();
            result = kind != null ? kind.getName() : "<undefined>";
            if (protocol != null && protocol != CommunicationLinkProtocol.UNSET && protocol != CommunicationLinkProtocol.UNICAST && protocol != CommunicationLinkProtocol.SYNCHRONOUS && protocol != CommunicationLinkProtocol.READ) {
                result = String.valueOf(result) + " / " + protocol.getName();
            }
        }
        return result;
    }

    public String getOperationLabel(EObject exchangeItemAllocation, EObject view) {
        String result = "";
        if (exchangeItemAllocation != null && exchangeItemAllocation instanceof ExchangeItemAllocation && view != null && view instanceof DSemanticDecorator) {
            ExchangeItemAllocation allocation = (ExchangeItemAllocation)exchangeItemAllocation;
            DDiagram diagram = CapellaServices.getService().getDiagramContainer(view);
            if (diagram != null) {
                EList activatedFilters = diagram.getActivatedFilters();
                boolean allParameterHide = false;
                boolean onlyOperationParameterHide = false;
                for (FilterDescription filterDescription : activatedFilters) {
                    if (filterDescription != null && filterDescription.getName().equalsIgnoreCase("Hide Exchange Items details in Interfaces")) {
                        allParameterHide = true;
                    }
                    if (filterDescription == null || !filterDescription.getName().equalsIgnoreCase("Hide Operation parameters in Interfaces")) continue;
                    onlyOperationParameterHide = true;
                }
                if (allParameterHide) {
                    result = this.getAllocatedElementName(allocation);
                } else if (!allParameterHide && onlyOperationParameterHide) {
                    String itemName;
                    ExchangeItem item;
                    ExchangeMechanism exchangeMechanism;
                    ExchangeItem allocatedItem = allocation.getAllocatedItem();
                    result = allocatedItem instanceof ExchangeItem ? ((exchangeMechanism = (item = allocatedItem).getExchangeMechanism()) != null && exchangeMechanism.equals((Object)ExchangeMechanism.OPERATION) ? (itemName = item.getName()) : this.computeLabel(allocation)) : this.computeLabel(allocation);
                } else if (allParameterHide && onlyOperationParameterHide) {
                    result = this.getAllocatedElementName(allocation);
                } else if (!onlyOperationParameterHide && !allParameterHide) {
                    result = this.computeLabel(allocation);
                }
            }
        }
        return result;
    }

    private String getAllocatedElementName(ExchangeItemAllocation operation) {
        String result = "";
        ExchangeItem allocatedItem = operation.getAllocatedItem();
        if (allocatedItem != null) {
            result = allocatedItem.getName();
        }
        return result;
    }

    public boolean hasExchangeItemAllocationLink(DDiagramElement context) {
        if (context != null) {
            EObject eiTarget = context.getTarget();
            if (eiTarget instanceof ExchangeItem && context instanceof DNode) {
                DNode node = (DNode)context;
                EList incomingEdges = node.getIncomingEdges();
                for (DEdge edge : incomingEdges) {
                    ExchangeItemAllocation eia;
                    ExchangeItem allocatedItem;
                    EObject target = edge.getTarget();
                    if (!(target instanceof ExchangeItemAllocation) || (allocatedItem = (eia = (ExchangeItemAllocation)target).getAllocatedItem()) == null || !allocatedItem.equals(eiTarget)) continue;
                    return false;
                }
            } else if (eiTarget instanceof ExchangeItemAllocation) {
                return false;
            }
        }
        return true;
    }

    public String convertToUpperFirst(EObject context, String toConvert) {
        String result = "";
        result = StringHelper.toLowerFirst((String)toConvert);
        return result;
    }

    public boolean hasNonPrimitiveEnds(EObject context) {
        if (context != null && context instanceof Association) {
            Association association = (Association)context;
            Collection<Property> associationProperties = this.getAssociationProperties(association);
            for (Property property : associationProperties) {
                org.polarsys.capella.core.data.information.Collection collection;
                AbstractType abstractType = property.getAbstractType();
                if (abstractType == null || !(abstractType instanceof Class)) continue;
                Class cls = (Class)abstractType;
                if (cls.isIsPrimitive()) {
                    return true;
                }
                if (!(abstractType instanceof org.polarsys.capella.core.data.information.Collection) || !(collection = (org.polarsys.capella.core.data.information.Collection)abstractType).isIsPrimitive()) continue;
                return true;
            }
        }
        return false;
    }

    public String suffixLabelForUnionProperty(EObject context, EObject property) {
        Union union;
        UnionProperty unionPro;
        EObject container;
        String result = "";
        if (property != null && property instanceof UnionProperty && (container = (unionPro = (UnionProperty)property).eContainer()) != null && container instanceof Union && (union = (Union)container).getDiscriminant() != null) {
            result = this.computeUnionPropertyLabelWithQualifier(unionPro);
        }
        return result;
    }

    public List<EObject> getDisplayedAndLinkedExchangeItems(EObject context, EObject ele, List<ExchangeItem> displayedExchangeItem) {
        ArrayList<EObject> result = new ArrayList<EObject>(1);
        ArrayList<ExchangeItem> linkedExchagneItem = new ArrayList<ExchangeItem>(1);
        if (ele != null && ele instanceof Component) {
            Component comp = (Component)ele;
            EList ownedCommunicationLinks = comp.getOwnedCommunicationLinks();
            for (CommunicationLink communicationLink : ownedCommunicationLinks) {
                ExchangeItem exchangeItem = communicationLink.getExchangeItem();
                if (exchangeItem == null) continue;
                linkedExchagneItem.add(exchangeItem);
            }
            for (ExchangeItem displayedExhagneItem : displayedExchangeItem) {
                if (linkedExchagneItem.contains(displayedExhagneItem)) continue;
                result.add((EObject)displayedExhagneItem);
            }
        }
        return result;
    }

    public String getDataTypeLabel(DataType dataType) {
        String result = dataType.getName();
        return result;
    }

    public boolean isHideAssociationLabelEnable(EObject assocation, EObject view) {
        return this.isDiagramFilterEnable(assocation, view, "Hide Association Labels");
    }

    public boolean isHideRoleLabelEnable(EObject assocation, EObject view) {
        return this.isDiagramFilterEnable(assocation, view, "Hide Role Labels");
    }

    public boolean isHideRoleNameEnable(EObject assocation, EObject view) {
        return this.isDiagramFilterEnable(assocation, view, "Hide Role Names");
    }

    public boolean isShowModifiersEnable(EObject obj, EObject view) {
        return this.isDiagramFilterEnable(obj, view, "Show Modifiers");
    }

    public boolean isDiagramFilterEnable(EObject assocation, EObject view, String filterName) {
        DDiagram diagram;
        if (view != null && (diagram = CapellaServices.getService().getDiagramContainer(view)) != null) {
            EList activatedFilters = diagram.getActivatedFilters();
            for (FilterDescription filterDescription : activatedFilters) {
                if (filterDescription == null || !filterDescription.getName().equalsIgnoreCase(filterName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getAssociationBeginRoleLabel(EObject association, EObject context, EObject property, EObject view) {
        StringBuffer beginLabel = new StringBuffer();
        if (association != null && association instanceof Association && property != null && property instanceof Property) {
            Property pro = (Property)property;
            Association asso = (Association)association;
            boolean hideRoleLabelEnable = this.isHideRoleLabelEnable(context, view);
            boolean hideRoleNameEnable = this.isHideRoleNameEnable(context, view);
            String multiplicityToString = this.multiplicityToString((MultiplicityElement)pro);
            beginLabel.append(multiplicityToString);
            if (!multiplicityToString.equals("")) {
                beginLabel.append(' ');
            }
            if (!hideRoleLabelEnable) {
                beginLabel.append(PropertyNamingHelper.prefixPropertyLabel((EObject)pro));
                if (pro.isIsDerived()) {
                    beginLabel.append('/');
                }
                if (!hideRoleNameEnable && (asso.getNavigableMembers().contains((Object)pro) || asso.getNavigableMembers().size() != 1)) {
                    beginLabel.append(pro.getName());
                }
                if (this.isShowModifiersEnable(context, view)) {
                    if (pro.isOrdered()) {
                        beginLabel.append(" {ordered}");
                    }
                    if (!pro.isUnique()) {
                        beginLabel.append(" {nonUnique}");
                    }
                }
            }
        }
        return beginLabel.toString();
    }

    public String getAssociationCenterLabel(EObject association, EObject view) {
        String centerLabel = Character.toString(' ');
        if (association != null && association instanceof Association) {
            Association ass = (Association)association;
            if (!this.isHideAssociationLabelEnable(association, view)) {
                java.lang.System.out.println(ass.getName());
                return ass.getName();
            }
        }
        return centerLabel;
    }

    public String getAssociationEndRoleLabel(EObject association, EObject context, EObject property, EObject view) {
        StringBuffer endLabel = new StringBuffer();
        if (association != null && association instanceof Association && property != null && property instanceof Property) {
            Property pro = (Property)property;
            Association asso = (Association)association;
            boolean hideRoleLabelEnable = this.isHideRoleLabelEnable(context, view);
            boolean hideRoleNameEnable = this.isHideRoleNameEnable(context, view);
            String multiplicityToString = this.multiplicityToString((MultiplicityElement)pro);
            endLabel.append(multiplicityToString);
            if (!multiplicityToString.equals("")) {
                endLabel.append(' ');
            }
            if (!hideRoleLabelEnable) {
                endLabel.append(PropertyNamingHelper.prefixPropertyLabel((EObject)pro));
                if (pro.isIsDerived()) {
                    endLabel.append('/');
                }
                if (!hideRoleNameEnable && (asso.getNavigableMembers().contains((Object)pro) || asso.getNavigableMembers().size() != 1)) {
                    endLabel.append(pro.getName());
                }
                if (this.isShowModifiersEnable(context, view)) {
                    if (pro.isOrdered()) {
                        endLabel.append(" {ordered}");
                    }
                    if (!pro.isUnique()) {
                        endLabel.append(" {nonUnique}");
                    }
                }
            }
        }
        return endLabel.toString();
    }

    public String getDatavalueLabel(EObject context) {
        String result = "";
        result = CapellaServices.getService().getEObjectLabelProviderHelper(context);
        return result;
    }

    public List<Interface> getAvailableInterfacesFromComponentToInsert(EObject context) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        Component component = (Component)((DSemanticDecorator)context).getTarget();
        result.addAll(ComponentExt.getAllImplementedAndProvidedInterfaces((Component)component));
        result.addAll(ComponentExt.getAllUsedAndRequiredInterfaces((Component)component));
        return result;
    }

    private void createEdgeViewWithTargetViewIfNeeded(EObject sourceView, DDiagram diagram, EObject link) {
        DiagramServices diagramServices = DiagramServices.getDiagramServices();
        if (!diagramServices.isOnDiagram(diagram, link)) {
            EObject targetElement = InterfaceExt.getTargetElementFromLink((EObject)link);
            AbstractDNode targetVeiw = null;
            if (targetElement != null && diagramServices.isOnDiagram(diagram, targetElement)) {
                EObject diagramElement = diagramServices.getDiagramElement(diagram, targetElement);
                if (diagramElement != null && diagramElement instanceof AbstractDNode) {
                    targetVeiw = (AbstractDNode)diagramElement;
                }
            } else {
                AbstractNodeMapping mapping = this.getTargetMappingOfGivenEdgeFromGivenDiagram(diagram, targetElement);
                if (mapping != null) {
                    targetVeiw = diagramServices.createAbstractDNodeContainer(mapping, targetElement, (DragAndDropTarget)diagram, diagram);
                }
            }
            if (targetVeiw != null && sourceView instanceof EdgeTarget && targetVeiw instanceof EdgeTarget) {
                List<EdgeMapping> edgeMappings = this.getEdgeMappingFromGivenDiagram(link, diagram, false, false);
                for (EdgeMapping edgeMapping : edgeMappings) {
                    diagramServices.createEdge(edgeMapping, (EdgeTarget)sourceView, (EdgeTarget)targetVeiw, link);
                }
            }
        }
    }

    private boolean isValidActualMapping(DEdge representation, List<String> mappingToCheck) {
        String mappingName;
        IEdgeMapping actualMapping = representation.getActualMapping();
        return actualMapping != null && actualMapping instanceof EdgeMapping && mappingToCheck.contains(mappingName = ((EdgeMapping)actualMapping).getName());
    }

    public List<Interface> getExistingInterfacesFromDiagram(EObject context) {
        List<Interface> available = this.getAvailableInterfacesFromComponentToInsert(context);
        ArrayList<Interface> result = new ArrayList<Interface>();
        if (context instanceof AbstractDNode) {
            AbstractDNode currentContainer = (AbstractDNode)context;
            DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)currentContainer);
            for (DRepresentationElement aNode : currentDiagram.getOwnedRepresentationElements()) {
                if (!(aNode.getTarget() instanceof Interface) || !available.contains(aNode.getTarget())) continue;
                result.add((Interface)aNode.getTarget());
            }
        }
        return result;
    }

    public List<CapellaElement> getAvailableLinksForCRBDiagram(EObject context) {
        AbstractActor element;
        EList ownedGeneralizations;
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        EObject target = ((DSemanticDecorator)context).getTarget();
        if (target instanceof CapabilityRealization) {
            EList superAbstractCapabilities;
            EList includesCapabilities;
            EList extendedCapabilities;
            EList ownedActorCapabilityRealizations;
            CapabilityRealization element2 = (CapabilityRealization)target;
            EList systemCapRealInvols = element2.getOwnedSystemComponentCapabilityRealizations();
            if (!systemCapRealInvols.isEmpty()) {
                result.addAll((Collection<CapellaElement>)systemCapRealInvols);
            }
            if (!(ownedActorCapabilityRealizations = element2.getOwnedActorCapabilityRealizations()).isEmpty()) {
                result.addAll((Collection<CapellaElement>)ownedActorCapabilityRealizations);
            }
            if (!(extendedCapabilities = element2.getExtendedAbstractCapabilities()).isEmpty()) {
                for (AbstractCapability abstractCapability : extendedCapabilities) {
                    Iterator extending = abstractCapability.getExtending();
                    if (extending.isEmpty()) continue;
                    result.addAll((Collection<CapellaElement>)((Object)extending));
                }
            }
            if (!(includesCapabilities = element2.getIncludedAbstractCapabilities()).isEmpty()) {
                for (AbstractCapability abstractCapability : includesCapabilities) {
                    EList including = abstractCapability.getIncluding();
                    if (including.isEmpty()) continue;
                    result.addAll((Collection<CapellaElement>)including);
                }
            }
            if (!(superAbstractCapabilities = element2.getSuper()).isEmpty()) {
                for (AbstractCapability abstractCapability : superAbstractCapabilities) {
                    EList subGeneralizations = abstractCapability.getSubGeneralizations();
                    if (subGeneralizations.isEmpty()) continue;
                    result.addAll((Collection<CapellaElement>)subGeneralizations);
                }
            }
        } else if (target instanceof AbstractActor && !(ownedGeneralizations = (element = (AbstractActor)target).getOwnedGeneralizations()).isEmpty()) {
            result.addAll((Collection<CapellaElement>)ownedGeneralizations);
        }
        return result;
    }

    public List<CapellaElement> getExistingLinksFromCRBDiagram(EObject sourceView) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        DDiagram diagramContainer = CapellaServices.getService().getDiagramContainer(sourceView);
        EObject sourceTarget = ((DSemanticDecorator)sourceView).getTarget();
        if (sourceTarget != null && diagramContainer != null) {
            List<CapellaElement> availableLinksForCRBDiagram = this.getAvailableLinksForCRBDiagram(sourceView);
            if (sourceTarget instanceof CapabilityRealization || sourceTarget instanceof AbstractActor) {
                for (CapellaElement capellaElement : availableLinksForCRBDiagram) {
                    if (!DiagramServices.getDiagramServices().isOnDiagram(diagramContainer, (EObject)capellaElement)) continue;
                    result.add(capellaElement);
                }
            }
        }
        return result;
    }

    @Deprecated
    public void showHideRelationShipFromCRB(EObject sourceView, List<EObject> selectedElements) {
        this.showHideCRBRelationships(sourceView, selectedElements);
    }

    public void showHideCRBRelationships(EObject sourceView, List<EObject> selectedElements) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(sourceView);
        DiagramServices diagramServices = DiagramServices.getDiagramServices();
        EObject sourceTarget = ((DSemanticDecorator)sourceView).getTarget();
        if (diagram == null) {
            return;
        }
        if (!diagram.isSynchronized()) {
            List<CapellaElement> existingElements = this.getExistingLinksFromCRBDiagram(sourceView);
            if (selectedElements != null) {
                existingElements.removeAll(selectedElements);
            }
            ArrayList<DEdge> edges = new ArrayList<DEdge>();
            if (sourceTarget instanceof CapabilityRealization || sourceTarget instanceof AbstractActor) {
                for (DEdge representation : diagram.getEdges()) {
                    EObject target = representation.getTarget();
                    EdgeTarget sourceNode = representation.getSourceNode();
                    ArrayList<String> mappingCheckList = new ArrayList<String>();
                    mappingCheckList.add("CRB Involvement");
                    mappingCheckList.add("CRB Cap Realization Extends");
                    mappingCheckList.add("CRB Cap Realization Include");
                    mappingCheckList.add("CRB Cap Generalization");
                    mappingCheckList.add("CRB Actor Generalization");
                    if (sourceNode == null || !sourceNode.equals(sourceView) || target == null || !existingElements.contains(target) || !this.isValidActualMapping(representation, mappingCheckList)) continue;
                    edges.add(representation);
                }
            }
            for (DEdge dEdge : edges) {
                diagramServices.removeEdgeView(dEdge);
            }
        }
        if (selectedElements != null) {
            for (EObject selectedElement : selectedElements) {
                if (!(selectedElement instanceof SystemComponentCapabilityRealizationInvolvement) && !(selectedElement instanceof ActorCapabilityRealizationInvolvement) && !(selectedElement instanceof AbstractCapabilityExtend) && !(selectedElement instanceof AbstractCapabilityInclude) && !(selectedElement instanceof AbstractCapabilityGeneralization) && !(selectedElement instanceof Generalization)) continue;
                this.createEdgeViewWithTargetViewIfNeeded(sourceView, diagram, selectedElement);
            }
        }
    }

    private AbstractNodeMapping getTargetMappingOfGivenEdgeFromGivenDiagram(DDiagram diagram, EObject targetElement) {
        ContainerMapping acturalMapping = null;
        if (diagram == null || targetElement == null) {
            return acturalMapping;
        }
        DiagramServices diagramServices = DiagramServices.getDiagramServices();
        if (diagram.getDescription().getName().equalsIgnoreCase("Capability Realization Blank")) {
            if (targetElement instanceof AbstractActor || targetElement instanceof Component) {
                acturalMapping = diagramServices.getContainerMapping(diagram, "CRB Component");
            } else if (targetElement instanceof CapabilityRealization) {
                acturalMapping = diagramServices.getNodeMapping(diagram, "CRB CapabilityRealization");
            }
        } else if (diagram.getDescription().getName().equalsIgnoreCase("Interfaces Diagram Blank") && targetElement instanceof Interface) {
            acturalMapping = diagramServices.getContainerMapping(diagram, "IDB_Interface");
        }
        return acturalMapping;
    }

    private List<EdgeMapping> getEdgeMappingFromGivenDiagram(EObject element, DDiagram diagram, boolean providedEdge, boolean requiredEdge) {
        ArrayList<EdgeMapping> result = new ArrayList<EdgeMapping>();
        if (element == null || diagram == null) {
            return result;
        }
        if (diagram.getDescription().getName().equalsIgnoreCase("Capability Realization Blank")) {
            if (element instanceof SystemComponentCapabilityRealizationInvolvement || element instanceof ActorCapabilityRealizationInvolvement) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "CRB Involvement"));
            } else if (element instanceof AbstractCapabilityExtend) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "CRB Cap Realization Extends"));
            } else if (element instanceof AbstractCapabilityInclude) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "CRB Cap Realization Include"));
            } else if (element instanceof AbstractCapabilityGeneralization) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "CRB Cap Generalization"));
            } else if (element instanceof Generalization) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "CRB Actor Generalization"));
            }
        } else if (diagram.getDescription().getName().equalsIgnoreCase("Interfaces Diagram Blank")) {
            if (element instanceof InterfaceImplementation) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "IDB_ImplementInterface"));
            } else if (element instanceof InterfaceUse) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "IDB_UseInterface"));
            } else if (element instanceof ComponentPort && providedEdge && !requiredEdge) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "IDB_PinProvidedInterface"));
            } else if (element instanceof ComponentPort && requiredEdge && !providedEdge) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "IDB_PinRequiredInterface"));
            } else if (element instanceof ComponentPort && requiredEdge && providedEdge) {
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "IDB_PinProvidedInterface"));
                result.add(DiagramServices.getDiagramServices().getEdgeMapping(diagram, "IDB_PinRequiredInterface"));
            }
        }
        return result;
    }

    public void showCDBContextualElements(DDiagram diagram, Collection<EObject> contextualElements) {
        HashSet<EObject> contextualTypes = new HashSet<EObject>();
        HashSet<EObject> contextualInterfaces = new HashSet<EObject>();
        HashSet<EObject> contextualExchangeItems = new HashSet<EObject>();
        HashSet<EObject> contextualRelationships = new HashSet<EObject>();
        DDiagramContents content = new DDiagramContents(diagram);
        for (EObject contextualElement : contextualElements) {
            if (contextualElement instanceof org.polarsys.capella.core.data.information.Collection) {
                contextualTypes.add(contextualElement);
            } else if (contextualElement instanceof Class) {
                contextualTypes.add(contextualElement);
            } else if (contextualElement instanceof DataType) {
                contextualTypes.add(contextualElement);
            } else if (contextualElement instanceof Interface) {
                contextualInterfaces.add(contextualElement);
            } else if (contextualElement instanceof ExchangeItem) {
                contextualExchangeItems.add(contextualElement);
                contextualRelationships.addAll((Collection<EObject>)((ExchangeItem)contextualElement).getOwnedElements());
            }
            if (contextualElement instanceof Classifier) {
                contextualRelationships.addAll(CapellaServices.getService().getRelatedAssociations((Classifier)contextualElement));
            }
            if (!(contextualElement instanceof GeneralizableElement)) continue;
            contextualRelationships.addAll((Collection<EObject>)((GeneralizableElement)contextualElement).getSuperGeneralizations());
        }
        for (EObject object : contextualTypes) {
            this.showCDBType(object, content);
        }
        for (EObject object : contextualInterfaces) {
            this.showCDBInterface(object, content);
        }
        for (EObject object : contextualRelationships) {
            this.showCDBRelationship(object, content);
        }
    }

    public String getFullPathLableConsiderViewContentment(AbstractNamedElement context, EObject view) {
        List<Object> resultList = new ArrayList(0);
        if (this.isDiagramFilterEnable((EObject)context, view, "Show Full Path")) {
            DDiagramElement dElement;
            EObject dElementContainer;
            if (view instanceof DDiagramElement && (dElementContainer = (dElement = (DDiagramElement)view).eContainer()) != null) {
                DDiagramElement dElelementContinerTyped;
                EObject dElelementContinerTarget;
                if (dElementContainer instanceof DDiagram) {
                    resultList = this.getFullNameUntilGivenElement(context, null, false);
                } else if (dElementContainer instanceof DDiagramElement && (dElelementContinerTarget = (dElelementContinerTyped = (DDiagramElement)dElementContainer).getTarget()) != null && dElelementContinerTarget instanceof AbstractNamedElement) {
                    resultList = this.getFullNameUntilGivenElement(context, dElelementContinerTarget, true);
                }
            }
        } else {
            return CapellaServices.getService().getEObjectLabelProviderHelper((EObject)context);
        }
        Collections.reverse(resultList);
        StringBuilder result = new StringBuilder();
        Iterator itResultList = resultList.iterator();
        while (itResultList.hasNext()) {
            result.append((String)itResultList.next());
            if (!itResultList.hasNext()) continue;
            result.append("::");
        }
        return result.toString();
    }

    private List<String> getFullNameUntilGivenElement(AbstractNamedElement context, EObject dElelementContinerTarget, boolean checkUntileGivenElement) {
        ArrayList<String> resultList = new ArrayList<String>(0);
        if (checkUntileGivenElement && (dElelementContinerTarget == null || context.equals(dElelementContinerTarget))) {
            return resultList;
        }
        if (this.isRoot(context)) {
            resultList.add(this.getSymbol(context));
        } else {
            resultList.add(CapellaServices.getService().getEObjectLabelProviderHelper((EObject)context));
        }
        if (context instanceof ComponentArchitecture || context instanceof OperationalAnalysis) {
            return resultList;
        }
        EObject eContainer = context.eContainer();
        if (eContainer != null && eContainer instanceof AbstractNamedElement) {
            resultList.addAll(this.getFullNameUntilGivenElement((AbstractNamedElement)eContainer, dElelementContinerTarget, checkUntileGivenElement));
        }
        return resultList;
    }

    private String getSymbol(AbstractNamedElement context) {
        if (context instanceof Entity) {
            return "[E]";
        }
        if (context instanceof OperationalContext) {
            return "[OC]";
        }
        if (context instanceof System) {
            return "[S]";
        }
        if (context instanceof SystemContext) {
            return "[SC]";
        }
        if (context instanceof LogicalComponent) {
            return "[LS]";
        }
        if (context instanceof LogicalContext) {
            return "[LC]";
        }
        if (context instanceof PhysicalComponent) {
            return "[PS]";
        }
        if (context instanceof PhysicalContext) {
            return "[PC]";
        }
        if (context instanceof ConfigurationItem) {
            return "[CI]";
        }
        if (context instanceof EPBSContext) {
            return "[EPBSC]";
        }
        if (context instanceof OperationalAnalysis) {
            return "[OA]";
        }
        if (context instanceof SystemAnalysis) {
            return "[SA]";
        }
        if (context instanceof LogicalArchitecture) {
            return "[LA]";
        }
        if (context instanceof PhysicalArchitecture) {
            return "[PA]";
        }
        if (context instanceof EPBSArchitecture) {
            return "[EPBSA]";
        }
        if (context instanceof EntityPkg) {
            return "[EPkg]";
        }
        if (context instanceof ActorPkg) {
            return "[APkg]";
        }
        if (context instanceof LogicalActorPkg) {
            return "[LAPkg]";
        }
        if (context instanceof PhysicalActorPkg) {
            return "[PAPkg]";
        }
        if (context instanceof LogicalComponentPkg) {
            return "[PAPkg]";
        }
        if (context instanceof PhysicalComponentPkg) {
            return "[PAPkg]";
        }
        if (context instanceof ConfigurationItemPkg) {
            return "[PAPkg]";
        }
        return null;
    }

    private boolean isRoot(AbstractNamedElement context) {
        EObject eContainer;
        if (context instanceof System) {
            return true;
        }
        if (context instanceof LogicalComponent || context instanceof PhysicalComponent || context instanceof ConfigurationItem) {
            return ComponentExt.isComponentRoot((EObject)context);
        }
        if (context instanceof ComponentContext || context instanceof ComponentArchitecture || context instanceof OperationalAnalysis) {
            return true;
        }
        return !(!(context instanceof ActorPkg) && !(context instanceof AbstractFunctionalStructure) && !(context instanceof ConfigurationItemPkg) || (eContainer = context.eContainer()) == null || !(eContainer instanceof ComponentArchitecture) && !(eContainer instanceof OperationalAnalysis));
    }

    public boolean isShowFullPathInClassDiagramEnable(EObject assocation, EObject view) {
        return this.isDiagramFilterEnable(assocation, view, "Show Full Path");
    }

    public List<DataValue> getAvailableDataValuesToInsert(EObject elementView) {
        ArrayList<DataValue> result;
        block10: {
            block9: {
                ArrayList<DataPkg> listPackages = new ArrayList<DataPkg>(1);
                result = new ArrayList<DataValue>(1);
                DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer(elementView);
                if (elementView.equals(diagram)) {
                    EObject diagramTarget = diagram.getTarget();
                    return QueryInterpretor.executeQuery((String)"GetDataValuesForLib", (Object)diagramTarget);
                }
                if (!(elementView instanceof DNodeContainer)) break block9;
                EObject containerTarget = ((DNodeContainer)elementView).getTarget();
                if (!(containerTarget instanceof DataPkg)) break block10;
                DataPkg currentPkg = (DataPkg)containerTarget;
                listPackages.add(currentPkg);
                listPackages.addAll(DataPkgExt.getRecursiveSubDataPkgs((DataPkg)currentPkg));
                result.addAll(DataPkgExt.getDataValues(listPackages));
                break block10;
            }
            if (elementView instanceof DNodeList) {
                EObject nodeListTarget = ((DNodeList)elementView).getTarget();
                if (nodeListTarget instanceof Class) {
                    Class currentClass = (Class)nodeListTarget;
                    Iterator itDataValues = currentClass.getOwnedDataValues().iterator();
                    while (itDataValues.hasNext()) {
                        result.add((DataValue)itDataValues.next());
                    }
                } else if (nodeListTarget instanceof DataType) {
                    DataType currentDataType = (DataType)nodeListTarget;
                    result.addAll(DataTypeExt.getAllDataValuesFromDataType((DataType)currentDataType));
                } else if (nodeListTarget instanceof org.polarsys.capella.core.data.information.Collection) {
                    org.polarsys.capella.core.data.information.Collection currentClass = (org.polarsys.capella.core.data.information.Collection)nodeListTarget;
                    Iterator itDataValues = currentClass.getOwnedDataValues().iterator();
                    while (itDataValues.hasNext()) {
                        result.add((DataValue)itDataValues.next());
                    }
                }
            }
        }
        return result;
    }

    public List<DataValue> getInitialSelectionOfShowHideDataValues(EObject elementView) {
        ArrayList<DataValue> result;
        block5: {
            block4: {
                EObject target;
                EList diagramElements;
                result = new ArrayList<DataValue>(1);
                DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer(elementView);
                if (elementView.equals(diagram)) {
                    diagramElements = diagram.getNodes();
                    for (DNode dDiagramElement : diagramElements) {
                        target = dDiagramElement.getTarget();
                        if (target == null || !(target instanceof DataValue)) continue;
                        result.add((DataValue)target);
                    }
                }
                if (!(elementView instanceof DNodeContainer)) break block4;
                diagramElements = ((DNodeContainer)elementView).getNodes();
                for (DNode dDiagramElement : diagramElements) {
                    target = dDiagramElement.getTarget();
                    if (target == null || !(target instanceof DataValue)) continue;
                    result.add((DataValue)target);
                }
                break block5;
            }
            if (!(elementView instanceof DNodeList)) break block5;
            DNodeList nodeList = (DNodeList)elementView;
            EList ownedElements = nodeList.getOwnedElements();
            for (DNodeListElement dDiagramElement : ownedElements) {
                EObject target = dDiagramElement.getTarget();
                if (target == null || !(target instanceof DataValue)) continue;
                result.add((DataValue)target);
            }
        }
        return result;
    }

    public static Object getEILabel(AbstractExchangeItem ei, boolean showExchangeItemsParameters) {
        return ExchangeItemExt.getEILabel((AbstractExchangeItem)ei, (boolean)showExchangeItemsParameters);
    }

    boolean isPrimitiveDependency(AbstractDependenciesPkg src, AbstractDependenciesPkg tar) {
        if (src instanceof DataPkg) {
            return DataPkgExt.isPrimitiveDependency((DataPkg)((DataPkg)src), (AbstractDependenciesPkg)tar);
        }
        return InterfacePkgExt.isPrimitiveDependency((InterfacePkg)((InterfacePkg)src), (AbstractDependenciesPkg)tar);
    }

    public Collection<AbstractDependenciesPkg> getDependentPackages2(AbstractDependenciesPkg pkg, DDiagram diagram) {
        HashSet<AbstractDependenciesPkg> depPkgs = new HashSet<AbstractDependenciesPkg>();
        for (AbstractDependenciesPkg depPkg : AbstractDependenciesPkgExt.getDependencies2((AbstractDependenciesPkg)pkg)) {
            if (!this.shouldDisplayed(pkg, depPkg, diagram)) continue;
            depPkgs.add(depPkg);
        }
        return depPkgs;
    }

    public boolean shouldDisplayed(AbstractDependenciesPkg src, AbstractDependenciesPkg tar, DDiagram diagram) {
        if (this.isPrimitiveDependency(src, tar)) {
            return true;
        }
        ArrayList src_subPkgs = new ArrayList();
        ArrayList tar_subPkgs = new ArrayList();
        if (src instanceof DataPkg) {
            src_subPkgs.addAll(((DataPkg)src).getOwnedDataPkgs());
        } else {
            src_subPkgs.addAll(((InterfacePkg)src).getOwnedInterfacePkgs());
        }
        if (tar instanceof DataPkg) {
            tar_subPkgs.addAll(((DataPkg)tar).getOwnedDataPkgs());
        } else {
            tar_subPkgs.addAll(((InterfacePkg)tar).getOwnedInterfacePkgs());
        }
        if (src_subPkgs.size() == 0) {
            ArrayList<DependencyPair> depPairs = new ArrayList<DependencyPair>();
            Collection depPkgs = AbstractDependenciesPkgExt.getDependencies2((AbstractDependenciesPkg)src);
            for (AbstractDependenciesPkg depPkg : depPkgs) {
                if (!tar_subPkgs.contains(depPkg)) continue;
                depPairs.add(new DependencyPair(src, depPkg));
            }
            for (DependencyPair dep : depPairs) {
                if (!this.shouldDisplayed(dep.src, dep.tar, diagram) || this.isDisplayed(dep.src, dep.tar, diagram)) continue;
                return true;
            }
        } else if (tar_subPkgs.size() == 0) {
            ArrayList<DependencyPair> depPairs = new ArrayList<DependencyPair>();
            for (AbstractDependenciesPkg pkg : src_subPkgs) {
                Collection depPkgs = AbstractDependenciesPkgExt.getDependencies2((AbstractDependenciesPkg)pkg);
                for (AbstractDependenciesPkg depPkg : depPkgs) {
                    if (depPkg != tar) continue;
                    depPairs.add(new DependencyPair(pkg, tar));
                }
            }
            for (DependencyPair dep : depPairs) {
                if (!this.shouldDisplayed(dep.src, dep.tar, diagram) || this.isDisplayed(dep.src, dep.tar, diagram)) continue;
                return true;
            }
        } else {
            ArrayList<DependencyPair> depPairs = new ArrayList<DependencyPair>();
            for (AbstractDependenciesPkg pkg : src_subPkgs) {
                Collection depPkgs = AbstractDependenciesPkgExt.getDependencies2((AbstractDependenciesPkg)pkg);
                for (AbstractDependenciesPkg depPkg : depPkgs) {
                    if (!tar_subPkgs.contains(depPkg)) continue;
                    depPairs.add(new DependencyPair(pkg, depPkg));
                }
            }
            for (DependencyPair dep : depPairs) {
                if (!this.shouldDisplayed(dep.src, tar, diagram) || this.isDisplayed(dep.src, tar, diagram) || !this.shouldDisplayed(src, dep.tar, diagram) || this.isDisplayed(src, dep.tar, diagram)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDisplayed(AbstractDependenciesPkg src, AbstractDependenciesPkg tar, DDiagram diagram) {
        EObject srcPkg = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)src);
        EObject tarPkg = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)tar);
        return srcPkg != null && tarPkg != null;
    }

    public String modifiersSuffix(EObject context, EObject view) {
        String str = "";
        if (this.isShowModifiersEnable(context, view)) {
            if (context instanceof Property) {
                Property prop = (Property)context;
                if (prop.isOrdered()) {
                    str = String.valueOf(str) + " {ordered}";
                }
                if (!prop.isUnique()) {
                    str = String.valueOf(str) + " {nonUnique}";
                }
            }
            if (context instanceof ExchangeItemElement) {
                ExchangeItemElement eie = (ExchangeItemElement)context;
                if (eie.isOrdered()) {
                    str = String.valueOf(str) + " {ordered}";
                }
                if (!eie.isUnique()) {
                    str = String.valueOf(str) + " {nonUnique}";
                }
                if (!eie.isComposite()) {
                    str = String.valueOf(str) + " {nonComposite}";
                }
            }
        }
        return str;
    }

    class DependencyPair {
        final AbstractDependenciesPkg src;
        final AbstractDependenciesPkg tar;

        public DependencyPair(AbstractDependenciesPkg src, AbstractDependenciesPkg tar) {
            this.src = src;
            this.tar = tar;
        }

        public boolean equals(Object obj) {
            return obj instanceof DependencyPair && this.src == ((DependencyPair)obj).src && this.tar == ((DependencyPair)obj).tar;
        }

        public int hashCode() {
            int result = 17;
            result = this.src.hashCode() * result + this.tar.hashCode();
            return result;
        }
    }
}

