/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorCapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.sirius.analysis.CsServices;

public class TableCapabilitiesServices {
    public Collection<AbstractCapability> getAllCapabilities(BlockArchitecture architecture) {
        ArrayList<AbstractCapability> capabilities = new ArrayList<AbstractCapability>();
        if (architecture != null && architecture.getOwnedAbstractCapabilityPkg() != null) {
            this.getAllCapabilities(architecture.getOwnedAbstractCapabilityPkg(), capabilities);
        }
        return capabilities;
    }

    public Collection<AbstractCapability> isUsedInCapabilities(EObject exchangeItem) {
        ArrayList<AbstractCapability> capabilitiesUsed = new ArrayList<AbstractCapability>();
        ExchangeItemAllocation exchangeItem_p = (ExchangeItemAllocation)exchangeItem;
        for (AbstractCapability capability : this.getRelatedCapabilities(exchangeItem_p)) {
            for (Scenario scenario : capability.getOwnedScenarios()) {
                if (!this.isUsedInScenario(scenario, (AbstractEventOperation)exchangeItem_p)) continue;
                capabilitiesUsed.add(capability);
            }
        }
        return capabilitiesUsed;
    }

    protected List<AbstractCapability> getRelatedCapabilities(ExchangeItemAllocation exchangeItem_p) {
        CsServices cciiServices = CsServices.getService();
        ArrayList<AbstractCapability> capabilities = new ArrayList<AbstractCapability>();
        try {
            HashSet components = new HashSet();
            Interface inter = exchangeItem_p.getAllocatingInterface();
            if (inter != null) {
                components.addAll(InterfaceExt.getRelatedComponents((Interface)inter));
            }
            for (Component component : components) {
                if (component instanceof Actor) {
                    capabilities.addAll((Collection<AbstractCapability>)((Actor)component).getContributedCapabilities());
                    continue;
                }
                this.getAllCapabilities(component.getOwnedAbstractCapabilityPkg(), capabilities);
                for (EObject parent : cciiServices.getParentContainers((EObject)component)) {
                    if (parent instanceof Component) {
                        this.getAllCapabilities(((Component)parent).getOwnedAbstractCapabilityPkg(), capabilities);
                        continue;
                    }
                    if (!(parent instanceof BlockArchitecture)) continue;
                    this.getAllCapabilities(((BlockArchitecture)parent).getOwnedAbstractCapabilityPkg(), capabilities);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return capabilities;
    }

    protected boolean isUsedInScenario(Scenario scenario, AbstractEventOperation operation) {
        for (SequenceMessage message : scenario.getOwnedMessages()) {
            if (!this.isAssociatedToOperation(message.getSendingEnd(), operation) && !this.isAssociatedToOperation(message.getReceivingEnd(), operation)) continue;
            return true;
        }
        return false;
    }

    public Collection<Scenario> isUsedInScenarios(ExchangeItemAllocation operation) {
        ArrayList<Scenario> scenarioUsed = new ArrayList<Scenario>();
        for (AbstractCapability capability : this.getRelatedCapabilities(operation)) {
            for (Scenario scenario : capability.getOwnedScenarios()) {
                if (!this.isUsedInScenario(scenario, (AbstractEventOperation)operation)) continue;
                scenarioUsed.add(scenario);
            }
        }
        return scenarioUsed;
    }

    protected boolean isAssociatedToOperation(MessageEnd end, AbstractEventOperation operation) {
        if (end != null && end.getEvent() != null && operation != null) {
            AbstractEventOperation operationEvent = null;
            if (end.getEvent() instanceof EventSentOperation) {
                operationEvent = ((EventSentOperation)end.getEvent()).getOperation();
            } else if (end.getEvent() instanceof EventReceiptOperation) {
                operationEvent = ((EventReceiptOperation)end.getEvent()).getOperation();
            }
            if (operationEvent != null && operation.equals(operationEvent)) {
                return true;
            }
        }
        return false;
    }

    public Collection<Interface> getAllInterfacesInvolved(BlockArchitecture system) {
        Collection<AbstractCapability> capabilities = this.getAllCapabilities(system);
        ArrayList<Interface> involvedInterfaces = new ArrayList<Interface>();
        for (AbstractCapability capability : capabilities) {
            this.addInvolvedInterfaces(capability, involvedInterfaces);
        }
        return involvedInterfaces;
    }

    public Collection<Interface> getAllInterfacesInvolved(AbstractCapability capability) {
        ArrayList<Interface> involvedInterfaces = new ArrayList<Interface>();
        this.addInvolvedInterfaces(capability, involvedInterfaces);
        return involvedInterfaces;
    }

    protected void addInvolvedInterfaces(AbstractCapability abstractCapability, Collection<Interface> interfaces) {
        ArrayList<ActorCapabilityInvolvement> involvements = new ArrayList<ActorCapabilityInvolvement>();
        CsServices se = CsServices.getService();
        if (abstractCapability instanceof Capability) {
            Capability capability = (Capability)abstractCapability;
            for (ActorCapabilityInvolvement i : capability.getOwnedActorCapabilityInvolvements()) {
                if (i == null) continue;
                involvements.add(i);
            }
        } else if (abstractCapability instanceof CapabilityRealization) {
            CapabilityRealization capabilityRealization = (CapabilityRealization)abstractCapability;
            for (ActorCapabilityInvolvement i : capabilityRealization.getOwnedActorCapabilityRealizations()) {
                if (i == null) continue;
                involvements.add(i);
            }
            for (ActorCapabilityInvolvement i : capabilityRealization.getOwnedSystemComponentCapabilityRealizations()) {
                if (i == null) continue;
                involvements.add(i);
            }
        }
        if (involvements != null) {
            for (Involvement involvement : involvements) {
                if (involvement.getInvolved() == null || !(involvement.getInvolved() instanceof Component)) continue;
                Component component = (Component)involvement.getInvolved();
                for (Interface itf : se.getAllRelatedInterfaces(component)) {
                    if (interfaces.contains(itf)) continue;
                    interfaces.add(itf);
                }
                if (!(abstractCapability instanceof CapabilityRealization)) continue;
                for (Component subComponent : se.getAllSubUsedComponents(component)) {
                    for (Interface itf : se.getAllRelatedInterfaces(subComponent)) {
                        if (interfaces.contains(itf)) continue;
                        interfaces.add(itf);
                    }
                }
            }
        }
    }

    public Collection<ExchangeItemAllocation> getDefinedExchangeItems(Interface inter) {
        return inter.getOwnedExchangeItemAllocations();
    }

    public void getAllCapabilities(AbstractCapabilityPkg pkg, Collection<AbstractCapability> list) {
        list.addAll(AbstractCapabilityPkgExt.getAllAbstractCapabilities((AbstractCapabilityPkg)pkg));
    }

    public String getScenariosUsingService(AbstractEventOperation operation, AbstractCapability capability) {
        String res = "";
        ArrayList<Scenario> scenariosUsed = new ArrayList<Scenario>();
        for (Scenario scenario : capability.getOwnedScenarios()) {
            if (!this.isUsedInScenario(scenario, operation)) continue;
            scenariosUsed.add(scenario);
        }
        if (scenariosUsed.size() > 0) {
            int i = 0;
            while (i < scenariosUsed.size() - 1) {
                res = String.valueOf(res) + EObjectLabelProviderHelper.getText((EObject)((EObject)scenariosUsed.get(i)));
                res = String.valueOf(res) + ';';
                ++i;
            }
            res = String.valueOf(res) + EObjectLabelProviderHelper.getText((EObject)((EObject)scenariosUsed.get(scenariosUsed.size() - 1)));
        }
        return res;
    }
}

