/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.helpers.modellingcore.utils.HoldingResourceFilter;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.Messages;

public abstract class AbstractRefreshExtension {
    protected boolean isLinkedToUselessTarget(DSemanticDecorator element_p) {
        EObject target = element_p.getTarget();
        return target == null || target.eResource() == null || HoldingResourceFilter.getInstance().isHoldByHoldingResource(target);
    }

    protected List<AbstractNodeMapping> getListOfMappingsToMove(DDiagram diagram_p) {
        return Collections.EMPTY_LIST;
    }

    protected boolean isVisibleInDiagram(DDiagram diagram_p, DDiagramElement anElement) {
        return anElement.isVisible();
    }

    protected void reorderElements(DDiagram diagram_p) {
        this.reorderElements(new DDiagramContents(diagram_p));
    }

    protected void reorderElements(DDiagramContents diagramContent_p) {
        try {
            DDiagram diagram = diagramContent_p.getDDiagram();
            Hashtable<DDiagramElement, DragAndDropTarget> toBeMoved = new Hashtable<DDiagramElement, DragAndDropTarget>();
            List<AbstractNodeMapping> mappingsToMove = this.getListOfMappingsToMove(diagram);
            for (DDiagramElement anElement : diagramContent_p.getDiagramElements()) {
                DragAndDropTarget bestContainer;
                if (!mappingsToMove.contains(anElement.getDiagramElementMapping()) || !this.isReorderable(diagram, anElement) || this.isWellContained(diagram, anElement, (EObject)(bestContainer = diagramContent_p.getBestContainer(anElement)))) continue;
                toBeMoved.put(anElement, bestContainer);
            }
            for (DDiagramElement key : toBeMoved.keySet()) {
                DragAndDropTarget target = (DragAndDropTarget)toBeMoved.get(key);
                if (target == null) continue;
                if (target instanceof DDiagram) {
                    if (((DDiagram)target).getOwnedDiagramElements().contains((Object)key)) continue;
                    ((DDiagram)target).getOwnedDiagramElements().add((Object)key);
                    continue;
                }
                if (!(target instanceof DNodeContainer) || ((DNodeContainer)target).getOwnedDiagramElements().contains((Object)key)) continue;
                ((DNodeContainer)target).getOwnedDiagramElements().add((Object)key);
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnReordering, (Throwable)e);
        }
    }

    protected boolean isWellContained(DDiagram diagram_p, DDiagramElement anElement_p, EObject bestContainer_p) {
        return bestContainer_p.equals(anElement_p.eContainer());
    }

    protected boolean isReorderable(DDiagram diagram_p, DDiagramElement element_p) {
        return element_p != null && (!(element_p instanceof AbstractDNode) || !DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)element_p)) && !this.isLinkedToUselessTarget((DSemanticDecorator)element_p) && this.isVisibleInDiagram(diagram_p, element_p);
    }
}

