/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.data.fa.ComponentExchangeCategory;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.PhysicalServices;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractRefreshExtension;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.Messages;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ComponentArchitectureBlankRefreshExtension
extends AbstractRefreshExtension
implements IRefreshExtension {
    public void beforeRefresh(DDiagram diagram) {
        List contextualElements = ContextualDiagramHelper.getService().getContextualElements((DRepresentation)diagram);
        this.updateTargetDiagram(diagram, !contextualElements.isEmpty());
        DDiagramContents context = FaServices.getFaServices().getDDiagramContents(diagram);
        try {
            CsServices.getService().showABContextualElements(context, contextualElements);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnContextualElements, (Throwable)e);
        }
        try {
            this.reorderElements(diagram);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnReordering, (Throwable)e);
        }
        try {
            this.updateComponentCategories(context);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateComponentCategories, (Throwable)e);
        }
        try {
            this.updatePhysicalCategories(context);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdatePhysicalCategories, (Throwable)e);
        }
        try {
            this.updateFunctionalExchangeCategories(context);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFECategories, (Throwable)e);
        }
        try {
            context.commitDeferredActions();
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnCommitDeferredActions, (Throwable)e);
        }
    }

    protected void updateTargetDiagram(DDiagram diagram, boolean hasContextualElements) {
        if (!"System Architecture Blank".equals(diagram.getDescription().getName())) {
            AbstractType type;
            EObject root = ((DSemanticDecorator)diagram).getTarget();
            if (root instanceof Component) {
                Component rootComponent = (Component)root;
                CsServices.getService().createRepresentingPartIfNone(rootComponent);
                if (!CsServices.getService().isMultipartMode((ModelElement)rootComponent)) {
                    root = (EObject)rootComponent.getRepresentingPartitions().get(0);
                }
            } else if (root instanceof Part && !CsServices.getService().isMultipartMode((ModelElement)((Part)root)) && (type = CsServices.getService().getComponentType((Part)root)) != null && type instanceof Component) {
                ((DSemanticDiagram)diagram).setTarget((EObject)type);
            }
            if (root instanceof ModelElement && !(root instanceof Component) && diagram.getOwnedDiagramElements().size() == 0) {
                ContainerMapping componentMapping;
                if (!CsServices.getService().isMultipartMode((ModelElement)root) && diagram.getDescription().getName().equals("Logical Architecture Blank") && !DiagramServices.getDiagramServices().isOnDiagram(diagram, root) && !hasContextualElements) {
                    componentMapping = FaServices.getFaServices().getMappingABComponent(root, diagram);
                    DiagramServices.getDiagramServices().createContainer(componentMapping, root, (DragAndDropTarget)diagram, diagram);
                } else if (diagram.getDescription().getName().equals("System Architecture Blank") && !DiagramServices.getDiagramServices().isOnDiagram(diagram, root)) {
                    componentMapping = FaServices.getFaServices().getMappingABComponent(root, diagram);
                    DiagramServices.getDiagramServices().createContainer(componentMapping, root, (DragAndDropTarget)diagram, diagram);
                }
            }
        }
    }

    protected void updateComponentCategories(DDiagramContents context) {
        DDiagram diagram = context.getDDiagram();
        if (diagram.isSynchronized()) {
            HashSet<EObject> categories = new HashSet<EObject>();
            DiagramElementMapping edgeMapping = context.getMapping(MappingConstantsHelper.getMappingABComponentCategory(context.getDDiagram()));
            if (edgeMapping != null) {
                for (DDiagramElement element : context.getDiagramElements(edgeMapping)) {
                    if (element.getTarget() == null || !(element.getTarget() instanceof ComponentExchangeCategory)) continue;
                    categories.add(element.getTarget());
                }
                ABServices.getService().switchABComponentCategories(context, (DSemanticDecorator)context.getDDiagram(), categories, false);
            }
        } else {
            ABServices.getService().updateABComponentCategories(context);
        }
    }

    protected void updateFunctionalExchangeCategories(DDiagramContents context) {
        DDiagram diagram = context.getDDiagram();
        if (diagram.isSynchronized()) {
            HashSet<EObject> categories = new HashSet<EObject>();
            DiagramElementMapping edgeMapping = context.getMapping(MappingConstantsHelper.getMappingFunctionalExchangeCategory(context.getDDiagram()));
            if (edgeMapping != null) {
                for (DDiagramElement element : context.getDiagramElements(edgeMapping)) {
                    if (element.getTarget() == null || !(element.getTarget() instanceof ExchangeCategory)) continue;
                    categories.add(element.getTarget());
                }
                FaServices.getFaServices().switchFECategories(context, (DSemanticDecorator)context.getDDiagram(), categories, false);
            }
        } else {
            FaServices.getFaServices().updateFECategories(context);
        }
    }

    protected void updatePhysicalCategories(DDiagramContents context) {
        DDiagram diagram = context.getDDiagram();
        if (diagram.isSynchronized()) {
            HashSet<EObject> categories = new HashSet<EObject>();
            DiagramElementMapping edgeMapping = context.getMapping(MappingConstantsHelper.getMappingABPhysicalCategory(context.getDDiagram()));
            if (edgeMapping != null) {
                for (DDiagramElement element : context.getDiagramElements(edgeMapping)) {
                    if (element.getTarget() == null || !(element.getTarget() instanceof PhysicalLinkCategory)) continue;
                    categories.add(element.getTarget());
                }
                ABServices.getService().switchABPhysicalCategories(context, (DSemanticDecorator)context.getDDiagram(), categories, false);
            }
        } else {
            ABServices.getService().updateABPhysicalCategories(context);
        }
    }

    @Override
    public void reorderElements(DDiagram diagram) {
        AbstractType currentType;
        Part currentPart;
        DDiagramContents content = new DDiagramContents(diagram){

            @Override
            public Collection<EObject> getParents(EObject object, EObject context) {
                LinkedList<EObject> parents = new LinkedList<EObject>();
                if (object instanceof Part && context instanceof DNodeContainer) {
                    EObject contextPart = ((DNodeContainer)context).getTarget();
                    if (CsServices.getService().isDeployed((DNodeContainer)context)) {
                        parents.addAll(PartExt.getDeployingElements((Part)((Part)object)));
                    } else {
                        parents.add(CsServices.getService().getParentContainer(object));
                    }
                    parents.remove(contextPart);
                }
                return parents;
            }
        };
        HashMapSet<AbstractType, DNodeContainer> typeViews = new HashMapSet<AbstractType, DNodeContainer>();
        HashMapSet<Part, DNodeContainer> partViews = new HashMapSet<Part, DNodeContainer>();
        HashSet<DNodeContainer> toBeMoved = new HashSet<DNodeContainer>();
        List<AbstractNodeMapping> mappingsToMove = this.getListOfMappingsToMove(diagram);
        for (AbstractDNode abstractDNode : diagram.getContainers()) {
            if (!mappingsToMove.contains(abstractDNode.getDiagramElementMapping()) || !this.isReorderable(diagram, (DDiagramElement)abstractDNode) || !(abstractDNode instanceof DNodeContainer) || !(abstractDNode.getTarget() instanceof Part)) continue;
            currentPart = (Part)abstractDNode.getTarget();
            currentType = CsServices.getService().getComponentType(currentPart);
            typeViews.put(currentType, (DNodeContainer)abstractDNode);
            partViews.put(currentPart, (DNodeContainer)abstractDNode);
        }
        block1: for (AbstractType abstractType : typeViews.keySet()) {
            currentType = typeViews.get(abstractType).iterator();
            while (currentType.hasNext()) {
                DNodeContainer anElement = (DNodeContainer)currentType.next();
                Part currentPart2 = (Part)anElement.getTarget();
                boolean willBeMoved = false;
                if (anElement.eContainer() != null && anElement.eContainer() instanceof DSemanticDecorator) {
                    DSemanticDecorator containerView = (DSemanticDecorator)anElement.eContainer();
                    EObject actualContainer = containerView.getTarget();
                    EObject actualComponentContainer = CsServices.getService().getComponentType(containerView);
                    if (actualContainer == null) {
                        willBeMoved = true;
                    } else if (containerView instanceof DDiagram && actualComponentContainer != null && actualComponentContainer instanceof Component && typeViews.get(actualComponentContainer).size() > 0) {
                        willBeMoved = true;
                    } else {
                        willBeMoved = true;
                        for (EObject currentParent : content.getParents((EObject)currentPart2, (EObject)anElement)) {
                            if (currentParent == null || !currentParent.equals(actualContainer) && !currentParent.equals(actualComponentContainer)) continue;
                            willBeMoved = false;
                            break;
                        }
                    }
                    if (willBeMoved) {
                        toBeMoved.add(anElement);
                        continue block1;
                    }
                }
                if (willBeMoved) continue block1;
            }
        }
        for (DNodeContainer dNodeContainer : toBeMoved) {
            currentPart = (Part)dNodeContainer.getTarget();
            LinkedList<EObject> parents = new LinkedList<EObject>();
            HashSet<EObject> visitedParents = new HashSet<EObject>();
            boolean toBeDeleted = false;
            boolean isAdded = false;
            parents.addAll(content.getParents((EObject)currentPart, (EObject)dNodeContainer));
            while (!(isAdded || toBeDeleted || parents.isEmpty())) {
                DNodeContainer container;
                Iterator<Object> iterator;
                PartitionableElement parentElement;
                EObject parent = (EObject)parents.removeFirst();
                if (visitedParents.contains(parent)) continue;
                visitedParents.add(parent);
                if (parent instanceof PartitionableElement) {
                    parentElement = (PartitionableElement)parent;
                    if (typeViews.get(parentElement).size() == 1) {
                        iterator = typeViews.get(parentElement).iterator();
                        while (iterator.hasNext()) {
                            container = (DNodeContainer)iterator.next();
                            if (!container.getOwnedDiagramElements().contains((Object)dNodeContainer) && dNodeContainer != container.eContainer()) {
                                container.getOwnedDiagramElements().add((Object)dNodeContainer);
                            }
                            isAdded = true;
                        }
                    } else if (typeViews.get(parentElement).size() > 1) {
                        toBeDeleted = true;
                    }
                    if (isAdded || toBeDeleted) continue;
                    for (Partition partition : parentElement.getRepresentingPartitions()) {
                        if (!(partition instanceof Part)) continue;
                        parents.addAll(content.getParents((EObject)partition, (EObject)dNodeContainer));
                    }
                    continue;
                }
                if (!(parent instanceof Part)) continue;
                parentElement = (Part)parent;
                if (partViews.get(parentElement).size() == 1) {
                    iterator = partViews.get(parentElement).iterator();
                    while (iterator.hasNext()) {
                        container = (DNodeContainer)iterator.next();
                        if (!container.getOwnedDiagramElements().contains((Object)dNodeContainer)) {
                            container.getOwnedDiagramElements().add((Object)dNodeContainer);
                        }
                        isAdded = true;
                    }
                } else if (partViews.get(parentElement).size() > 1) {
                    toBeDeleted = true;
                }
                if (isAdded || toBeDeleted) continue;
                parents.addAll(content.getParents(parent, (EObject)dNodeContainer));
            }
            if (!(isAdded || toBeDeleted || diagram.getOwnedDiagramElements().contains((Object)dNodeContainer))) {
                diagram.getOwnedDiagramElements().add((Object)dNodeContainer);
            }
            if (!toBeDeleted) continue;
            DiagramServices.getDiagramServices().removeContainerView((EObject)dNodeContainer);
        }
    }

    @Override
    protected List<AbstractNodeMapping> getListOfMappingsToMove(DDiagram diagram) {
        ArrayList<AbstractNodeMapping> returnedList = new ArrayList<AbstractNodeMapping>();
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "System Actors"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "System System"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "Logical Actors"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "LAB Logical Component"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "PAB_Actor"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "PAB_Deployment"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "PAB_PC"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "CI container mapping"));
        return returnedList;
    }

    public void postRefresh(DDiagram diagram) {
        try {
            FunctionalChainServices.getFunctionalChainServices().updateFunctionalChainStyles(diagram);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFunctionalChainStyle, (Throwable)e);
        }
        try {
            List<String> physicalPathSupportingDiagrams = Arrays.asList("Physical Architecture Blank", "System Architecture Blank", "Logical Architecture Blank");
            if (physicalPathSupportingDiagrams.contains(diagram.getDescription().getName())) {
                PhysicalServices.getService().updatePhysicalPathStyles(diagram);
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdatePhysicalPathStyle, (Throwable)e);
        }
    }

    @Deprecated
    public ContainerMapping getComponentMapping(DDiagram diagram) {
        if (diagram.getDescription().getName().equals("System Architecture Blank")) {
            return DiagramServices.getDiagramServices().getContainerMapping(diagram, "System Actors");
        }
        if (diagram.getDescription().getName().equals("Logical Architecture Blank")) {
            return DiagramServices.getDiagramServices().getContainerMapping(diagram, "LAB Logical Component");
        }
        if (diagram.getDescription().getName().equals("EPBS Architecture Blank")) {
            return DiagramServices.getDiagramServices().getContainerMapping(diagram, "LAB Logical Component");
        }
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, "PAB_PC");
    }
}

