/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorCapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractRefreshExtension;

public class ContextualCapabilityRefreshExtension
extends AbstractRefreshExtension
implements IRefreshExtension {
    public void beforeRefresh(DDiagram diagram) {
        DNode container;
        if (((DSemanticDecorator)diagram).getTarget() == null) {
            return;
        }
        LinkedList<Actor> actors = new LinkedList<Actor>();
        HashSet<Capability> capabilities = new HashSet<Capability>();
        LinkedList<Mission> missions = new LinkedList<Mission>();
        NodeMapping actorNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "ActorNode3");
        NodeMapping capaNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "Capability3");
        NodeMapping missionNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "MissionNode3");
        Capability capa = (Capability)((DSemanticDecorator)diagram).getTarget();
        for (ActorCapabilityInvolvement actorCapabilityInvolvement : capa.getInvolvedActors()) {
            actors.add(actorCapabilityInvolvement.getActor());
            for (GeneralizableElement elt : actorCapabilityInvolvement.getActor().getSuper()) {
                if (!(elt instanceof Actor)) continue;
                actors.add((Actor)elt);
            }
        }
        capabilities.add(capa);
        capabilities.addAll((Collection<Capability>)capa.getSuper());
        capabilities.addAll((Collection<Capability>)capa.getSub());
        capabilities.addAll((Collection<Capability>)capa.getExtendedAbstractCapabilities());
        capabilities.addAll((Collection<Capability>)capa.getIncludedAbstractCapabilities());
        missions.addAll((Collection<Mission>)CapellaServices.getService().getAllPurposeMission(capa));
        for (Actor actor : actors) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)actor)) continue;
            container = actorNodeMapping.createNode((EObject)actor, (EObject)capa, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
        for (AbstractCapability abstractCapability : capabilities) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)abstractCapability)) continue;
            container = capaNodeMapping.createNode((EObject)abstractCapability, (EObject)capa, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
        for (Mission mission : missions) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)mission)) continue;
            container = missionNodeMapping.createNode((EObject)mission, (EObject)capa, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
    }

    public void postRefresh(DDiagram diagram) {
    }
}

