/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractRefreshExtension;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.Messages;

public class DataFlowBlankRefreshExtension
extends AbstractRefreshExtension
implements IRefreshExtension {
    public void beforeRefresh(DDiagram diagram_p) {
        DDiagramContents context = FaServices.getFaServices().getDDiagramContents(diagram_p);
        try {
            List contextualElements = ContextualDiagramHelper.getService().getContextualElements((DRepresentation)diagram_p);
            FaServices.getFaServices().showDFContextualElements(context, contextualElements);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnContextualElements, (Throwable)e);
        }
        try {
            this.updateFunctionalExchangeCategories(context);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFECategories, (Throwable)e);
        }
        try {
            context.commitDeferredActions();
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnCommitDeferredActions, (Throwable)e);
        }
        try {
            FaServices.getFaServices().reorderFAElements(diagram_p);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnReordering, (Throwable)e);
        }
    }

    public void postRefresh(DDiagram diagram_p) {
        try {
            FunctionalChainServices.getFunctionalChainServices().updateFunctionalChainStyles(diagram_p);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFunctionalChainStyle, (Throwable)e);
        }
    }

    protected void updateFunctionalExchangeCategories(DDiagramContents context_p) {
        DDiagram diagram = context_p.getDDiagram();
        if (diagram.isSynchronized()) {
            FaServices service = FaServices.getFaServices();
            HashSet<EObject> categories = new HashSet<EObject>();
            EdgeMapping edgeMapping = service.getMappingFECategory(diagram);
            if (edgeMapping != null) {
                for (DDiagramElement element : context_p.getDiagramElements((DiagramElementMapping)edgeMapping)) {
                    if (element.getTarget() == null || !(element.getTarget() instanceof ExchangeCategory)) continue;
                    categories.add(element.getTarget());
                }
                FaServices.getFaServices().switchFECategories(context_p, (DSemanticDecorator)context_p.getDDiagram(), categories, false);
            }
        } else {
            FaServices.getFaServices().updateFECategories(context_p);
        }
    }
}

